///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/**
 * jQuery-Plugin "Expanded TextAreas" for expandable text areas. It is used for the JSF-Component "b:textarea".
 * Works with at least jQuery 1.7.
 *
 * How to use:
 * jQuery("#someTextAreaSelector").butterExpandable();
 */
(function ($) {
    // you have to extend jQuery with the fn["pluginName"] notation because in Typescript you can't extend
    // the existing typing interface with fn.pluginName!
    $.fn["butterExpandable"] = function () {
        return this.each(function (index, element) {
            var rootElement = $(element);
            if (rootElement.find("textarea").length > 0) {
                new ButterFaces.TextareaExpandable(rootElement);
            }
            else {
                new ButterFaces.DivExpandable(rootElement);
            }
        });
    };
})(jQuery);
var ButterFaces;
(function (ButterFaces) {
    var EXPAND_HEIGHT = 250; //in px
    var EXPAND_WIDTH = 500; //in px
    var ANIMATION_DURATION = 200; //in ms
    var REPOSITION_INTERVAL = 500; //in ms
    var EASING = "swing";
    var KEYCODE_ESCAPE = 27;
    var AbstractExpandable = /** @class */ (function () {
        function AbstractExpandable(rootElement) {
            this.rootElement = rootElement;
        }
        AbstractExpandable.prototype.expandElement = function (event) {
            var _this = this;
            if (this.isExpansionEventIgnored(event)) {
                return;
            }
            this.initialHeight = this.originalElement.outerHeight();
            this.initialWidth = this.originalElement.outerWidth();
            this.initialOffset = this.originalElement.offset();
            //create a ghost element that be animated on gets the focus
            this.ghostElement = this.createGhostElement();
            this.transferValueToGhostElement();
            this.ghostElement.css("width", this.initialWidth)
                .css("height", this.initialHeight)
                .css("position", "absolute")
                .css("top", this.initialOffset.top)
                .css("left", this.initialOffset.left)
                .css("z-index", 2000)
                .css("box-shadow", "5px 5px 5px 0 #999")
                .addClass("butter-component-expandable-ghost")
                .appendTo($("body"))
                .animate({
                height: EXPAND_HEIGHT,
                width: this.initialWidth > EXPAND_WIDTH ? this.initialWidth : EXPAND_WIDTH
            }, ANIMATION_DURATION, EASING, function () {
                $(document)
                    .on("click.expandable", function (event) {
                    _this.handleMouseClick(event);
                })
                    .on("keydown.expandable", function (event) {
                    _this.handleEscapeKey(event);
                });
                $(window).on("resize.expandable", function () {
                    _this.repositionGhostElement();
                });
                //keep track of the orginal element"s position
                _this.positionTriggerInterval = window.setInterval(function () { return _this.repositionGhostElement; }, REPOSITION_INTERVAL);
            });
            //make original invisible
            this.originalElement
                .css("visibility", "hidden")
                .siblings()
                .css("visibility", "hidden");
            this.onGhostElementCreated();
        };
        /**
         * Collapses the ghost element and sets the value if not isCancelled
         * @param isCancelled
         */
        AbstractExpandable.prototype.collapseElement = function (cancelled) {
            // "cancelled" can be an event object
            var isCancelled = typeof cancelled === "boolean" && cancelled;
            $(document)
                .off("click.expandable")
                .off("keydown.expandable");
            //make original visible again
            this.originalElement
                .css("visibility", "visible")
                .siblings()
                .css("visibility", "visible");
            var self = this;
            this.ghostElement.animate({
                height: self.initialHeight,
                width: self.initialWidth
            }, ANIMATION_DURATION, EASING, function () {
                //on animation complete
                self.onGhostElementCollapsed(isCancelled);
                //delete the ghost element
                self.ghostElement.remove();
                self.ghostElement = null;
                //delete position trigger timeout and resize listener
                window.clearInterval(self.positionTriggerInterval);
                $(window).off("resize.expandable");
            });
        };
        AbstractExpandable.prototype.handleMouseClick = function (event) {
            // collapse ghost element if user clicks beside it
            if (!$(event.target).is(".butter-component-expandable-ghost")) {
                this.collapseElement(false);
            }
        };
        AbstractExpandable.prototype.handleEscapeKey = function (event) {
            if (event.which === KEYCODE_ESCAPE) {
                this.collapseElement(true);
            }
        };
        AbstractExpandable.prototype.repositionGhostElement = function () {
            //keep track of window resizing and reposition the ghost element
            if (this.ghostElement !== undefined && this.ghostElement != null) {
                this.initialOffset = this.originalElement.offset();
                this.ghostElement
                    .css("top", this.initialOffset.top)
                    .css("left", this.initialOffset.left);
            }
        };
        return AbstractExpandable;
    }());
    var DivExpandable = /** @class */ (function (_super) {
        __extends(DivExpandable, _super);
        function DivExpandable(rootElement) {
            var _this = _super.call(this, rootElement) || this;
            _this.originalElement = _this.rootElement.find(".butter-component-value-readonly");
            _this.rearrangeOriginalElementStructure();
            return _this;
        }
        DivExpandable.prototype.rearrangeOriginalElementStructure = function () {
            var _this = this;
            var _label = this.rootElement.find(".butter-component-label");
            this.originalElement
                .addClass("butter-component-expandable-original")
                .click(function (event) {
                _this.expandElement(event);
            })
                .detach();
            var _container = $("<div>")
                .addClass("butter-component-expandable-readonly-container")
                .insertAfter(_label);
            var _icon = $("<span>").addClass("input-group-text glyphicon glyphicon-resize-full");
            this.originalElement.appendTo(_container);
            $("<div>")
                .addClass("butter-component-expandable-readonly-icon")
                .append(_icon)
                .appendTo(_container);
        };
        DivExpandable.prototype.createGhostElement = function () {
            return $("<div>");
        };
        DivExpandable.prototype.isExpansionEventIgnored = function (event) {
            return false;
        };
        DivExpandable.prototype.onGhostElementCreated = function () {
            // do nothing
        };
        DivExpandable.prototype.onGhostElementCollapsed = function (isCancelled) {
            // do nothing
        };
        DivExpandable.prototype.transferValueToGhostElement = function () {
            $("<div>")
                .html(this.originalElement.html())
                .addClass("butter-component-expandable-ghost-readonlyContent")
                .appendTo(this.ghostElement);
        };
        return DivExpandable;
    }(AbstractExpandable));
    ButterFaces.DivExpandable = DivExpandable;
    var TextareaExpandable = /** @class */ (function (_super) {
        __extends(TextareaExpandable, _super);
        function TextareaExpandable(rootElement) {
            var _this = _super.call(this, rootElement) || this;
            _this.blockFocusEventOnOriginal = false;
            _this.blockBlurEventOnOriginal = false;
            _this.originalElement = _this.rootElement.find("textarea");
            _this.originalElement.addClass("butter-component-expandable-original");
            _this.originalElement.focus(function (event) {
                _this.expandElement(event);
            });
            _this.originalElement.blur(function (event) {
                _this.handleBlurEvent(event);
            });
            _this.addInputGroupAddon();
            return _this;
        }
        TextareaExpandable.prototype.addInputGroupAddon = function () {
            this.originalElement
                .addClass("form-control")
                .parent()
                .addClass("input-group");
            $("<span class=\"input-group-append\"><span class=\"input-group-text glyphicon glyphicon-resize-full\"></span></span>")
                .insertAfter(this.originalElement);
        };
        TextareaExpandable.prototype.handleBlurEvent = function (event) {
            if (this.blockBlurEventOnOriginal) {
                // prevent blur event bubbling, so it will not be triggered in jsf
                event.preventDefault();
            }
        };
        TextareaExpandable.prototype.createGhostElement = function () {
            return $("<textarea>");
        };
        TextareaExpandable.prototype.isExpansionEventIgnored = function (event) {
            this.blockBlurEventOnOriginal = true;
            if (this.blockFocusEventOnOriginal) {
                event.preventDefault();
                return true;
            }
            else {
                return false;
            }
        };
        TextareaExpandable.prototype.onGhostElementCreated = function () {
            var _this = this;
            this.ghostElement
                .blur(function (event) {
                _this.collapseElement(event);
            })
                .focus();
            this.moveCaretToEnd(this.ghostElement);
        };
        TextareaExpandable.prototype.onGhostElementCollapsed = function (isCancelled) {
            var _this = this;
            if (!isCancelled) {
                //transfer value back from ghost to original
                this.originalElement.val(this.ghostElement.val());
                // trigger blur and keyup event on original textarea and don"t block
                // it for jsf
                this.blockBlurEventOnOriginal = false;
                this.blockFocusEventOnOriginal = true;
                // defer the events a little bit, look at
                // (http://stackoverflow.com/questions/8380759/why-isnt-this-textarea-focusing-with-focus#8380785)
                window.setTimeout(function () {
                    _this.originalElement.trigger("keyup");
                    _this.originalElement.trigger("change");
                    _this.originalElement.trigger("blur");
                    _this.blockFocusEventOnOriginal = false;
                }, 50);
            }
            else {
                this.blockBlurEventOnOriginal = true;
                this.blockFocusEventOnOriginal = false;
            }
        };
        TextareaExpandable.prototype.transferValueToGhostElement = function () {
            this.ghostElement.val(this.originalElement.val());
        };
        TextareaExpandable.prototype.moveCaretToEnd = function (element) {
            if (typeof element.selectionStart === "number") {
                element.selectionStart = element.selectionEnd = element.value.length;
            }
            else if (typeof element.createTextRange !== "undefined") {
                var range = element.createTextRange();
                range.collapse(false);
                range.select();
            }
            else {
                var strLength = this.ghostElement.val().length * 2;
                this.ghostElement.get(0).setSelectionRange(strLength, strLength);
            }
        };
        return TextareaExpandable;
    }(AbstractExpandable));
    ButterFaces.TextareaExpandable = TextareaExpandable;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
