/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.partrenderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.butterfaces.component.html.HtmlInputComponent;

public class ReadonlyPartRenderer {
    public void renderReadonly(HtmlInputComponent component, ResponseWriter writer) throws IOException {
        UIInput uiComponent = (UIInput)component;
        boolean readonly = component.isReadonly();
        Object value = component.getValue();
        if (readonly) {
            writer.startElement("div", (UIComponent)uiComponent);
            StringBuilder sb = new StringBuilder("butter-component-value butter-flex-grow");
            sb.append(" butter-component-value-readonly mt-2");
            if (component.isHideLabel()) {
                sb.append(" butter-component-value-hiddenLabel");
            }
            writer.writeAttribute("class", (Object)sb.toString(), null);
            this.renderInnerReadonlyPart(uiComponent, value, writer);
            writer.endElement("div");
        }
    }

    protected void renderInnerReadonlyPart(UIInput uiComponent, Object value, ResponseWriter writer) throws IOException {
        writer.startElement("span", (UIComponent)uiComponent);
        writer.writeAttribute("class", (Object)"butter-component-value-readonly-wrapper", "styleClass");
        writer.writeText((Object)this.getReadonlyDisplayValue(value, uiComponent, uiComponent.getConverter()), null);
        writer.endElement("span");
    }

    private String getReadonlyDisplayValue(Object value, UIInput component, Converter converter) {
        if (value == null || "".equals(value)) {
            return "-";
        }
        if (converter != null) {
            String asString = converter.getAsString(FacesContext.getCurrentInstance(), (UIComponent)component, value);
            return asString == null ? "-" : asString;
        }
        return String.valueOf(value);
    }
}

