/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.html.HtmlRadioBox;
import org.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import org.butterfaces.context.StringHtmlEncoder;
import org.butterfaces.resolver.MustacheResolver;
import org.butterfaces.util.ReflectionUtil;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.component.renderkit.html_basic.RadioBox2Renderer")
public class RadioBoxRenderer
extends AbstractHtmlTagRenderer<HtmlRadioBox> {
    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeBegin(context, component, "butter-component-radiobox");
    }

    @Override
    protected void encodeEnd(HtmlRadioBox component, ResponseWriter writer) throws IOException {
        writer.startElement("script", (UIComponent)component);
        writer.writeText((Object)"jQuery(function () {\n", null);
        writer.writeText((Object)("ButterFaces.RadioBox.addStyleClassClickEvent('" + component.getClientId() + "');\n"), null);
        writer.writeText((Object)"});", null);
        writer.endElement("script");
    }

    @Override
    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (component instanceof HtmlRadioBox) {
            HtmlRadioBox radioBox = (HtmlRadioBox)component;
            String radioBoxClientId = radioBox.getClientId();
            char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
            if (radioBox.getValues() instanceof Iterable) {
                int index = 0;
                for (Object value : (Iterable)radioBox.getValues()) {
                    this.renderRadioBoxItem(writer, radioBox, radioBoxClientId, separatorChar, index, value);
                    ++index;
                }
            }
        }
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (!(component instanceof HtmlRadioBox)) {
            return;
        }
        HtmlRadioBox radioBox = (HtmlRadioBox)component;
        if (!component.isRendered() || radioBox.isReadonly()) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Object item = this.findItemInValues((Iterable)radioBox.getValues(), (String)requestMap.get(clientId));
        String itemAsString = item != null ? this.convertItemToIdentifier(item) : null;
        this.setSubmittedValue(component, itemAsString);
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        HtmlRadioBox radioBox = (HtmlRadioBox)component;
        return submittedValue != null ? this.findItemInValues((Iterable)radioBox.getValues(), submittedValue.toString()) : null;
    }

    @Override
    protected void setSubmittedValue(UIComponent component, Object value) {
        super.setSubmittedValue(component, value != null ? value : "");
    }

    private void renderRadioBoxItem(ResponseWriter writer, HtmlRadioBox radioBox, String radioBoxClientId, char separatorChar, int index, Object listItem) throws IOException {
        String radioItemClientId = radioBoxClientId + separatorChar + index;
        boolean valueSelected = this.isValueSelected(radioBox.getValue(), listItem);
        writer.startElement("div", (UIComponent)radioBox);
        StringBuilder styleClass = new StringBuilder(valueSelected ? "radio butter-radio-item-selected" : "radio");
        styleClass.append(" d-flex");
        if (index == 0) {
            styleClass.append(" mt-2");
        }
        writer.writeAttribute("class", (Object)styleClass.toString(), "class");
        writer.startElement("input", (UIComponent)radioBox);
        writer.writeAttribute("id", (Object)radioItemClientId, "clientId");
        writer.writeAttribute("type", (Object)"radio", "input");
        writer.writeAttribute("name", (Object)radioBoxClientId, "name");
        writer.writeAttribute("value", (Object)this.convertItemToIdentifier(listItem), "value");
        writer.writeAttribute("class", (Object)"mt-1 mr-2", "class");
        if (valueSelected) {
            writer.writeAttribute("checked", (Object)true, "checked");
        }
        this.renderBooleanValue((UIComponent)radioBox, writer, "disabled");
        this.renderBooleanValue((UIComponent)radioBox, writer, "ismap");
        this.renderStringValue((UIComponent)radioBox, writer, "alt");
        this.renderStringValue((UIComponent)radioBox, writer, "dir");
        this.renderStringValue((UIComponent)radioBox, writer, "lang");
        this.renderStringValue((UIComponent)radioBox, writer, "role");
        this.renderStringValue((UIComponent)radioBox, writer, "tabindex");
        this.renderStringValue((UIComponent)radioBox, writer, "title");
        this.renderEventValue((UIComponent)radioBox, writer, "onblur", "blur");
        this.renderEventValue((UIComponent)radioBox, writer, "onclick", "click");
        this.renderEventValue((UIComponent)radioBox, writer, "ondblclick", "dblclick");
        this.renderEventValue((UIComponent)radioBox, writer, "onfocus", "focus");
        this.renderEventValue((UIComponent)radioBox, writer, "onkeydown", "keydown");
        this.renderEventValue((UIComponent)radioBox, writer, "onkeypress", "keypress");
        this.renderEventValue((UIComponent)radioBox, writer, "onkeyup", "keyup");
        this.renderEventValue((UIComponent)radioBox, writer, "onmousedown", "mousedown");
        this.renderEventValue((UIComponent)radioBox, writer, "onmousemove", "mousemove");
        this.renderEventValue((UIComponent)radioBox, writer, "onmouseout", "mouseout");
        this.renderEventValue((UIComponent)radioBox, writer, "onmouseover", "mouseover");
        this.renderEventValue((UIComponent)radioBox, writer, "onmouseup", "mouseup");
        this.renderEventValue((UIComponent)radioBox, writer, "onselect", "select");
        this.renderEventValue((UIComponent)radioBox, writer, "onchange", "change");
        writer.endElement("input");
        writer.startElement("label", (UIComponent)radioBox);
        writer.writeAttribute("for", (Object)radioItemClientId, "for");
        if (radioBox.getFacet("template") != null) {
            String encodedTemplate = StringHtmlEncoder.encodeComponentWithSurroundingDiv(FacesContext.getCurrentInstance(), radioBox.getFacet("template"));
            List<String> mustacheKeys = MustacheResolver.getMustacheKeys(encodedTemplate);
            for (String mustacheKey : mustacheKeys) {
                String stringValueFromObject = new ReflectionUtil().getStringValueFromObject(listItem, mustacheKey);
                if (!StringUtils.isNotEmpty(stringValueFromObject)) continue;
                encodedTemplate = encodedTemplate.replaceAll("\\{\\{" + mustacheKey + "\\}\\}", stringValueFromObject);
            }
            writer.write(encodedTemplate);
        } else {
            writer.writeText((Object)this.convertItemToText(listItem), (UIComponent)radioBox, null);
        }
        writer.endElement("label");
        writer.endElement("div");
    }

    private boolean isValueSelected(Object radioBoxValue, Object value) {
        return radioBoxValue != null && radioBoxValue.equals(value);
    }

    private Object findItemInValues(Iterable values, String identifier) {
        if (StringUtils.isEmpty(identifier) || values == null) {
            return null;
        }
        for (Object value : values) {
            if (!this.convertItemToIdentifier(value).equals(identifier)) continue;
            return value;
        }
        return null;
    }

    private String convertItemToIdentifier(Object listItem) {
        return this.convertItemToText(listItem);
    }

    private String convertItemToText(Object listItem) {
        if (listItem instanceof SelectItem) {
            return ((SelectItem)listItem).getLabel();
        }
        return listItem.toString();
    }
}

