/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.table.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import org.butterfaces.component.html.table.HtmlColumn;
import org.butterfaces.component.html.table.HtmlTable;
import org.butterfaces.model.table.TableColumnOrdering;
import org.butterfaces.model.table.json.Ordering;

public class TableColumnCache {
    public static final String KEY = TableColumnCache.class.getName();
    private final List<HtmlColumn> cachedColumns;

    public TableColumnCache(HtmlTable table) {
        this.cachedColumns = TableColumnCache.buildCache((UIComponent)table);
        TableColumnCache.orderColumns(table, this.cachedColumns);
    }

    public List<HtmlColumn> getCachedColumns() {
        return this.cachedColumns;
    }

    private static void orderColumns(final HtmlTable table, List<HtmlColumn> cachedColumns) {
        if (table.getTableOrderingModel() != null) {
            ArrayList<HtmlColumn> notOrderedByModelColumnIdentifiers = new ArrayList<HtmlColumn>();
            ArrayList<Ordering> existingOrderings = new ArrayList<Ordering>();
            for (HtmlColumn htmlColumn : cachedColumns) {
                Integer n = table.getTableOrderingModel().getOrderPosition(table.getModelUniqueIdentifier(), htmlColumn.getModelUniqueIdentifier());
                if (n == null) {
                    notOrderedByModelColumnIdentifiers.add(htmlColumn);
                    continue;
                }
                existingOrderings.add(new Ordering(htmlColumn.getModelUniqueIdentifier(), n));
            }
            if (!notOrderedByModelColumnIdentifiers.isEmpty()) {
                Ordering.sort(existingOrderings);
                ArrayList<String> orderings = new ArrayList<String>();
                for (Ordering ordering : existingOrderings) {
                    orderings.add(ordering.getIdentifier());
                }
                for (HtmlColumn htmlColumn : notOrderedByModelColumnIdentifiers) {
                    orderings.add(htmlColumn.getModelUniqueIdentifier());
                }
                TableColumnOrdering tableColumnOrdering = new TableColumnOrdering(table.getModelUniqueIdentifier(), orderings);
                table.getTableOrderingModel().update(tableColumnOrdering);
            }
            Collections.sort(cachedColumns, new Comparator<HtmlColumn>(){

                @Override
                public int compare(HtmlColumn o1, HtmlColumn o2) {
                    if (table.getTableOrderingModel() != null) {
                        Integer orderPosition = table.getTableOrderingModel().getOrderPosition(table.getModelUniqueIdentifier(), o1.getModelUniqueIdentifier());
                        Integer o2OrderPosition = table.getTableOrderingModel().getOrderPosition(table.getModelUniqueIdentifier(), o2.getModelUniqueIdentifier());
                        if (orderPosition != null && o2OrderPosition != null) {
                            return orderPosition.compareTo(o2OrderPosition);
                        }
                    }
                    return 0;
                }
            });
        }
    }

    private static List<HtmlColumn> buildCache(UIComponent table) {
        if (table instanceof UIData) {
            int childCount = table.getChildCount();
            if (childCount > 0) {
                ArrayList<HtmlColumn> results = new ArrayList<HtmlColumn>(childCount);
                for (UIComponent kid : table.getChildren()) {
                    if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
                    results.add((HtmlColumn)kid);
                }
                return results;
            }
            return Collections.emptyList();
        }
        Object value = table.getAttributes().get("cachedColumns");
        int count = value != null && value instanceof Integer ? (Integer)value : 2;
        if (count < 1) {
            count = 1;
        }
        ArrayList<HtmlColumn> result = new ArrayList<HtmlColumn>(count);
        for (int i = 0; i < count; ++i) {
            result.add(new HtmlColumn());
        }
        return result;
    }
}

