/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.text;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.html.text.HtmlTreeBox;
import org.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import org.butterfaces.component.partrenderer.RenderUtils;
import org.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import org.butterfaces.component.renderkit.html_basic.text.model.CachedNodesInitializer;
import org.butterfaces.component.renderkit.html_basic.text.model.TreeBoxModelType;
import org.butterfaces.component.renderkit.html_basic.text.model.TreeBoxModelWrapper;
import org.butterfaces.component.renderkit.html_basic.text.part.TrivialComponentsEntriesNodePartRenderer;
import org.butterfaces.component.renderkit.html_basic.text.util.TrivialComponentsUtil;
import org.butterfaces.context.StringHtmlEncoder;
import org.butterfaces.model.tree.EnumTreeBoxWrapper;
import org.butterfaces.model.tree.Node;
import org.butterfaces.resolver.WebXmlParameters;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.component.renderkit.html_basic.TreeBoxRenderer")
public class TreeBoxRenderer
extends AbstractHtmlTagRenderer<HtmlTreeBox> {
    public static final String DEFAULT_SINGLE_LINE_OF_TEXT_TEMPLATE = "<div class=\"tr-template-single-line\">  <div class=\"content-wrapper tr-editor-area\">     <div>{{butterObjectToString}}</div>   </div></div>";

    @Override
    protected boolean encodeReadonly() {
        return false;
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component, "butter-component-treebox");
    }

    @Override
    protected void appendEncodeBegin(HtmlTreeBox treeBox, ResponseWriter writer) throws IOException {
        String clientIdSeparator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()));
        String treeBoxReadableId = treeBox.getClientId().replace(clientIdSeparator, "_");
        writer.writeAttribute("data-tree-box-id", (Object)treeBoxReadableId, null);
    }

    @Override
    protected void encodeEnd(HtmlTreeBox treeBox, ResponseWriter writer) throws IOException {
        if (!treeBox.isReadonly() || treeBox.getValue() != null) {
            TreeBoxModelWrapper treeBoxModelWrapper = new TreeBoxModelWrapper(treeBox);
            List<Node> nodes = treeBoxModelWrapper.getNodes();
            TreeBoxModelType treeBoxModelType = treeBoxModelWrapper.getTreeBoxModelType();
            List<String> mustacheKeys = TrivialComponentsUtil.createMustacheKeys(FacesContext.getCurrentInstance(), (UIComponentBase)treeBox);
            String clientIdSeparator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()));
            String treeBoxReadableId = treeBox.getClientId().replace(clientIdSeparator, "_");
            String jQueryBySelector = RenderUtils.createJQueryBySelector(treeBox.getClientId(), "input");
            Map<Integer, Node> nodesMap = CachedNodesInitializer.createNodesMap(nodes);
            String treeOptions = TrivialComponentsUtil.replaceDotInMustacheKeys(mustacheKeys, this.createTreeOptions(treeBox, treeBoxModelType, mustacheKeys, nodesMap));
            writer.startElement("script", (UIComponent)treeBox);
            writer.writeText((Object)"jQuery(function () {\n", null);
            writer.writeText((Object)("var entries_" + treeBoxReadableId + " = " + new TrivialComponentsEntriesNodePartRenderer().renderEntriesAsJSON(nodes, TrivialComponentsUtil.replaceDotInMustacheKeys(mustacheKeys), nodesMap) + ";\n"), null);
            writer.writeText((Object)("ButterFaces.TreeBox.removeTrivialTreeDropDown('" + treeBoxReadableId + "');\n"), null);
            writer.writeText((Object)("var trivialTreeOptions" + treeBoxReadableId + " = " + treeOptions + ";\n"), null);
            if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
                writer.writeText((Object)("var trivialTree" + treeBoxReadableId + " = ButterFaces.createTrivialComboBox(" + jQueryBySelector + ",trivialTreeOptions" + treeBoxReadableId + ");\n"), null);
            } else {
                writer.writeText((Object)("var trivialTree" + treeBoxReadableId + " = ButterFaces.createTrivialTreeComboBox(" + jQueryBySelector + ",trivialTreeOptions" + treeBoxReadableId + ");\n"), null);
            }
            writer.writeText((Object)("$(trivialTree" + treeBoxReadableId + ".getDropDown()).attr('data-tree-box-id', '" + treeBoxReadableId + "')"), null);
            writer.writeText((Object)"});", null);
            writer.endElement("script");
        }
    }

    private String createTreeOptions(HtmlTreeBox treeBox, TreeBoxModelType treeBoxModelType, List<String> mustacheKeys, Map<Integer, Node> nodesMap) throws IOException {
        StringBuilder options = new StringBuilder();
        FacesContext context = FacesContext.getCurrentInstance();
        Integer selectedEntryId = this.findValueInCachedNodes(treeBox.getValue(), treeBoxModelType, nodesMap);
        Node selectedNode = selectedEntryId != null ? nodesMap.get(selectedEntryId) : null;
        String editable = TrivialComponentsEntriesNodePartRenderer.getEditingMode(treeBox);
        WebXmlParameters webXmlParameters = new WebXmlParameters(context.getExternalContext());
        String noMatchingText = StringUtils.getNotNullValue(treeBox.getNoEntriesText(), webXmlParameters.getNoEntriesText());
        String spinnerText = StringUtils.getNotNullValue(treeBox.getSpinnerText(), webXmlParameters.getSpinnerText());
        options.append("{");
        options.append("\n    allowFreeText: false,");
        if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
            options.append("\n    valueProperty: 'id',");
        }
        if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
            options.append("\n    inputTextProperty: '" + StringUtils.getNotNullValue(treeBox.getInputTextProperty(), "butterObjectToString") + "',");
        } else {
            options.append("\n    inputTextProperty: '" + StringUtils.getNotNullValue(treeBox.getInputTextProperty(), "title") + "',");
        }
        if (treeBox.getFacet("emptyEntryTemplate") != null) {
            options.append("\n    emptyEntryTemplate: '" + StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, treeBox.getFacet("emptyEntryTemplate")) + "',");
        } else if (StringUtils.isNotEmpty(treeBox.getPlaceholder())) {
            options.append("\n    emptyEntryTemplate: '<div class=\"defaultEmptyEntry\">" + treeBox.getPlaceholder() + "</div>',");
        }
        options.append("\n    editingMode: '" + editable + "',");
        options.append("\n    showClearButton: ").append(this.evaluateShowClearButtonValue(treeBox, webXmlParameters)).append(",");
        if (selectedEntryId != null && selectedNode != null) {
            options.append("\n    selectedEntry: " + new TrivialComponentsEntriesNodePartRenderer().renderNode(mustacheKeys, nodesMap, selectedEntryId, selectedNode) + ",");
        }
        if (treeBox.getFacet("selectedEntryTemplate") != null) {
            options.append("\n    selectedEntryTemplate: '" + StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, treeBox.getFacet("selectedEntryTemplate")) + "',");
        }
        if (treeBox.getFacet("template") != null) {
            String encodedTemplate = StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, treeBox.getFacet("template"));
            if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
                options.append("\n    template: '" + encodedTemplate + "',");
            } else {
                options.append("\n    templates: ['" + encodedTemplate + "'],");
            }
        } else if (treeBoxModelType == TreeBoxModelType.NODES) {
            options.append("\n    templates: ['<div class=\"tr-template-icon-2-lines tr-tree-entry filterable-item {{styleClass}}\">  <div class=\"img-wrapper {{imageClass}}\" style=\"{{imageStyle}}\"></div>  <div class=\"content-wrapper tr-editor-area\">     <div class=\"main-line\">{{title}}</div>     <div class=\"additional-info\">{{description}}</div>  </div></div>'],");
        } else if (treeBoxModelType == TreeBoxModelType.OBJECTS) {
            options.append("\n    template: '<div class=\"tr-template-single-line\">  <div class=\"content-wrapper tr-editor-area\">     <div>{{butterObjectToString}}</div>   </div></div>',");
        }
        options.append("\n    spinnerTemplate: '<div class=\"tr-default-spinner\"><div class=\"spinner\"></div><div>" + spinnerText + "</div></div>',");
        options.append("\n    noEntriesTemplate: '<div class=\"tr-default-no-data-display\"><div>" + noMatchingText + "</div></div>',");
        options.append("\n    entries: entries_" + treeBox.getClientId().replace(":", "_"));
        options.append("\n}");
        return options.toString();
    }

    @Override
    protected void encodeInnerEnd(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlTreeBox treeBox = (HtmlTreeBox)component;
        if (treeBox.isReadonly()) {
            if (treeBox.getValue() == null) {
                new ReadonlyPartRenderer().renderReadonly(treeBox, writer);
            } else {
                writer.startElement("div", component);
                writer.writeAttribute("class", (Object)"butter-component-value butter-flex-grow", null);
                super.encodeSuperEnd(FacesContext.getCurrentInstance(), component);
                writer.endElement("div");
            }
        }
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue == null || "".equals(submittedValue)) {
            return null;
        }
        String newValue = (String)submittedValue;
        HtmlTreeBox treeBox = (HtmlTreeBox)component;
        TreeBoxModelWrapper treeBoxModelWrapper = new TreeBoxModelWrapper(treeBox);
        TreeBoxModelType treeBoxModelType = treeBoxModelWrapper.getTreeBoxModelType();
        List<Node> nodes = treeBoxModelWrapper.getNodes();
        Map<Integer, Node> nodesMap = CachedNodesInitializer.createNodesMap(nodes);
        Integer selectedIndex = Integer.valueOf(newValue);
        Node node = nodesMap.get(selectedIndex);
        return treeBoxModelType == TreeBoxModelType.OBJECTS && node != null ? (node.getData() instanceof EnumTreeBoxWrapper ? ((EnumTreeBoxWrapper)node.getData()).getEnumValue() : node.getData()) : node;
    }

    boolean evaluateShowClearButtonValue(HtmlTreeBox treeBox, WebXmlParameters webXmlParameters) {
        boolean showClearButtonConf = treeBox.getShowClearButton() == null ? webXmlParameters.isShowTreeBoxClearButton() : treeBox.getShowClearButton().booleanValue();
        return showClearButtonConf;
    }

    private Integer findValueInCachedNodes(Object treeBoxValue, TreeBoxModelType treeBoxModelType, Map<Integer, Node> nodesMap) {
        block3: {
            block2: {
                if (treeBoxModelType != TreeBoxModelType.OBJECTS || treeBoxValue == null) break block2;
                for (Integer index : nodesMap.keySet()) {
                    Node node = nodesMap.get(index);
                    if (node.getData() == null || !node.getData().equals(treeBoxValue)) continue;
                    return index;
                }
                break block3;
            }
            if (treeBoxValue == null) break block3;
            for (Integer index : nodesMap.keySet()) {
                Node node = nodesMap.get(index);
                if (!node.equals(treeBoxValue)) continue;
                return index;
            }
        }
        return null;
    }
}

