/*
 * Decompiled with CFR 0.152.
 */
package org.catools.zapi.configs;

import org.catools.common.collections.CHashMap;
import org.catools.common.collections.CList;
import org.catools.common.config.CConfigs;

public class CZApiConfigs
extends CConfigs {

    public static class ZApi {
        public static final CHashMap<String, String> statusMap = new CHashMap();

        public static String getZApiUri() {
            return CConfigs.getConfigs().getString((Enum)Configs.ZAPI_HOME);
        }

        public static CHashMap<String, String> getStatusMap() {
            if (!statusMap.isEmpty()) {
                return statusMap;
            }
            for (String[] strings : CConfigs.getConfigs().getStrings((Enum)Configs.ZAPI_STATUS_MAP, ",").mapToSet(s -> s.split(":"))) {
                statusMap.put((Object)strings[0].trim(), (Object)strings[1].trim());
            }
            assert (statusMap.isNotEmpty());
            return statusMap;
        }

        public static String getUserName() {
            return CConfigs.getConfigs().getString((Enum)Configs.ZAPI_USERNAME);
        }

        public static String getPassword() {
            return CConfigs.getConfigs().getString((Enum)Configs.ZAPI_PASSWORD);
        }

        public static String getCycleName() {
            return CConfigs.getConfigs().getString((Enum)Configs.ZAPI_CYCLE_NAME);
        }

        public static String getDateSplitter() {
            return CConfigs.getConfigs().getString((Enum)Configs.ZAPI_DATE_SPLITTER);
        }

        public static CList<String> getDateFormats() {
            return CConfigs.getConfigs().getStrings((Enum)Configs.ZAPI_DATE_FORMAT, ZApi.getDateSplitter());
        }

        public static int getSearchBufferSize() {
            return CConfigs.getConfigs().getInteger((Enum)Configs.ZAPI_SEARCH_BUFFER_SIZE);
        }

        public static enum Configs {
            ZAPI_HOME,
            ZAPI_USERNAME,
            ZAPI_PASSWORD,
            ZAPI_CYCLE_NAME,
            ZAPI_STATUS_MAP,
            ZAPI_DATE_FORMAT,
            ZAPI_DATE_SPLITTER,
            ZAPI_SEARCH_BUFFER_SIZE;

        }
    }
}

