/*
 * Decompiled with CFR 0.152.
 */
package org.catools.zapi.parser;

import com.fasterxml.jackson.databind.Module;
import io.restassured.response.Response;
import org.catools.common.json.CJsonUtil;
import org.catools.zapi.exception.CZApiClientException;
import org.catools.zapi.model.CZApiExecution;
import org.catools.zapi.model.CZApiExecutionDefects;
import org.catools.zapi.model.CZApiExecutions;
import org.catools.zapi.parser.CZApiBaseParser;
import org.json.JSONArray;
import org.json.JSONObject;

public class CZApiExecutionsParser
extends CZApiBaseParser {
    public static CZApiExecutions parse(Response response) {
        CZApiExecutions output = new CZApiExecutions();
        try {
            JSONObject input = new JSONObject(response.body().asString());
            JSONObject status = input.optJSONObject("status");
            JSONArray executions = input.optJSONArray("executions");
            for (int i = 0; i < executions.length(); ++i) {
                JSONObject json = executions.getJSONObject(i);
                CZApiExecution execution = new CZApiExecution();
                execution.setId(json.optLong("id"));
                execution.setOrderId(json.optLong("orderId"));
                if (status == null) {
                    execution.setExecutionStatus(json.getJSONObject("status").getString("name"));
                } else {
                    execution.setExecutionStatus(status.getJSONObject(json.getString("executionStatus")).getString("name"));
                }
                execution.setExecutedOn(CZApiExecutionsParser.getDate(json, "executedOn"));
                execution.setExecutedByUserName(json.optString("executedByUserName"));
                execution.setComment(json.optString("comment"));
                execution.setCycleId(json.optLong("cycleId"));
                execution.setCycleName(json.optString("cycleName"));
                execution.setVersionName(json.optString("versionName"));
                execution.setProjectKey(json.optString("projectKey"));
                execution.setProjectName(json.optString("project"));
                execution.setCreatedOn(CZApiExecutionsParser.getDate(json, "creationDate"));
                execution.setIssueId(json.optLong("issueId"));
                execution.setIssueKey(json.optString("issueKey"));
                execution.setExecutionDefectCount(json.optLong("executionDefectCount"));
                execution.setStepDefectCount(json.optLong("stepDefectCount"));
                execution.setTotalDefectCount(json.optLong("totalDefectCount"));
                if (json.has("executionDefects")) {
                    execution.setExecutionDefects((CZApiExecutionDefects)((Object)CJsonUtil.read((String)json.optString("executionDefects"), CZApiExecutionDefects.class, (Module[])new Module[0])));
                }
                output.add(execution);
            }
        }
        catch (Throwable t) {
            throw new CZApiClientException("Could not parse input to JSON Array. input: " + response.body().asString(), t);
        }
        return output;
    }
}

