/*
 * Decompiled with CFR 0.152.
 */
package org.catools.zapi.rest.zql;

import io.restassured.RestAssured;
import io.restassured.specification.RequestSpecification;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.catools.common.concurrent.CParallelIO;
import org.catools.common.date.CDate;
import org.catools.zapi.configs.CZApiConfigs;
import org.catools.zapi.exception.CZApiClientException;
import org.catools.zapi.model.CZApiExecutions;
import org.catools.zapi.parser.CZApiExecutionsParser;
import org.catools.zapi.rest.CZApiRestClient;

public class CZApiSearchClient
extends CZApiRestClient {
    public CZApiExecutions getExecutions(String zql) {
        return this.getExecutions(zql, null, 1, 1, null);
    }

    public CZApiExecutions getExecutions(String zql, Date lastSyncDate) {
        return this.getExecutions(zql, lastSyncDate, 1, 1, null);
    }

    public CZApiExecutions getExecutions(String zql, int parallelInputCount) {
        return this.getExecutions(zql, null, parallelInputCount, 1, null);
    }

    public CZApiExecutions getExecutions(String zql, Date lastSyncDate, int parallelInputCount) {
        return this.getExecutions(zql, lastSyncDate, parallelInputCount, 1, null);
    }

    public CZApiExecutions getExecutions(String zql, int parallelInputCount, int parallelOutputCount, Consumer<CZApiExecutions> supplier) {
        return this.getExecutions(zql, null, parallelInputCount, parallelOutputCount, supplier);
    }

    public CZApiExecutions getExecutions(String zql, Date lastSyncDate, int parallelInputCount, int parallelOutputCount, Consumer<CZApiExecutions> supplier) {
        CZApiExecutions executions = new CZApiExecutions();
        CParallelIO parallelIO = new CParallelIO("Search ZApi Executions", parallelInputCount, parallelOutputCount);
        int maxResult = CZApiConfigs.ZApi.getSearchBufferSize();
        AtomicInteger counter = new AtomicInteger(0);
        parallelIO.setInputExecutor(eof -> {
            int startAt = counter.getAndIncrement() * maxResult;
            CZApiExecutions search = this._getExecutions(zql, lastSyncDate, startAt, maxResult);
            if (search.isEmpty()) {
                eof.set(true);
            } else {
                executions.addAll((Collection)((Object)search));
            }
            return search;
        });
        parallelIO.setOutputExecutor((eof, issues) -> {
            if (supplier != null && issues != null && issues.isNotEmpty()) {
                supplier.accept((CZApiExecutions)((Object)issues));
            }
        });
        try {
            parallelIO.run();
        }
        catch (Throwable t) {
            throw new CZApiClientException("Could not finish search.", t);
        }
        return executions;
    }

    private CZApiExecutions _getExecutions(String zql, Date lastSyncDate, int offset, int maxResults) {
        if (lastSyncDate != null) {
            zql = (String)zql + String.format(" AND (creationDate >= '%1$s' or executionDate >= '%1$s')", new CDate(lastSyncDate).toFormat("yyyy/MM/dd"));
        }
        logger.info("Execute Search {}, maxResults:{}, startAt:{}, fields:{}", new Object[]{zql, maxResults, offset});
        RequestSpecification specification = RestAssured.given().baseUri(CZApiConfigs.ZApi.getZApiUri()).basePath("/zql/executeSearch").queryParam("zqlQuery", new Object[]{zql}).queryParam("offset", new Object[]{offset}).queryParam("maxRecords", new Object[]{maxResults});
        return CZApiExecutionsParser.parse(this.get(specification));
    }
}

