/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.source.consul;

import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.model.kv.Value;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.SourceCommunicationException;
import org.cfg4j.source.context.environment.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsulConfigurationSource
implements ConfigurationSource {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulConfigurationSource.class);
    private final KeyValueClient kvClient;
    private Map<String, String> consulValues;

    ConsulConfigurationSource(String host, int port) {
        try {
            LOG.info("Connecting to Consul client at " + host + ":" + port);
            Consul consul = Consul.newClient((String)host, (int)port);
            this.kvClient = consul.keyValueClient();
        }
        catch (Exception e) {
            throw new SourceCommunicationException("Can't connect to host " + host + ":" + port, e);
        }
        this.reload();
    }

    public Properties getConfiguration(Environment environment) {
        LOG.trace("Requesting configuration for environment: " + environment.getName());
        Properties properties = new Properties();
        String path = environment.getName();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        for (Map.Entry<String, String> entry : this.consulValues.entrySet()) {
            if (!entry.getKey().startsWith(path)) continue;
            properties.put(entry.getKey().substring(path.length()).replace("/", "."), entry.getValue());
        }
        return properties;
    }

    public void reload() {
        List valueList;
        this.consulValues = new HashMap<String, String>();
        try {
            LOG.debug("Reloading configuration from Consuls' K-V store");
            valueList = this.kvClient.getValues("/");
        }
        catch (Exception e) {
            throw new SourceCommunicationException("Can't get values from k-v store", e);
        }
        for (Value value : valueList) {
            String val = new String(Base64.getDecoder().decode(value.getValue().getBytes(StandardCharsets.UTF_8)));
            LOG.trace("Consul provided configuration key: " + value.getKey() + " with value: " + val);
            this.consulValues.put(value.getKey(), val);
        }
    }

    public String toString() {
        return "ConsulConfigurationSource{consulValues=" + this.consulValues + ", kvClient=" + this.kvClient + '}';
    }
}

