/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.InfoPayloadRootProvider;
import org.cloudfoundry.reactor.RootPayloadRootProvider;
import org.immutables.value.Value;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Value.Immutable
abstract class _DelegatingRootProvider
extends AbstractRootProvider {
    _DelegatingRootProvider() {
    }

    @Override
    protected Mono<UriComponents> doGetRoot(ConnectionContext connectionContext) {
        return this.getRootPayloadRootProvider().doGetRoot(connectionContext).onErrorResume(t -> this.getInfoPayloadRootProvider().doGetRoot(connectionContext));
    }

    @Override
    protected Mono<UriComponents> doGetRoot(String key, ConnectionContext connectionContext) {
        return this.getRootPayloadRootProvider().doGetRoot(key, connectionContext).onErrorResume(t -> {
            if ("cloud_controller_v2".equals(key)) {
                return this.getInfoPayloadRootProvider().doGetRoot(connectionContext).map(uri -> UriComponentsBuilder.newInstance().uriComponents(uri).pathSegment(new String[]{"v2"}).build());
            }
            if ("cloud_controller_v3".equals(key)) {
                return this.getInfoPayloadRootProvider().doGetRoot(connectionContext).map(uri -> UriComponentsBuilder.newInstance().uriComponents(uri).pathSegment(new String[]{"v3"}).build());
            }
            if ("logging".equals(key)) {
                return this.getInfoPayloadRootProvider().doGetRoot("doppler_logging_endpoint", connectionContext);
            }
            if ("routing".equals(key)) {
                return this.getInfoPayloadRootProvider().doGetRoot("routing_endpoint", connectionContext);
            }
            if ("uaa".equals(key)) {
                return this.getInfoPayloadRootProvider().doGetRoot("token_endpoint", connectionContext);
            }
            return this.getInfoPayloadRootProvider().doGetRoot(key, connectionContext);
        });
    }

    @Value.Derived
    InfoPayloadRootProvider getInfoPayloadRootProvider() {
        return InfoPayloadRootProvider.builder().apiHost(this.getApiHost()).objectMapper(this.getObjectMapper()).port(this.getPort()).secure(this.getSecure()).build();
    }

    abstract ObjectMapper getObjectMapper();

    @Value.Derived
    RootPayloadRootProvider getRootPayloadRootProvider() {
        return RootPayloadRootProvider.builder().apiHost(this.getApiHost()).objectMapper(this.getObjectMapper()).port(this.getPort()).secure(this.getSecure()).build();
    }
}

