/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.privatedomains;

import org.cloudfoundry.client.v2.privatedomains.CreatePrivateDomainRequest;
import org.cloudfoundry.client.v2.privatedomains.CreatePrivateDomainResponse;
import org.cloudfoundry.client.v2.privatedomains.DeletePrivateDomainRequest;
import org.cloudfoundry.client.v2.privatedomains.DeletePrivateDomainResponse;
import org.cloudfoundry.client.v2.privatedomains.GetPrivateDomainRequest;
import org.cloudfoundry.client.v2.privatedomains.GetPrivateDomainResponse;
import org.cloudfoundry.client.v2.privatedomains.ListPrivateDomainSharedOrganizationsRequest;
import org.cloudfoundry.client.v2.privatedomains.ListPrivateDomainSharedOrganizationsResponse;
import org.cloudfoundry.client.v2.privatedomains.ListPrivateDomainsRequest;
import org.cloudfoundry.client.v2.privatedomains.ListPrivateDomainsResponse;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomains;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorPrivateDomains
extends AbstractClientV2Operations
implements PrivateDomains {
    public ReactorPrivateDomains(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<CreatePrivateDomainResponse> create(CreatePrivateDomainRequest request) {
        return this.post(request, CreatePrivateDomainResponse.class, builder -> builder.pathSegment(new String[]{"private_domains"})).checkpoint();
    }

    public Mono<DeletePrivateDomainResponse> delete(DeletePrivateDomainRequest request) {
        return this.delete(request, DeletePrivateDomainResponse.class, builder -> builder.pathSegment(new String[]{"private_domains", request.getPrivateDomainId()})).checkpoint();
    }

    public Mono<GetPrivateDomainResponse> get(GetPrivateDomainRequest request) {
        return this.get((Object)request, GetPrivateDomainResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"private_domains", request.getPrivateDomainId()})).checkpoint();
    }

    public Mono<ListPrivateDomainsResponse> list(ListPrivateDomainsRequest request) {
        return this.get((Object)request, ListPrivateDomainsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"private_domains"})).checkpoint();
    }

    public Mono<ListPrivateDomainSharedOrganizationsResponse> listSharedOrganizations(ListPrivateDomainSharedOrganizationsRequest request) {
        return this.get((Object)request, ListPrivateDomainSharedOrganizationsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"private_domains", request.getPrivateDomainId(), "shared_organizations"})).checkpoint();
    }
}

