/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.serviceinstances;

import org.cloudfoundry.client.v2.serviceinstances.BindServiceInstanceRouteRequest;
import org.cloudfoundry.client.v2.serviceinstances.BindServiceInstanceRouteResponse;
import org.cloudfoundry.client.v2.serviceinstances.CreateServiceInstanceRequest;
import org.cloudfoundry.client.v2.serviceinstances.CreateServiceInstanceResponse;
import org.cloudfoundry.client.v2.serviceinstances.DeleteServiceInstanceRequest;
import org.cloudfoundry.client.v2.serviceinstances.DeleteServiceInstanceResponse;
import org.cloudfoundry.client.v2.serviceinstances.GetServiceInstancePermissionsRequest;
import org.cloudfoundry.client.v2.serviceinstances.GetServiceInstancePermissionsResponse;
import org.cloudfoundry.client.v2.serviceinstances.GetServiceInstanceRequest;
import org.cloudfoundry.client.v2.serviceinstances.GetServiceInstanceResponse;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceRoutesRequest;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceRoutesResponse;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceServiceBindingsRequest;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceServiceBindingsResponse;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceServiceKeysRequest;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceServiceKeysResponse;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstancesRequest;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstancesResponse;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstances;
import org.cloudfoundry.client.v2.serviceinstances.UnbindServiceInstanceRouteRequest;
import org.cloudfoundry.client.v2.serviceinstances.UpdateServiceInstanceRequest;
import org.cloudfoundry.client.v2.serviceinstances.UpdateServiceInstanceResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorServiceInstances
extends AbstractClientV2Operations
implements ServiceInstances {
    public ReactorServiceInstances(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<BindServiceInstanceRouteResponse> bindRoute(BindServiceInstanceRouteRequest request) {
        return this.put(request, BindServiceInstanceRouteResponse.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "routes", request.getRouteId()})).checkpoint();
    }

    public Mono<CreateServiceInstanceResponse> create(CreateServiceInstanceRequest request) {
        return this.post(request, CreateServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"service_instances"})).checkpoint();
    }

    public Mono<DeleteServiceInstanceResponse> delete(DeleteServiceInstanceRequest request) {
        return this.delete(request, DeleteServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId()})).checkpoint();
    }

    public Mono<GetServiceInstanceResponse> get(GetServiceInstanceRequest request) {
        return this.get((Object)request, GetServiceInstanceResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId()})).checkpoint();
    }

    public Mono<GetServiceInstancePermissionsResponse> getPermissions(GetServiceInstancePermissionsRequest request) {
        return this.get((Object)request, GetServiceInstancePermissionsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "permissions"})).checkpoint();
    }

    public Mono<ListServiceInstancesResponse> list(ListServiceInstancesRequest request) {
        return this.get((Object)request, ListServiceInstancesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances"})).checkpoint();
    }

    public Mono<ListServiceInstanceRoutesResponse> listRoutes(ListServiceInstanceRoutesRequest request) {
        return this.get((Object)request, ListServiceInstanceRoutesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "routes"})).checkpoint();
    }

    public Mono<ListServiceInstanceServiceBindingsResponse> listServiceBindings(ListServiceInstanceServiceBindingsRequest request) {
        return this.get((Object)request, ListServiceInstanceServiceBindingsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "service_bindings"})).checkpoint();
    }

    public Mono<ListServiceInstanceServiceKeysResponse> listServiceKeys(ListServiceInstanceServiceKeysRequest request) {
        return this.get((Object)request, ListServiceInstanceServiceKeysResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "service_keys"})).checkpoint();
    }

    public Mono<Void> unbindRoute(UnbindServiceInstanceRouteRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId(), "routes", request.getRouteId()})).checkpoint();
    }

    public Mono<UpdateServiceInstanceResponse> update(UpdateServiceInstanceRequest request) {
        return this.put(request, UpdateServiceInstanceResponse.class, builder -> builder.pathSegment(new String[]{"service_instances", request.getServiceInstanceId()})).checkpoint();
    }
}

