/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.stream.Collectors;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.util.JsonCodec;
import org.cloudfoundry.reactor.util.NetworkLogging;
import org.cloudfoundry.reactor.util.UserAgent;
import org.immutables.value.Value;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientRequest;

@Value.Immutable
abstract class _RootPayloadRootProvider
extends AbstractRootProvider {
    _RootPayloadRootProvider() {
    }

    @Override
    protected Mono<UriComponents> doGetRoot(ConnectionContext connectionContext) {
        return Mono.just((Object)this.getRoot());
    }

    @Override
    protected Mono<UriComponents> doGetRoot(String key, ConnectionContext connectionContext) {
        return this.getPayload(connectionContext).map(payload -> {
            if (!payload.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Root payload does not contain key '%s'", key));
            }
            return this.normalize(UriComponentsBuilder.fromUriString((String)((String)payload.get(key))));
        });
    }

    abstract ObjectMapper getObjectMapper();

    @Value.Derived
    private Mono<Map<String, String>> getPayload(ConnectionContext connectionContext) {
        return this.getRoot(connectionContext).flatMap(uri -> connectionContext.getHttpClient().get(uri, request -> Mono.just((Object)request).map(UserAgent::addUserAgent).map(JsonCodec::addDecodeHeaders).flatMapMany(HttpClientRequest::send)).doOnSubscribe(NetworkLogging.get(uri)).transform(NetworkLogging.response(uri))).transform(JsonCodec.decode(this.getObjectMapper(), Map.class)).switchIfEmpty(Mono.error((Throwable)new IllegalArgumentException("Root endpoint does not contain a payload"))).map(this::parsePayload).checkpoint();
    }

    private Map<String, String> parsePayload(Map<String, Map<String, Map<String, String>>> payload) {
        return payload.get("links").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((Map)entry.getValue()).get("href")));
    }
}

