/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.packages;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.cloudfoundry.client.v3.packages.CopyPackageRequest;
import org.cloudfoundry.client.v3.packages.CopyPackageResponse;
import org.cloudfoundry.client.v3.packages.CreatePackageRequest;
import org.cloudfoundry.client.v3.packages.CreatePackageResponse;
import org.cloudfoundry.client.v3.packages.DeletePackageRequest;
import org.cloudfoundry.client.v3.packages.DownloadPackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageResponse;
import org.cloudfoundry.client.v3.packages.ListPackageDropletsRequest;
import org.cloudfoundry.client.v3.packages.ListPackageDropletsResponse;
import org.cloudfoundry.client.v3.packages.ListPackagesRequest;
import org.cloudfoundry.client.v3.packages.ListPackagesResponse;
import org.cloudfoundry.client.v3.packages.Packages;
import org.cloudfoundry.client.v3.packages.UploadPackageRequest;
import org.cloudfoundry.client.v3.packages.UploadPackageResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.cloudfoundry.util.FileUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactorPackages
extends AbstractClientV3Operations
implements Packages {
    public ReactorPackages(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<CopyPackageResponse> copy(CopyPackageRequest request) {
        return this.post(request, CopyPackageResponse.class, builder -> builder.pathSegment(new String[]{"packages"})).checkpoint();
    }

    public Mono<CreatePackageResponse> create(CreatePackageRequest request) {
        return this.post(request, CreatePackageResponse.class, builder -> builder.pathSegment(new String[]{"packages"})).checkpoint();
    }

    public Mono<String> delete(DeletePackageRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"packages", request.getPackageId()})).checkpoint();
    }

    public Flux<byte[]> download(DownloadPackageRequest request) {
        return this.get(request, builder -> builder.pathSegment(new String[]{"packages", request.getPackageId(), "download"})).flatMapMany(response -> response.receive().aggregate().asByteArray()).checkpoint();
    }

    public Mono<GetPackageResponse> get(GetPackageRequest request) {
        return this.get(request, GetPackageResponse.class, builder -> builder.pathSegment(new String[]{"packages", request.getPackageId()})).checkpoint();
    }

    public Mono<ListPackagesResponse> list(ListPackagesRequest request) {
        return this.get(request, ListPackagesResponse.class, builder -> builder.pathSegment(new String[]{"packages"})).checkpoint();
    }

    public Mono<ListPackageDropletsResponse> listDroplets(ListPackageDropletsRequest request) {
        return this.get(request, ListPackageDropletsResponse.class, builder -> builder.pathSegment(new String[]{"packages", request.getPackageId(), "droplets"})).checkpoint();
    }

    public Mono<UploadPackageResponse> upload(UploadPackageRequest request) {
        return this.post(request, UploadPackageResponse.class, builder -> builder.pathSegment(new String[]{"packages", request.getPackageId(), "upload"}), outbound -> outbound.flatMap(r -> {
            if (Files.isDirectory(request.getBits(), new LinkOption[0])) {
                return FileUtils.compress((Path)request.getBits()).flatMap(bits -> this.upload((Path)bits, (MultipartHttpClientRequest)r).doOnTerminate(() -> {
                    try {
                        Files.delete(bits);
                    }
                    catch (IOException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }));
            }
            return this.upload(request.getBits(), (MultipartHttpClientRequest)r);
        })).checkpoint();
    }

    private Mono<Void> upload(Path bits, MultipartHttpClientRequest r) {
        return r.addPart(part -> part.setContentDispositionFormData("bits", "application.zip").setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)APPLICATION_ZIP).sendFile(bits)).done();
    }
}

