/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.doppler;

import java.io.IOException;
import java.io.InputStream;
import org.cloudfoundry.doppler.ContainerMetricsRequest;
import org.cloudfoundry.doppler.FirehoseRequest;
import org.cloudfoundry.doppler.RecentLogsRequest;
import org.cloudfoundry.doppler.StreamRequest;
import org.cloudfoundry.dropsonde.events.Envelope;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.doppler.AbstractDopplerOperations;
import org.cloudfoundry.reactor.doppler.MultipartCodec;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ReactorDopplerEndpoints
extends AbstractDopplerOperations {
    ReactorDopplerEndpoints(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    Flux<org.cloudfoundry.doppler.Envelope> containerMetrics(ContainerMetricsRequest request) {
        return this.get(builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "containermetrics"})).flatMapMany(MultipartCodec::decode).map(ReactorDopplerEndpoints::toEnvelope).checkpoint();
    }

    Flux<org.cloudfoundry.doppler.Envelope> firehose(FirehoseRequest request) {
        return this.ws(builder -> builder.pathSegment(new String[]{"firehose", request.getSubscriptionId()})).flatMapMany(response -> response.receiveWebsocket().aggregateFrames().receive().asInputStream()).map(ReactorDopplerEndpoints::toEnvelope).checkpoint();
    }

    Flux<org.cloudfoundry.doppler.Envelope> recentLogs(RecentLogsRequest request) {
        return this.get(builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "recentlogs"})).flatMapMany(MultipartCodec::decode).map(ReactorDopplerEndpoints::toEnvelope).checkpoint();
    }

    Flux<org.cloudfoundry.doppler.Envelope> stream(StreamRequest request) {
        return this.ws(builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "stream"})).flatMapMany(response -> response.receiveWebsocket().aggregateFrames().receive().asInputStream()).map(ReactorDopplerEndpoints::toEnvelope).checkpoint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static org.cloudfoundry.doppler.Envelope toEnvelope(InputStream content) {
        try (InputStream in = content;){
            org.cloudfoundry.doppler.Envelope envelope = org.cloudfoundry.doppler.Envelope.from((Envelope)((Envelope)Envelope.ADAPTER.decode(in)));
            return envelope;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

