/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.doppler;

import org.cloudfoundry.doppler.ContainerMetricsRequest;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.doppler.Envelope;
import org.cloudfoundry.doppler.FirehoseRequest;
import org.cloudfoundry.doppler.RecentLogsRequest;
import org.cloudfoundry.doppler.StreamRequest;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.doppler.ReactorDopplerEndpoints;
import org.immutables.value.Value;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Value.Immutable
abstract class _ReactorDopplerClient
implements DopplerClient {
    _ReactorDopplerClient() {
    }

    public Flux<Envelope> containerMetrics(ContainerMetricsRequest request) {
        return this.getDopplerEndpoints().containerMetrics(request);
    }

    public Flux<Envelope> firehose(FirehoseRequest request) {
        return this.getDopplerEndpoints().firehose(request);
    }

    public Flux<Envelope> recentLogs(RecentLogsRequest request) {
        return this.getDopplerEndpoints().recentLogs(request);
    }

    public Flux<Envelope> stream(StreamRequest request) {
        return this.getDopplerEndpoints().stream(request);
    }

    abstract ConnectionContext getConnectionContext();

    @Value.Derived
    ReactorDopplerEndpoints getDopplerEndpoints() {
        return new ReactorDopplerEndpoints(this.getConnectionContext(), this.getRoot(), this.getTokenProvider());
    }

    @Value.Default
    Mono<String> getRoot() {
        return this.getConnectionContext().getRootProvider().getRoot("logging", this.getConnectionContext());
    }

    abstract TokenProvider getTokenProvider();
}

