/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.tokenprovider;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.tokenprovider.AbstractUaaTokenProvider;
import org.cloudfoundry.reactor.tokenprovider._ClientCredentialsGrantTokenProvider;

public final class ClientCredentialsGrantTokenProvider
extends _ClientCredentialsGrantTokenProvider {
    private final String clientId;
    private final String clientSecret;
    @Nullable
    private final String identityZoneSubdomain;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ClientCredentialsGrantTokenProvider(Builder builder) {
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
        if (builder.clientId != null) {
            this.initShim.clientId(builder.clientId);
        }
        if (builder.clientSecret != null) {
            this.initShim.clientSecret(builder.clientSecret);
        }
        this.clientId = this.initShim.getClientId();
        this.clientSecret = this.initShim.getClientSecret();
        this.initShim = null;
    }

    @Override
    public String getClientId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientId() : this.clientId;
    }

    @Override
    public String getClientSecret() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientSecret() : this.clientSecret;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ClientCredentialsGrantTokenProvider && this.equalTo((ClientCredentialsGrantTokenProvider)another);
    }

    private boolean equalTo(ClientCredentialsGrantTokenProvider another) {
        return this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.clientSecret.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "ClientCredentialsGrantTokenProvider{clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String clientId;
        private String clientSecret;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(AbstractUaaTokenProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ClientCredentialsGrantTokenProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ClientCredentialsGrantTokenProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractUaaTokenProvider) {
                AbstractUaaTokenProvider instance = (AbstractUaaTokenProvider)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                this.clientSecret(instance.getClientSecret());
                this.clientId(instance.getClientId());
            }
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public ClientCredentialsGrantTokenProvider build() {
            return new ClientCredentialsGrantTokenProvider(this);
        }
    }

    private final class InitShim {
        private String clientId;
        private int clientIdBuildStage;
        private String clientSecret;
        private int clientSecretBuildStage;

        private InitShim() {
        }

        String getClientId() {
            if (this.clientIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientIdBuildStage == 0) {
                this.clientIdBuildStage = -1;
                this.clientId = Objects.requireNonNull(ClientCredentialsGrantTokenProvider.super.getClientId(), "clientId");
                this.clientIdBuildStage = 1;
            }
            return this.clientId;
        }

        void clientId(String clientId) {
            this.clientId = clientId;
            this.clientIdBuildStage = 1;
        }

        String getClientSecret() {
            if (this.clientSecretBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientSecretBuildStage == 0) {
                this.clientSecretBuildStage = -1;
                this.clientSecret = Objects.requireNonNull(ClientCredentialsGrantTokenProvider.super.getClientSecret(), "clientSecret");
                this.clientSecretBuildStage = 1;
            }
            return this.clientSecret;
        }

        void clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.clientSecretBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.clientIdBuildStage == -1) {
                attributes.add("clientId");
            }
            if (this.clientSecretBuildStage == -1) {
                attributes.add("clientSecret");
            }
            return "Cannot build ClientCredentialsGrantTokenProvider, attribute initializers form cycle" + attributes;
        }
    }
}

