/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <T extends Annotation> Optional<T> findAnnotation(Method method, Class<T> type) {
        Class<?> clazz = method.getDeclaringClass();
        T annotation = method.getAnnotation(type);
        while (annotation == null && (clazz = clazz.getSuperclass()) != null && Object.class != clazz) {
            try {
                annotation = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes()).getAnnotation(type);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return Optional.ofNullable(annotation);
    }
}

