/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.http.client.HttpClientRequest;

public final class MultipartHttpClientRequest {
    private static final byte[] BOUNDARY_CHARS = new byte[]{45, 95, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static final AsciiString BOUNDARY_PREAMBLE = HttpHeaderValues.MULTIPART_FORM_DATA.concat((CharSequence)"; boundary=");
    private static final AsciiString CRLF = new AsciiString((CharSequence)"\r\n");
    private static final AsciiString DOUBLE_DASH = new AsciiString((CharSequence)"--");
    private static final Random RND = new Random();
    private final ObjectMapper objectMapper;
    private final List<Consumer<PartHttpClientRequest>> partConsumers = new ArrayList<Consumer<PartHttpClientRequest>>();
    private final HttpClientRequest request;

    public MultipartHttpClientRequest(ObjectMapper objectMapper, HttpClientRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    public MultipartHttpClientRequest addPart(Consumer<PartHttpClientRequest> partConsumer) {
        this.partConsumers.add(partConsumer);
        return this;
    }

    public Mono<Void> done() {
        AsciiString boundary = MultipartHttpClientRequest.generateMultipartBoundary();
        AsciiString delimiter = MultipartHttpClientRequest.getDelimiter(boundary);
        AsciiString closeDelimiter = MultipartHttpClientRequest.getCloseDelimiter(boundary);
        List parts = this.partConsumers.stream().map(partConsumer -> {
            PartHttpClientRequest part = new PartHttpClientRequest(this.objectMapper);
            partConsumer.accept(part);
            return part;
        }).collect(Collectors.toList());
        Long contentLength = parts.stream().mapToLong(part -> (long)(delimiter.length() + CRLF.length()) + ((PartHttpClientRequest)part).getLength()).sum() + (long)closeDelimiter.length();
        HttpClientRequest intermediateRequest = this.request.chunkedTransfer(false).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)BOUNDARY_PREAMBLE.concat((CharSequence)boundary)).header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(contentLength));
        for (PartHttpClientRequest part2 : parts) {
            intermediateRequest = intermediateRequest.sendObject((Object)Unpooled.wrappedBuffer((byte[])delimiter.toByteArray()));
            intermediateRequest = intermediateRequest.sendObject((Object)Unpooled.wrappedBuffer((byte[])CRLF.toByteArray()));
            intermediateRequest = intermediateRequest.sendObject((Object)part2.renderedHeaders);
            intermediateRequest = part2.sendPayload((NettyOutbound)intermediateRequest);
        }
        intermediateRequest = intermediateRequest.sendObject((Object)Unpooled.wrappedBuffer((byte[])closeDelimiter.toByteArray()));
        return intermediateRequest.then();
    }

    private static AsciiString generateMultipartBoundary() {
        byte[] boundary = new byte[RND.nextInt(11) + 30];
        for (int i = 0; i < boundary.length; ++i) {
            boundary[i] = BOUNDARY_CHARS[RND.nextInt(BOUNDARY_CHARS.length)];
        }
        return new AsciiString(boundary);
    }

    private static AsciiString getCloseDelimiter(AsciiString boundary) {
        return CRLF.concat((CharSequence)DOUBLE_DASH).concat((CharSequence)boundary).concat((CharSequence)DOUBLE_DASH);
    }

    private static AsciiString getDelimiter(AsciiString boundary) {
        return CRLF.concat((CharSequence)DOUBLE_DASH).concat((CharSequence)boundary);
    }

    public static final class PartHttpClientRequest {
        private static final AsciiString HEADER_DELIMITER = new AsciiString((CharSequence)": ");
        private final HttpHeaders headers = new DefaultHttpHeaders(true);
        private final ObjectMapper objectMapper;
        private Path file;
        private byte[] payload;
        private ByteBuf renderedHeaders;

        private PartHttpClientRequest(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public void send(Object source) {
            try {
                byte[] bytes = this.objectMapper.writeValueAsBytes(source);
                this.headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
                this.renderedHeaders = this.renderHeaders();
                this.payload = bytes;
            }
            catch (JsonProcessingException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public void sendFile(Path file) {
            try {
                this.headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Files.size(file));
                this.renderedHeaders = this.renderHeaders();
                this.file = file;
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public PartHttpClientRequest setContentDispositionFormData(String name) {
            return this.setContentDispositionFormData(name, null);
        }

        public PartHttpClientRequest setContentDispositionFormData(String name, String filename) {
            AsciiString s = new AsciiString((CharSequence)"form-data; name=\"").concat((CharSequence)name).concat((CharSequence)"\"");
            if (filename != null) {
                s = s.concat((CharSequence)"; filename=\"").concat((CharSequence)filename).concat((CharSequence)"\"");
            }
            this.headers.set((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)s);
            return this;
        }

        public PartHttpClientRequest setHeader(CharSequence name, CharSequence value) {
            this.headers.set(name, (Object)value);
            return this;
        }

        private long getLength() {
            return (long)this.renderedHeaders.readableBytes() + this.getPayloadLength();
        }

        private long getPayloadLength() {
            if (this.file != null) {
                try {
                    return Files.size(this.file);
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            if (this.payload != null) {
                return this.payload.length;
            }
            return 0L;
        }

        private ByteBuf renderHeaders() {
            AsciiString s = this.headers.entries().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> new AsciiString((CharSequence)entry.getKey()).concat((CharSequence)HEADER_DELIMITER).concat((CharSequence)entry.getValue()).concat((CharSequence)CRLF)).reduce(AsciiString::concat).orElse(AsciiString.EMPTY_STRING).concat((CharSequence)CRLF);
            return Unpooled.wrappedBuffer((byte[])s.toByteArray());
        }

        private NettyOutbound sendPayload(NettyOutbound request) {
            if (this.file != null) {
                return request.sendFile(this.file);
            }
            if (this.payload != null) {
                return request.sendByteArray((Publisher)Mono.just((Object)this.payload));
            }
            return request;
        }
    }
}

