/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceinstances._UpdateServiceInstanceRequest;
import org.immutables.value.Generated;

@Generated(from="_UpdateServiceInstanceRequest", generator="Immutables")
public final class UpdateServiceInstanceRequest
extends _UpdateServiceInstanceRequest {
    @Nullable
    private final Boolean acceptsIncomplete;
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, Object> parameters;
    private final String serviceInstanceId;
    @Nullable
    private final String servicePlanId;
    @Nullable
    private final List<String> tags;

    private UpdateServiceInstanceRequest(Builder builder) {
        this.acceptsIncomplete = builder.acceptsIncomplete;
        this.name = builder.name;
        this.parameters = builder.parameters == null ? null : UpdateServiceInstanceRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.serviceInstanceId = builder.serviceInstanceId;
        this.servicePlanId = builder.servicePlanId;
        this.tags = builder.tags == null ? null : UpdateServiceInstanceRequest.createUnmodifiableList(true, builder.tags);
    }

    @Override
    @JsonIgnore
    @Nullable
    public Boolean getAcceptsIncomplete() {
        return this.acceptsIncomplete;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="parameters")
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="serviceInstanceId")
    @JsonIgnore
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    @JsonProperty(value="service_plan_guid")
    @Nullable
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    @Override
    @JsonProperty(value="tags")
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateServiceInstanceRequest && this.equalTo((UpdateServiceInstanceRequest)another);
    }

    private boolean equalTo(UpdateServiceInstanceRequest another) {
        return Objects.equals(this.acceptsIncomplete, another.acceptsIncomplete) && Objects.equals(this.name, another.name) && Objects.equals(this.parameters, another.parameters) && this.serviceInstanceId.equals(another.serviceInstanceId) && Objects.equals(this.servicePlanId, another.servicePlanId) && Objects.equals(this.tags, another.tags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.acceptsIncomplete);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.parameters);
        h += (h << 5) + this.serviceInstanceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.servicePlanId);
        h += (h << 5) + Objects.hashCode(this.tags);
        return h;
    }

    public String toString() {
        return "UpdateServiceInstanceRequest{acceptsIncomplete=" + this.acceptsIncomplete + ", name=" + this.name + ", parameters=" + this.parameters + ", serviceInstanceId=" + this.serviceInstanceId + ", servicePlanId=" + this.servicePlanId + ", tags=" + this.tags + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateServiceInstanceRequest fromJson(Json json) {
        Builder builder = UpdateServiceInstanceRequest.builder();
        if (json.acceptsIncomplete != null) {
            builder.acceptsIncomplete(json.acceptsIncomplete);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.parameters != null) {
            builder.putAllParameters(json.parameters);
        }
        if (json.serviceInstanceId != null) {
            builder.serviceInstanceId(json.serviceInstanceId);
        }
        if (json.servicePlanId != null) {
            builder.servicePlanId(json.servicePlanId);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_UpdateServiceInstanceRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SERVICE_INSTANCE_ID = 1L;
        private long initBits = 1L;
        private Boolean acceptsIncomplete;
        private String name;
        private Map<String, Object> parameters = null;
        private String serviceInstanceId;
        private String servicePlanId;
        private List<String> tags = null;

        private Builder() {
        }

        public final Builder from(UpdateServiceInstanceRequest instance) {
            return this.from((_UpdateServiceInstanceRequest)instance);
        }

        final Builder from(_UpdateServiceInstanceRequest instance) {
            List<String> tagsValue;
            Map<String, Object> parametersValue;
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            Boolean acceptsIncompleteValue = instance.getAcceptsIncomplete();
            if (acceptsIncompleteValue != null) {
                this.acceptsIncomplete(acceptsIncompleteValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((parametersValue = instance.getParameters()) != null) {
                this.putAllParameters(parametersValue);
            }
            this.serviceInstanceId(instance.getServiceInstanceId());
            String servicePlanIdValue = instance.getServicePlanId();
            if (servicePlanIdValue != null) {
                this.servicePlanId(servicePlanIdValue);
            }
            if ((tagsValue = instance.getTags()) != null) {
                this.addAllTags(tagsValue);
            }
            return this;
        }

        public final Builder acceptsIncomplete(@Nullable Boolean acceptsIncomplete) {
            this.acceptsIncomplete = acceptsIncomplete;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(key, value);
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(k, v);
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(entries);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> entries) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.parameters.put(k, v);
            }
            return this;
        }

        public final Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder servicePlanId(@Nullable String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tags(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public UpdateServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceInstanceId");
            }
            return "Cannot build UpdateServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UpdateServiceInstanceRequest", generator="Immutables")
    static final class Json
    extends _UpdateServiceInstanceRequest {
        Boolean acceptsIncomplete;
        String name;
        Map<String, Object> parameters = null;
        String serviceInstanceId;
        String servicePlanId;
        List<String> tags = null;

        Json() {
        }

        @JsonIgnore
        public void setAcceptsIncomplete(@Nullable Boolean acceptsIncomplete) {
            this.acceptsIncomplete = acceptsIncomplete;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="parameters")
        public void setParameters(@Nullable Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        @JsonProperty(value="serviceInstanceId")
        @JsonIgnore
        public void setServiceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        @JsonProperty(value="service_plan_guid")
        public void setServicePlanId(@Nullable String servicePlanId) {
            this.servicePlanId = servicePlanId;
        }

        @JsonProperty(value="tags")
        public void setTags(@Nullable List<String> tags) {
            this.tags = tags;
        }

        @Override
        public Boolean getAcceptsIncomplete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServicePlanId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }
    }
}

