/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.spaces._ListSpaceServicesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListSpaceServicesRequest", generator="Immutables")
public final class ListSpaceServicesRequest
extends _ListSpaceServicesRequest {
    @Nullable
    private final List<String> actives;
    @Nullable
    private final List<String> labels;
    @Nullable
    private final List<String> providers;
    @Nullable
    private final List<String> serviceBrokerIds;
    private final String spaceId;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListSpaceServicesRequest(Builder builder) {
        this.actives = builder.actives == null ? null : ListSpaceServicesRequest.createUnmodifiableList(true, builder.actives);
        this.labels = builder.labels == null ? null : ListSpaceServicesRequest.createUnmodifiableList(true, builder.labels);
        this.providers = builder.providers == null ? null : ListSpaceServicesRequest.createUnmodifiableList(true, builder.providers);
        this.serviceBrokerIds = builder.serviceBrokerIds == null ? null : ListSpaceServicesRequest.createUnmodifiableList(true, builder.serviceBrokerIds);
        this.spaceId = builder.spaceId;
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getActives() {
        return this.actives;
    }

    @Override
    @Nullable
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    @Nullable
    public List<String> getProviders() {
        return this.providers;
    }

    @Override
    @Nullable
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListSpaceServicesRequest && this.equalTo((ListSpaceServicesRequest)another);
    }

    private boolean equalTo(ListSpaceServicesRequest another) {
        return Objects.equals(this.actives, another.actives) && Objects.equals(this.labels, another.labels) && Objects.equals(this.providers, another.providers) && Objects.equals(this.serviceBrokerIds, another.serviceBrokerIds) && this.spaceId.equals(another.spaceId) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.actives);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.providers);
        h += (h << 5) + Objects.hashCode(this.serviceBrokerIds);
        h += (h << 5) + this.spaceId.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListSpaceServicesRequest{actives=" + this.actives + ", labels=" + this.labels + ", providers=" + this.providers + ", serviceBrokerIds=" + this.serviceBrokerIds + ", spaceId=" + this.spaceId + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListSpaceServicesRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SPACE_ID = 1L;
        private long initBits = 1L;
        private List<String> actives = null;
        private List<String> labels = null;
        private List<String> providers = null;
        private List<String> serviceBrokerIds = null;
        private String spaceId;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(ListSpaceServicesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListSpaceServicesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListSpaceServicesRequest) {
                List<String> labelsValue;
                List<String> providersValue;
                List<String> activesValue;
                instance = (_ListSpaceServicesRequest)object;
                this.spaceId(((_ListSpaceServicesRequest)instance).getSpaceId());
                List<String> serviceBrokerIdsValue = ((_ListSpaceServicesRequest)instance).getServiceBrokerIds();
                if (serviceBrokerIdsValue != null) {
                    this.addAllServiceBrokerIds(serviceBrokerIdsValue);
                }
                if ((activesValue = ((_ListSpaceServicesRequest)instance).getActives()) != null) {
                    this.addAllActives(activesValue);
                }
                if ((providersValue = ((_ListSpaceServicesRequest)instance).getProviders()) != null) {
                    this.addAllProviders(providersValue);
                }
                if ((labelsValue = ((_ListSpaceServicesRequest)instance).getLabels()) != null) {
                    this.addAllLabels(labelsValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder active(String element) {
            if (this.actives == null) {
                this.actives = new ArrayList<String>();
            }
            this.actives.add(Objects.requireNonNull(element, "actives element"));
            return this;
        }

        public final Builder actives(String ... elements) {
            if (this.actives == null) {
                this.actives = new ArrayList<String>();
            }
            for (String element : elements) {
                this.actives.add(Objects.requireNonNull(element, "actives element"));
            }
            return this;
        }

        public final Builder actives(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.actives = null;
                return this;
            }
            this.actives = new ArrayList<String>();
            return this.addAllActives(elements);
        }

        public final Builder addAllActives(Iterable<String> elements) {
            Objects.requireNonNull(elements, "actives element");
            if (this.actives == null) {
                this.actives = new ArrayList<String>();
            }
            for (String element : elements) {
                this.actives.add(Objects.requireNonNull(element, "actives element"));
            }
            return this;
        }

        public final Builder label(String element) {
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(Objects.requireNonNull(element, "labels element"));
            return this;
        }

        public final Builder labels(String ... elements) {
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.labels.add(Objects.requireNonNull(element, "labels element"));
            }
            return this;
        }

        public final Builder labels(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.labels = null;
                return this;
            }
            this.labels = new ArrayList<String>();
            return this.addAllLabels(elements);
        }

        public final Builder addAllLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "labels element");
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.labels.add(Objects.requireNonNull(element, "labels element"));
            }
            return this;
        }

        public final Builder provider(String element) {
            if (this.providers == null) {
                this.providers = new ArrayList<String>();
            }
            this.providers.add(Objects.requireNonNull(element, "providers element"));
            return this;
        }

        public final Builder providers(String ... elements) {
            if (this.providers == null) {
                this.providers = new ArrayList<String>();
            }
            for (String element : elements) {
                this.providers.add(Objects.requireNonNull(element, "providers element"));
            }
            return this;
        }

        public final Builder providers(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.providers = null;
                return this;
            }
            this.providers = new ArrayList<String>();
            return this.addAllProviders(elements);
        }

        public final Builder addAllProviders(Iterable<String> elements) {
            Objects.requireNonNull(elements, "providers element");
            if (this.providers == null) {
                this.providers = new ArrayList<String>();
            }
            for (String element : elements) {
                this.providers.add(Objects.requireNonNull(element, "providers element"));
            }
            return this;
        }

        public final Builder serviceBrokerId(String element) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList<String>();
            }
            this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
            return this;
        }

        public final Builder serviceBrokerIds(String ... elements) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
            }
            return this;
        }

        public final Builder serviceBrokerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceBrokerIds = null;
                return this;
            }
            this.serviceBrokerIds = new ArrayList<String>();
            return this.addAllServiceBrokerIds(elements);
        }

        public final Builder addAllServiceBrokerIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceBrokerIds element");
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
            }
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceServicesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListSpaceServicesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spaceId");
            }
            return "Cannot build ListSpaceServicesRequest, some of required attributes are not set " + attributes;
        }
    }
}

