/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.builds;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.builds.Build;
import org.cloudfoundry.client.v3.builds.BuildState;
import org.cloudfoundry.client.v3.builds.CreatedBy;
import org.cloudfoundry.client.v3.builds.Droplet;
import org.cloudfoundry.client.v3.builds._CreateBuildResponse;
import org.immutables.value.Generated;

@Generated(from="_CreateBuildResponse", generator="Immutables")
public final class CreateBuildResponse
extends _CreateBuildResponse {
    private final CreatedBy createdBy;
    @Nullable
    private final Droplet droplet;
    @Nullable
    private final String error;
    private final Relationship inputPackage;
    private final Lifecycle lifecycle;
    private final BuildState state;
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;

    private CreateBuildResponse(Builder builder) {
        this.createdBy = builder.createdBy;
        this.droplet = builder.droplet;
        this.error = builder.error;
        this.inputPackage = builder.inputPackage;
        this.lifecycle = builder.lifecycle;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = CreateBuildResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
    }

    @Override
    @JsonProperty(value="created_by")
    public CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    @Override
    @JsonProperty(value="droplet")
    @Nullable
    public Droplet getDroplet() {
        return this.droplet;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="package")
    public Relationship getInputPackage() {
        return this.inputPackage;
    }

    @Override
    @JsonProperty(value="lifecycle")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @JsonProperty(value="state")
    public BuildState getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateBuildResponse && this.equalTo((CreateBuildResponse)another);
    }

    private boolean equalTo(CreateBuildResponse another) {
        return this.createdBy.equals(another.createdBy) && Objects.equals(this.droplet, another.droplet) && Objects.equals(this.error, another.error) && this.inputPackage.equals(another.inputPackage) && this.lifecycle.equals(another.lifecycle) && this.state.equals((Object)another.state) && this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdBy.hashCode();
        h += (h << 5) + Objects.hashCode(this.droplet);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.inputPackage.hashCode();
        h += (h << 5) + this.lifecycle.hashCode();
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        return h;
    }

    public String toString() {
        return "CreateBuildResponse{createdBy=" + this.createdBy + ", droplet=" + this.droplet + ", error=" + this.error + ", inputPackage=" + this.inputPackage + ", lifecycle=" + this.lifecycle + ", state=" + (Object)((Object)this.state) + ", createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateBuildResponse fromJson(Json json) {
        Builder builder = CreateBuildResponse.builder();
        if (json.createdBy != null) {
            builder.createdBy(json.createdBy);
        }
        if (json.droplet != null) {
            builder.droplet(json.droplet);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.inputPackage != null) {
            builder.inputPackage(json.inputPackage);
        }
        if (json.lifecycle != null) {
            builder.lifecycle(json.lifecycle);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_CreateBuildResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_BY = 1L;
        private static final long INIT_BIT_INPUT_PACKAGE = 2L;
        private static final long INIT_BIT_LIFECYCLE = 4L;
        private static final long INIT_BIT_STATE = 8L;
        private static final long INIT_BIT_CREATED_AT = 16L;
        private static final long INIT_BIT_ID = 32L;
        private long initBits = 63L;
        private CreatedBy createdBy;
        private Droplet droplet;
        private String error;
        private Relationship inputPackage;
        private Lifecycle lifecycle;
        private BuildState state;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;

        private Builder() {
        }

        public final Builder from(Build instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CreateBuildResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_CreateBuildResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof Build) {
                String errorValue;
                instance = (Build)object;
                this.lifecycle(((Build)instance).getLifecycle());
                this.inputPackage(((Build)instance).getInputPackage());
                this.state(((Build)instance).getState());
                Droplet dropletValue = ((Build)instance).getDroplet();
                if (dropletValue != null) {
                    this.droplet(dropletValue);
                }
                if ((errorValue = ((Build)instance).getError()) != null) {
                    this.error(errorValue);
                }
                this.createdBy(((Build)instance).getCreatedBy());
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_by")
        public final Builder createdBy(CreatedBy createdBy) {
            this.createdBy = Objects.requireNonNull(createdBy, "createdBy");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="droplet")
        public final Builder droplet(@Nullable Droplet droplet) {
            this.droplet = droplet;
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="package")
        public final Builder inputPackage(Relationship inputPackage) {
            this.inputPackage = Objects.requireNonNull(inputPackage, "inputPackage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="lifecycle")
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(BuildState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public CreateBuildResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateBuildResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdBy");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("inputPackage");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lifecycle");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build CreateBuildResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateBuildResponse", generator="Immutables")
    static final class Json
    extends _CreateBuildResponse {
        CreatedBy createdBy;
        Droplet droplet;
        String error;
        Relationship inputPackage;
        Lifecycle lifecycle;
        BuildState state;
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;

        Json() {
        }

        @JsonProperty(value="created_by")
        public void setCreatedBy(CreatedBy createdBy) {
            this.createdBy = createdBy;
        }

        @JsonProperty(value="droplet")
        public void setDroplet(@Nullable Droplet droplet) {
            this.droplet = droplet;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="package")
        public void setInputPackage(Relationship inputPackage) {
            this.inputPackage = inputPackage;
        }

        @JsonProperty(value="lifecycle")
        public void setLifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        @JsonProperty(value="state")
        public void setState(BuildState state) {
            this.state = state;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public CreatedBy getCreatedBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Droplet getDroplet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Relationship getInputPackage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Lifecycle getLifecycle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BuildState getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

