/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum DeploymentState {
    DEPLOYING("DEPLOYING"),
    DEPLOYED("DEPLOYED"),
    CANCELING("CANCELING"),
    CANCELED("CANCELED");

    private final String value;

    private DeploymentState(String value) {
        this.value = value;
    }

    @JsonCreator
    public static DeploymentState from(String s) {
        switch (s.toLowerCase()) {
            case "deploying": {
                return DEPLOYING;
            }
            case "deployed": {
                return DEPLOYED;
            }
            case "canceling": {
                return CANCELING;
            }
            case "canceled": {
                return CANCELED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown deployment state: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

