/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes.PortMapping;
import org.cloudfoundry.client.v3.processes.ProcessState;
import org.cloudfoundry.client.v3.processes.ProcessStatistics;
import org.cloudfoundry.client.v3.processes.ProcessUsage;
import org.cloudfoundry.client.v3.processes._ProcessStatisticsResource;
import org.immutables.value.Generated;

@Generated(from="_ProcessStatisticsResource", generator="Immutables")
public final class ProcessStatisticsResource
extends _ProcessStatisticsResource {
    @Nullable
    private final String details;
    private final Integer diskQuota;
    private final Integer fileDescriptorQuota;
    private final String host;
    private final Integer index;
    private final List<PortMapping> instancePorts;
    @Nullable
    private final String isolationSegment;
    private final Integer memoryQuota;
    @Nullable
    private final ProcessState state;
    private final String type;
    private final Integer uptime;
    private final ProcessUsage usage;

    private ProcessStatisticsResource(Builder builder) {
        this.details = builder.details;
        this.diskQuota = builder.diskQuota;
        this.fileDescriptorQuota = builder.fileDescriptorQuota;
        this.host = builder.host;
        this.index = builder.index;
        this.instancePorts = ProcessStatisticsResource.createUnmodifiableList(true, builder.instancePorts);
        this.isolationSegment = builder.isolationSegment;
        this.memoryQuota = builder.memoryQuota;
        this.state = builder.state;
        this.type = builder.type;
        this.uptime = builder.uptime;
        this.usage = builder.usage;
    }

    @Override
    @JsonProperty(value="details")
    @Nullable
    public String getDetails() {
        return this.details;
    }

    @Override
    @JsonProperty(value="disk_quota")
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    @JsonProperty(value="fds_quota")
    public Integer getFileDescriptorQuota() {
        return this.fileDescriptorQuota;
    }

    @Override
    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty(value="index")
    public Integer getIndex() {
        return this.index;
    }

    @Override
    @JsonProperty(value="instance_ports")
    public List<PortMapping> getInstancePorts() {
        return this.instancePorts;
    }

    @Override
    @JsonProperty(value="isolation_segment")
    @Nullable
    public String getIsolationSegment() {
        return this.isolationSegment;
    }

    @Override
    @JsonProperty(value="mem_quota")
    public Integer getMemoryQuota() {
        return this.memoryQuota;
    }

    @Override
    @JsonProperty(value="state")
    @Nullable
    public ProcessState getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="uptime")
    public Integer getUptime() {
        return this.uptime;
    }

    @Override
    @JsonProperty(value="usage")
    public ProcessUsage getUsage() {
        return this.usage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ProcessStatisticsResource && this.equalTo((ProcessStatisticsResource)another);
    }

    private boolean equalTo(ProcessStatisticsResource another) {
        return Objects.equals(this.details, another.details) && this.diskQuota.equals(another.diskQuota) && this.fileDescriptorQuota.equals(another.fileDescriptorQuota) && this.host.equals(another.host) && this.index.equals(another.index) && this.instancePorts.equals(another.instancePorts) && Objects.equals(this.isolationSegment, another.isolationSegment) && this.memoryQuota.equals(another.memoryQuota) && Objects.equals((Object)this.state, (Object)another.state) && this.type.equals(another.type) && this.uptime.equals(another.uptime) && this.usage.equals(another.usage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.details);
        h += (h << 5) + this.diskQuota.hashCode();
        h += (h << 5) + this.fileDescriptorQuota.hashCode();
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.index.hashCode();
        h += (h << 5) + this.instancePorts.hashCode();
        h += (h << 5) + Objects.hashCode(this.isolationSegment);
        h += (h << 5) + this.memoryQuota.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.state);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.uptime.hashCode();
        h += (h << 5) + this.usage.hashCode();
        return h;
    }

    public String toString() {
        return "ProcessStatisticsResource{details=" + this.details + ", diskQuota=" + this.diskQuota + ", fileDescriptorQuota=" + this.fileDescriptorQuota + ", host=" + this.host + ", index=" + this.index + ", instancePorts=" + this.instancePorts + ", isolationSegment=" + this.isolationSegment + ", memoryQuota=" + this.memoryQuota + ", state=" + (Object)((Object)this.state) + ", type=" + this.type + ", uptime=" + this.uptime + ", usage=" + this.usage + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ProcessStatisticsResource fromJson(Json json) {
        Builder builder = ProcessStatisticsResource.builder();
        if (json.details != null) {
            builder.details(json.details);
        }
        if (json.diskQuota != null) {
            builder.diskQuota(json.diskQuota);
        }
        if (json.fileDescriptorQuota != null) {
            builder.fileDescriptorQuota(json.fileDescriptorQuota);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        if (json.instancePorts != null) {
            builder.addAllInstancePorts(json.instancePorts);
        }
        if (json.isolationSegment != null) {
            builder.isolationSegment(json.isolationSegment);
        }
        if (json.memoryQuota != null) {
            builder.memoryQuota(json.memoryQuota);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.uptime != null) {
            builder.uptime(json.uptime);
        }
        if (json.usage != null) {
            builder.usage(json.usage);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ProcessStatisticsResource", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DISK_QUOTA = 1L;
        private static final long INIT_BIT_FILE_DESCRIPTOR_QUOTA = 2L;
        private static final long INIT_BIT_HOST = 4L;
        private static final long INIT_BIT_INDEX = 8L;
        private static final long INIT_BIT_MEMORY_QUOTA = 16L;
        private static final long INIT_BIT_TYPE = 32L;
        private static final long INIT_BIT_UPTIME = 64L;
        private static final long INIT_BIT_USAGE = 128L;
        private long initBits = 255L;
        private String details;
        private Integer diskQuota;
        private Integer fileDescriptorQuota;
        private String host;
        private Integer index;
        private List<PortMapping> instancePorts = new ArrayList<PortMapping>();
        private String isolationSegment;
        private Integer memoryQuota;
        private ProcessState state;
        private String type;
        private Integer uptime;
        private ProcessUsage usage;

        private Builder() {
        }

        public final Builder from(ProcessStatistics instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessStatisticsResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ProcessStatisticsResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof ProcessStatistics) {
                ProcessStatistics instance = (ProcessStatistics)object;
                this.fileDescriptorQuota(instance.getFileDescriptorQuota());
                String isolationSegmentValue = instance.getIsolationSegment();
                if (isolationSegmentValue != null) {
                    this.isolationSegment(isolationSegmentValue);
                }
                this.usage(instance.getUsage());
                this.host(instance.getHost());
                this.index(instance.getIndex());
                String detailsValue = instance.getDetails();
                if (detailsValue != null) {
                    this.details(detailsValue);
                }
                this.memoryQuota(instance.getMemoryQuota());
                ProcessState stateValue = instance.getState();
                if (stateValue != null) {
                    this.state(stateValue);
                }
                this.type(instance.getType());
                this.diskQuota(instance.getDiskQuota());
                this.addAllInstancePorts(instance.getInstancePorts());
                this.uptime(instance.getUptime());
            }
        }

        @JsonProperty(value="details")
        public final Builder details(@Nullable String details) {
            this.details = details;
            return this;
        }

        @JsonProperty(value="disk_quota")
        public final Builder diskQuota(Integer diskQuota) {
            this.diskQuota = Objects.requireNonNull(diskQuota, "diskQuota");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="fds_quota")
        public final Builder fileDescriptorQuota(Integer fileDescriptorQuota) {
            this.fileDescriptorQuota = Objects.requireNonNull(fileDescriptorQuota, "fileDescriptorQuota");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="host")
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="index")
        public final Builder index(Integer index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder instancePort(PortMapping element) {
            this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
            return this;
        }

        public final Builder instancePorts(PortMapping ... elements) {
            for (PortMapping element : elements) {
                this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
            }
            return this;
        }

        @JsonProperty(value="instance_ports")
        public final Builder instancePorts(Iterable<? extends PortMapping> elements) {
            this.instancePorts.clear();
            return this.addAllInstancePorts(elements);
        }

        public final Builder addAllInstancePorts(Iterable<? extends PortMapping> elements) {
            for (PortMapping portMapping : elements) {
                this.instancePorts.add(Objects.requireNonNull(portMapping, "instancePorts element"));
            }
            return this;
        }

        @JsonProperty(value="isolation_segment")
        public final Builder isolationSegment(@Nullable String isolationSegment) {
            this.isolationSegment = isolationSegment;
            return this;
        }

        @JsonProperty(value="mem_quota")
        public final Builder memoryQuota(Integer memoryQuota) {
            this.memoryQuota = Objects.requireNonNull(memoryQuota, "memoryQuota");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(@Nullable ProcessState state) {
            this.state = state;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="uptime")
        public final Builder uptime(Integer uptime) {
            this.uptime = Objects.requireNonNull(uptime, "uptime");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="usage")
        public final Builder usage(ProcessUsage usage) {
            this.usage = Objects.requireNonNull(usage, "usage");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ProcessStatisticsResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ProcessStatisticsResource(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("diskQuota");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fileDescriptorQuota");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("memoryQuota");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("uptime");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("usage");
            }
            return "Cannot build ProcessStatisticsResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ProcessStatisticsResource", generator="Immutables")
    static final class Json
    extends _ProcessStatisticsResource {
        String details;
        Integer diskQuota;
        Integer fileDescriptorQuota;
        String host;
        Integer index;
        List<PortMapping> instancePorts = Collections.emptyList();
        String isolationSegment;
        Integer memoryQuota;
        ProcessState state;
        String type;
        Integer uptime;
        ProcessUsage usage;

        Json() {
        }

        @JsonProperty(value="details")
        public void setDetails(@Nullable String details) {
            this.details = details;
        }

        @JsonProperty(value="disk_quota")
        public void setDiskQuota(Integer diskQuota) {
            this.diskQuota = diskQuota;
        }

        @JsonProperty(value="fds_quota")
        public void setFileDescriptorQuota(Integer fileDescriptorQuota) {
            this.fileDescriptorQuota = fileDescriptorQuota;
        }

        @JsonProperty(value="host")
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="index")
        public void setIndex(Integer index) {
            this.index = index;
        }

        @JsonProperty(value="instance_ports")
        public void setInstancePorts(List<PortMapping> instancePorts) {
            this.instancePorts = instancePorts;
        }

        @JsonProperty(value="isolation_segment")
        public void setIsolationSegment(@Nullable String isolationSegment) {
            this.isolationSegment = isolationSegment;
        }

        @JsonProperty(value="mem_quota")
        public void setMemoryQuota(Integer memoryQuota) {
            this.memoryQuota = memoryQuota;
        }

        @JsonProperty(value="state")
        public void setState(@Nullable ProcessState state) {
            this.state = state;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="uptime")
        public void setUptime(Integer uptime) {
            this.uptime = uptime;
        }

        @JsonProperty(value="usage")
        public void setUsage(ProcessUsage usage) {
            this.usage = usage;
        }

        @Override
        public String getDetails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getDiskQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getFileDescriptorQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PortMapping> getInstancePorts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIsolationSegment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemoryQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessState getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getUptime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessUsage getUsage() {
            throw new UnsupportedOperationException();
        }
    }
}

