/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TaskState {
    CANCELING("CANCELING"),
    FAILED("FAILED"),
    PENDING("PENDING"),
    RUNNING("RUNNING"),
    SUCCEEDED("SUCCEEDED");

    private final String value;

    private TaskState(String value) {
        this.value = value;
    }

    @JsonCreator
    public static TaskState from(String s) {
        switch (s.toLowerCase()) {
            case "canceling": {
                return CANCELING;
            }
            case "failed": {
                return FAILED;
            }
            case "pending": {
                return PENDING;
            }
            case "running": {
                return RUNNING;
            }
            case "succeeded": {
                return SUCCEEDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown task state: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

