/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.authorizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.cloudfoundry.uaa.authorizations._GetOpenIdProviderConfigurationResponse;
import org.immutables.value.Generated;

@Generated(from="_GetOpenIdProviderConfigurationResponse", generator="Immutables")
public final class GetOpenIdProviderConfigurationResponse
extends _GetOpenIdProviderConfigurationResponse {
    private final String authorizationEndpoint;
    private final Boolean claimsParameterSupported;
    private final String issuer;
    private final String javaWebKeySetEndpoint;
    private final String serviceDocumentation;
    private final List<String> supportedClaimTypes;
    private final List<String> supportedClaims;
    private final List<String> supportedIdTokenEncryptionAlgorithms;
    private final List<String> supportedIdTokenSigningAlgorithms;
    private final List<String> supportedResponseTypes;
    private final List<String> supportedScopes;
    private final List<String> supportedSubjectTypes;
    private final List<String> supportedTokenEndpointAuthorizationMethods;
    private final List<String> supportedTokenEndpointAuthorizationSigningAlgorithms;
    private final List<Locale> supportedUiLocales;
    private final String tokenEndpoint;
    private final String userInfoEndpoint;

    private GetOpenIdProviderConfigurationResponse(Builder builder) {
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.claimsParameterSupported = builder.claimsParameterSupported;
        this.issuer = builder.issuer;
        this.javaWebKeySetEndpoint = builder.javaWebKeySetEndpoint;
        this.serviceDocumentation = builder.serviceDocumentation;
        this.supportedClaimTypes = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedClaimTypes);
        this.supportedClaims = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedClaims);
        this.supportedIdTokenEncryptionAlgorithms = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedIdTokenEncryptionAlgorithms);
        this.supportedIdTokenSigningAlgorithms = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedIdTokenSigningAlgorithms);
        this.supportedResponseTypes = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedResponseTypes);
        this.supportedScopes = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedScopes);
        this.supportedSubjectTypes = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedSubjectTypes);
        this.supportedTokenEndpointAuthorizationMethods = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedTokenEndpointAuthorizationMethods);
        this.supportedTokenEndpointAuthorizationSigningAlgorithms = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedTokenEndpointAuthorizationSigningAlgorithms);
        this.supportedUiLocales = GetOpenIdProviderConfigurationResponse.createUnmodifiableList(true, builder.supportedUiLocales);
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
    }

    @Override
    @JsonProperty(value="authorization_endpoint")
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    @Override
    @JsonProperty(value="claims_parameter_supported")
    public Boolean getClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    @Override
    @JsonProperty(value="issuer")
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    @JsonProperty(value="jwks_uri")
    public String getJavaWebKeySetEndpoint() {
        return this.javaWebKeySetEndpoint;
    }

    @Override
    @JsonProperty(value="service_documentation")
    public String getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    @Override
    @JsonProperty(value="claim_types_supported")
    public List<String> getSupportedClaimTypes() {
        return this.supportedClaimTypes;
    }

    @Override
    @JsonProperty(value="claims_supported")
    public List<String> getSupportedClaims() {
        return this.supportedClaims;
    }

    @Override
    @JsonProperty(value="id_token_encryption_alg_values_supported")
    public List<String> getSupportedIdTokenEncryptionAlgorithms() {
        return this.supportedIdTokenEncryptionAlgorithms;
    }

    @Override
    @JsonProperty(value="id_token_signing_alg_values_supported")
    public List<String> getSupportedIdTokenSigningAlgorithms() {
        return this.supportedIdTokenSigningAlgorithms;
    }

    @Override
    @JsonProperty(value="response_types_supported")
    public List<String> getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    @Override
    @JsonProperty(value="scopes_supported")
    public List<String> getSupportedScopes() {
        return this.supportedScopes;
    }

    @Override
    @JsonProperty(value="subject_types_supported")
    public List<String> getSupportedSubjectTypes() {
        return this.supportedSubjectTypes;
    }

    @Override
    @JsonProperty(value="token_endpoint_auth_methods_supported")
    public List<String> getSupportedTokenEndpointAuthorizationMethods() {
        return this.supportedTokenEndpointAuthorizationMethods;
    }

    @Override
    @JsonProperty(value="token_endpoint_auth_signing_alg_values_supported")
    public List<String> getSupportedTokenEndpointAuthorizationSigningAlgorithms() {
        return this.supportedTokenEndpointAuthorizationSigningAlgorithms;
    }

    @Override
    @JsonProperty(value="ui_locales_supported")
    public List<Locale> getSupportedUiLocales() {
        return this.supportedUiLocales;
    }

    @Override
    @JsonProperty(value="token_endpoint")
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Override
    @JsonProperty(value="userinfo_endpoint")
    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetOpenIdProviderConfigurationResponse && this.equalTo((GetOpenIdProviderConfigurationResponse)another);
    }

    private boolean equalTo(GetOpenIdProviderConfigurationResponse another) {
        return this.authorizationEndpoint.equals(another.authorizationEndpoint) && this.claimsParameterSupported.equals(another.claimsParameterSupported) && this.issuer.equals(another.issuer) && this.javaWebKeySetEndpoint.equals(another.javaWebKeySetEndpoint) && this.serviceDocumentation.equals(another.serviceDocumentation) && this.supportedClaimTypes.equals(another.supportedClaimTypes) && this.supportedClaims.equals(another.supportedClaims) && this.supportedIdTokenEncryptionAlgorithms.equals(another.supportedIdTokenEncryptionAlgorithms) && this.supportedIdTokenSigningAlgorithms.equals(another.supportedIdTokenSigningAlgorithms) && this.supportedResponseTypes.equals(another.supportedResponseTypes) && this.supportedScopes.equals(another.supportedScopes) && this.supportedSubjectTypes.equals(another.supportedSubjectTypes) && this.supportedTokenEndpointAuthorizationMethods.equals(another.supportedTokenEndpointAuthorizationMethods) && this.supportedTokenEndpointAuthorizationSigningAlgorithms.equals(another.supportedTokenEndpointAuthorizationSigningAlgorithms) && this.supportedUiLocales.equals(another.supportedUiLocales) && this.tokenEndpoint.equals(another.tokenEndpoint) && this.userInfoEndpoint.equals(another.userInfoEndpoint);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.authorizationEndpoint.hashCode();
        h += (h << 5) + this.claimsParameterSupported.hashCode();
        h += (h << 5) + this.issuer.hashCode();
        h += (h << 5) + this.javaWebKeySetEndpoint.hashCode();
        h += (h << 5) + this.serviceDocumentation.hashCode();
        h += (h << 5) + this.supportedClaimTypes.hashCode();
        h += (h << 5) + this.supportedClaims.hashCode();
        h += (h << 5) + this.supportedIdTokenEncryptionAlgorithms.hashCode();
        h += (h << 5) + this.supportedIdTokenSigningAlgorithms.hashCode();
        h += (h << 5) + this.supportedResponseTypes.hashCode();
        h += (h << 5) + this.supportedScopes.hashCode();
        h += (h << 5) + this.supportedSubjectTypes.hashCode();
        h += (h << 5) + this.supportedTokenEndpointAuthorizationMethods.hashCode();
        h += (h << 5) + this.supportedTokenEndpointAuthorizationSigningAlgorithms.hashCode();
        h += (h << 5) + this.supportedUiLocales.hashCode();
        h += (h << 5) + this.tokenEndpoint.hashCode();
        h += (h << 5) + this.userInfoEndpoint.hashCode();
        return h;
    }

    public String toString() {
        return "GetOpenIdProviderConfigurationResponse{authorizationEndpoint=" + this.authorizationEndpoint + ", claimsParameterSupported=" + this.claimsParameterSupported + ", issuer=" + this.issuer + ", javaWebKeySetEndpoint=" + this.javaWebKeySetEndpoint + ", serviceDocumentation=" + this.serviceDocumentation + ", supportedClaimTypes=" + this.supportedClaimTypes + ", supportedClaims=" + this.supportedClaims + ", supportedIdTokenEncryptionAlgorithms=" + this.supportedIdTokenEncryptionAlgorithms + ", supportedIdTokenSigningAlgorithms=" + this.supportedIdTokenSigningAlgorithms + ", supportedResponseTypes=" + this.supportedResponseTypes + ", supportedScopes=" + this.supportedScopes + ", supportedSubjectTypes=" + this.supportedSubjectTypes + ", supportedTokenEndpointAuthorizationMethods=" + this.supportedTokenEndpointAuthorizationMethods + ", supportedTokenEndpointAuthorizationSigningAlgorithms=" + this.supportedTokenEndpointAuthorizationSigningAlgorithms + ", supportedUiLocales=" + this.supportedUiLocales + ", tokenEndpoint=" + this.tokenEndpoint + ", userInfoEndpoint=" + this.userInfoEndpoint + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetOpenIdProviderConfigurationResponse fromJson(Json json) {
        Builder builder = GetOpenIdProviderConfigurationResponse.builder();
        if (json.authorizationEndpoint != null) {
            builder.authorizationEndpoint(json.authorizationEndpoint);
        }
        if (json.claimsParameterSupported != null) {
            builder.claimsParameterSupported(json.claimsParameterSupported);
        }
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        if (json.javaWebKeySetEndpoint != null) {
            builder.javaWebKeySetEndpoint(json.javaWebKeySetEndpoint);
        }
        if (json.serviceDocumentation != null) {
            builder.serviceDocumentation(json.serviceDocumentation);
        }
        if (json.supportedClaimTypes != null) {
            builder.addAllSupportedClaimTypes(json.supportedClaimTypes);
        }
        if (json.supportedClaims != null) {
            builder.addAllSupportedClaims(json.supportedClaims);
        }
        if (json.supportedIdTokenEncryptionAlgorithms != null) {
            builder.addAllSupportedIdTokenEncryptionAlgorithms(json.supportedIdTokenEncryptionAlgorithms);
        }
        if (json.supportedIdTokenSigningAlgorithms != null) {
            builder.addAllSupportedIdTokenSigningAlgorithms(json.supportedIdTokenSigningAlgorithms);
        }
        if (json.supportedResponseTypes != null) {
            builder.addAllSupportedResponseTypes(json.supportedResponseTypes);
        }
        if (json.supportedScopes != null) {
            builder.addAllSupportedScopes(json.supportedScopes);
        }
        if (json.supportedSubjectTypes != null) {
            builder.addAllSupportedSubjectTypes(json.supportedSubjectTypes);
        }
        if (json.supportedTokenEndpointAuthorizationMethods != null) {
            builder.addAllSupportedTokenEndpointAuthorizationMethods(json.supportedTokenEndpointAuthorizationMethods);
        }
        if (json.supportedTokenEndpointAuthorizationSigningAlgorithms != null) {
            builder.addAllSupportedTokenEndpointAuthorizationSigningAlgorithms(json.supportedTokenEndpointAuthorizationSigningAlgorithms);
        }
        if (json.supportedUiLocales != null) {
            builder.addAllSupportedUiLocales(json.supportedUiLocales);
        }
        if (json.tokenEndpoint != null) {
            builder.tokenEndpoint(json.tokenEndpoint);
        }
        if (json.userInfoEndpoint != null) {
            builder.userInfoEndpoint(json.userInfoEndpoint);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_GetOpenIdProviderConfigurationResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_AUTHORIZATION_ENDPOINT = 1L;
        private static final long INIT_BIT_CLAIMS_PARAMETER_SUPPORTED = 2L;
        private static final long INIT_BIT_ISSUER = 4L;
        private static final long INIT_BIT_JAVA_WEB_KEY_SET_ENDPOINT = 8L;
        private static final long INIT_BIT_SERVICE_DOCUMENTATION = 16L;
        private static final long INIT_BIT_TOKEN_ENDPOINT = 32L;
        private static final long INIT_BIT_USER_INFO_ENDPOINT = 64L;
        private long initBits = 127L;
        private String authorizationEndpoint;
        private Boolean claimsParameterSupported;
        private String issuer;
        private String javaWebKeySetEndpoint;
        private String serviceDocumentation;
        private List<String> supportedClaimTypes = new ArrayList<String>();
        private List<String> supportedClaims = new ArrayList<String>();
        private List<String> supportedIdTokenEncryptionAlgorithms = new ArrayList<String>();
        private List<String> supportedIdTokenSigningAlgorithms = new ArrayList<String>();
        private List<String> supportedResponseTypes = new ArrayList<String>();
        private List<String> supportedScopes = new ArrayList<String>();
        private List<String> supportedSubjectTypes = new ArrayList<String>();
        private List<String> supportedTokenEndpointAuthorizationMethods = new ArrayList<String>();
        private List<String> supportedTokenEndpointAuthorizationSigningAlgorithms = new ArrayList<String>();
        private List<Locale> supportedUiLocales = new ArrayList<Locale>();
        private String tokenEndpoint;
        private String userInfoEndpoint;

        private Builder() {
        }

        public final Builder from(GetOpenIdProviderConfigurationResponse instance) {
            return this.from((_GetOpenIdProviderConfigurationResponse)instance);
        }

        final Builder from(_GetOpenIdProviderConfigurationResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.authorizationEndpoint(instance.getAuthorizationEndpoint());
            this.claimsParameterSupported(instance.getClaimsParameterSupported());
            this.issuer(instance.getIssuer());
            this.javaWebKeySetEndpoint(instance.getJavaWebKeySetEndpoint());
            this.serviceDocumentation(instance.getServiceDocumentation());
            this.addAllSupportedClaimTypes(instance.getSupportedClaimTypes());
            this.addAllSupportedClaims(instance.getSupportedClaims());
            this.addAllSupportedIdTokenEncryptionAlgorithms(instance.getSupportedIdTokenEncryptionAlgorithms());
            this.addAllSupportedIdTokenSigningAlgorithms(instance.getSupportedIdTokenSigningAlgorithms());
            this.addAllSupportedResponseTypes(instance.getSupportedResponseTypes());
            this.addAllSupportedScopes(instance.getSupportedScopes());
            this.addAllSupportedSubjectTypes(instance.getSupportedSubjectTypes());
            this.addAllSupportedTokenEndpointAuthorizationMethods(instance.getSupportedTokenEndpointAuthorizationMethods());
            this.addAllSupportedTokenEndpointAuthorizationSigningAlgorithms(instance.getSupportedTokenEndpointAuthorizationSigningAlgorithms());
            this.addAllSupportedUiLocales(instance.getSupportedUiLocales());
            this.tokenEndpoint(instance.getTokenEndpoint());
            this.userInfoEndpoint(instance.getUserInfoEndpoint());
            return this;
        }

        @JsonProperty(value="authorization_endpoint")
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = Objects.requireNonNull(authorizationEndpoint, "authorizationEndpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="claims_parameter_supported")
        public final Builder claimsParameterSupported(Boolean claimsParameterSupported) {
            this.claimsParameterSupported = Objects.requireNonNull(claimsParameterSupported, "claimsParameterSupported");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="issuer")
        public final Builder issuer(String issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="jwks_uri")
        public final Builder javaWebKeySetEndpoint(String javaWebKeySetEndpoint) {
            this.javaWebKeySetEndpoint = Objects.requireNonNull(javaWebKeySetEndpoint, "javaWebKeySetEndpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="service_documentation")
        public final Builder serviceDocumentation(String serviceDocumentation) {
            this.serviceDocumentation = Objects.requireNonNull(serviceDocumentation, "serviceDocumentation");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder supportedClaimType(String element) {
            this.supportedClaimTypes.add(Objects.requireNonNull(element, "supportedClaimTypes element"));
            return this;
        }

        public final Builder supportedClaimTypes(String ... elements) {
            for (String element : elements) {
                this.supportedClaimTypes.add(Objects.requireNonNull(element, "supportedClaimTypes element"));
            }
            return this;
        }

        @JsonProperty(value="claim_types_supported")
        public final Builder supportedClaimTypes(Iterable<String> elements) {
            this.supportedClaimTypes.clear();
            return this.addAllSupportedClaimTypes(elements);
        }

        public final Builder addAllSupportedClaimTypes(Iterable<String> elements) {
            for (String element : elements) {
                this.supportedClaimTypes.add(Objects.requireNonNull(element, "supportedClaimTypes element"));
            }
            return this;
        }

        public final Builder supportedClaim(String element) {
            this.supportedClaims.add(Objects.requireNonNull(element, "supportedClaims element"));
            return this;
        }

        public final Builder supportedClaims(String ... elements) {
            for (String element : elements) {
                this.supportedClaims.add(Objects.requireNonNull(element, "supportedClaims element"));
            }
            return this;
        }

        @JsonProperty(value="claims_supported")
        public final Builder supportedClaims(Iterable<String> elements) {
            this.supportedClaims.clear();
            return this.addAllSupportedClaims(elements);
        }

        public final Builder addAllSupportedClaims(Iterable<String> elements) {
            for (String element : elements) {
                this.supportedClaims.add(Objects.requireNonNull(element, "supportedClaims element"));
            }
            return this;
        }

        public final Builder supportedIdTokenEncryptionAlgorithm(String element) {
            this.supportedIdTokenEncryptionAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenEncryptionAlgorithms element"));
            return this;
        }

        public final Builder supportedIdTokenEncryptionAlgorithms(String ... elements) {
            for (String element : elements) {
                this.supportedIdTokenEncryptionAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenEncryptionAlgorithms element"));
            }
            return this;
        }

        @JsonProperty(value="id_token_encryption_alg_values_supported")
        public final Builder supportedIdTokenEncryptionAlgorithms(Iterable<String> elements) {
            this.supportedIdTokenEncryptionAlgorithms.clear();
            return this.addAllSupportedIdTokenEncryptionAlgorithms(elements);
        }

        public final Builder addAllSupportedIdTokenEncryptionAlgorithms(Iterable<String> elements) {
            for (String element : elements) {
                this.supportedIdTokenEncryptionAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenEncryptionAlgorithms element"));
            }
            return this;
        }

        public final Builder supportedIdTokenSigningAlgorithm(String element) {
            this.supportedIdTokenSigningAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenSigningAlgorithms element"));
            return this;
        }

        public final Builder supportedIdTokenSigningAlgorithms(String ... elements) {
            for (String element : elements) {
                this.supportedIdTokenSigningAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenSigningAlgorithms element"));
            }
            return this;
        }

        @JsonProperty(value="id_token_signing_alg_values_supported")
        public final Builder supportedIdTokenSigningAlgorithms(Iterable<String> elements) {
            this.supportedIdTokenSigningAlgorithms.clear();
            return this.addAllSupportedIdTokenSigningAlgorithms(elements);
        }

        public final Builder addAllSupportedIdTokenSigningAlgorithms(Iterable<String> elements) {
            for (String element : elements) {
                this.supportedIdTokenSigningAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenSigningAlgorithms element"));
            }
            return this;
        }

        public final Builder supportedResponseType(String element) {
            this.supportedResponseTypes.add(Objects.requireNonNull(element, "supportedResponseTypes element"));
            return this;
        }

        public final Builder supportedResponseTypes(String ... elements) {
            for (String element : elements) {
                this.supportedResponseTypes.add(Objects.requireNonNull(element, "supportedResponseTypes element"));
            }
            return this;
        }

        @JsonProperty(value="response_types_supported")
        public final Builder supportedResponseTypes(Iterable<String> elements) {
            this.supportedResponseTypes.clear();
            return this.addAllSupportedResponseTypes(elements);
        }

        public final Builder addAllSupportedResponseTypes(Iterable<String> elements) {
            for (String element : elements) {
                this.supportedResponseTypes.add(Objects.requireNonNull(element, "supportedResponseTypes element"));
            }
            return this;
        }

        public final Builder supportedScope(String element) {
            this.supportedScopes.add(Objects.requireNonNull(element, "supportedScopes element"));
            return this;
        }

        public final Builder supportedScopes(String ... elements) {
            for (String element : elements) {
                this.supportedScopes.add(Objects.requireNonNull(element, "supportedScopes element"));
            }
            return this;
        }

        @JsonProperty(value="scopes_supported")
        public final Builder supportedScopes(Iterable<String> elements) {
            this.supportedScopes.clear();
            return this.addAllSupportedScopes(elements);
        }

        public final Builder addAllSupportedScopes(Iterable<String> elements) {
            for (String element : elements) {
                this.supportedScopes.add(Objects.requireNonNull(element, "supportedScopes element"));
            }
            return this;
        }

        public final Builder supportedSubjectType(String element) {
            this.supportedSubjectTypes.add(Objects.requireNonNull(element, "supportedSubjectTypes element"));
            return this;
        }

        public final Builder supportedSubjectTypes(String ... elements) {
            for (String element : elements) {
                this.supportedSubjectTypes.add(Objects.requireNonNull(element, "supportedSubjectTypes element"));
            }
            return this;
        }

        @JsonProperty(value="subject_types_supported")
        public final Builder supportedSubjectTypes(Iterable<String> elements) {
            this.supportedSubjectTypes.clear();
            return this.addAllSupportedSubjectTypes(elements);
        }

        public final Builder addAllSupportedSubjectTypes(Iterable<String> elements) {
            for (String element : elements) {
                this.supportedSubjectTypes.add(Objects.requireNonNull(element, "supportedSubjectTypes element"));
            }
            return this;
        }

        public final Builder supportedTokenEndpointAuthorizationMethod(String element) {
            this.supportedTokenEndpointAuthorizationMethods.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationMethods element"));
            return this;
        }

        public final Builder supportedTokenEndpointAuthorizationMethods(String ... elements) {
            for (String element : elements) {
                this.supportedTokenEndpointAuthorizationMethods.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationMethods element"));
            }
            return this;
        }

        @JsonProperty(value="token_endpoint_auth_methods_supported")
        public final Builder supportedTokenEndpointAuthorizationMethods(Iterable<String> elements) {
            this.supportedTokenEndpointAuthorizationMethods.clear();
            return this.addAllSupportedTokenEndpointAuthorizationMethods(elements);
        }

        public final Builder addAllSupportedTokenEndpointAuthorizationMethods(Iterable<String> elements) {
            for (String element : elements) {
                this.supportedTokenEndpointAuthorizationMethods.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationMethods element"));
            }
            return this;
        }

        public final Builder supportedTokenEndpointAuthorizationSigningAlgorithm(String element) {
            this.supportedTokenEndpointAuthorizationSigningAlgorithms.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationSigningAlgorithms element"));
            return this;
        }

        public final Builder supportedTokenEndpointAuthorizationSigningAlgorithms(String ... elements) {
            for (String element : elements) {
                this.supportedTokenEndpointAuthorizationSigningAlgorithms.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationSigningAlgorithms element"));
            }
            return this;
        }

        @JsonProperty(value="token_endpoint_auth_signing_alg_values_supported")
        public final Builder supportedTokenEndpointAuthorizationSigningAlgorithms(Iterable<String> elements) {
            this.supportedTokenEndpointAuthorizationSigningAlgorithms.clear();
            return this.addAllSupportedTokenEndpointAuthorizationSigningAlgorithms(elements);
        }

        public final Builder addAllSupportedTokenEndpointAuthorizationSigningAlgorithms(Iterable<String> elements) {
            for (String element : elements) {
                this.supportedTokenEndpointAuthorizationSigningAlgorithms.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationSigningAlgorithms element"));
            }
            return this;
        }

        public final Builder supportedUiLocale(Locale element) {
            this.supportedUiLocales.add(Objects.requireNonNull(element, "supportedUiLocales element"));
            return this;
        }

        public final Builder supportedUiLocales(Locale ... elements) {
            for (Locale element : elements) {
                this.supportedUiLocales.add(Objects.requireNonNull(element, "supportedUiLocales element"));
            }
            return this;
        }

        @JsonProperty(value="ui_locales_supported")
        public final Builder supportedUiLocales(Iterable<? extends Locale> elements) {
            this.supportedUiLocales.clear();
            return this.addAllSupportedUiLocales(elements);
        }

        public final Builder addAllSupportedUiLocales(Iterable<? extends Locale> elements) {
            for (Locale locale : elements) {
                this.supportedUiLocales.add(Objects.requireNonNull(locale, "supportedUiLocales element"));
            }
            return this;
        }

        @JsonProperty(value="token_endpoint")
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = Objects.requireNonNull(tokenEndpoint, "tokenEndpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="userinfo_endpoint")
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = Objects.requireNonNull(userInfoEndpoint, "userInfoEndpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public GetOpenIdProviderConfigurationResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetOpenIdProviderConfigurationResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authorizationEndpoint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("claimsParameterSupported");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("issuer");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("javaWebKeySetEndpoint");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("serviceDocumentation");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("tokenEndpoint");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("userInfoEndpoint");
            }
            return "Cannot build GetOpenIdProviderConfigurationResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_GetOpenIdProviderConfigurationResponse", generator="Immutables")
    static final class Json
    extends _GetOpenIdProviderConfigurationResponse {
        String authorizationEndpoint;
        Boolean claimsParameterSupported;
        String issuer;
        String javaWebKeySetEndpoint;
        String serviceDocumentation;
        List<String> supportedClaimTypes = Collections.emptyList();
        List<String> supportedClaims = Collections.emptyList();
        List<String> supportedIdTokenEncryptionAlgorithms = Collections.emptyList();
        List<String> supportedIdTokenSigningAlgorithms = Collections.emptyList();
        List<String> supportedResponseTypes = Collections.emptyList();
        List<String> supportedScopes = Collections.emptyList();
        List<String> supportedSubjectTypes = Collections.emptyList();
        List<String> supportedTokenEndpointAuthorizationMethods = Collections.emptyList();
        List<String> supportedTokenEndpointAuthorizationSigningAlgorithms = Collections.emptyList();
        List<Locale> supportedUiLocales = Collections.emptyList();
        String tokenEndpoint;
        String userInfoEndpoint;

        Json() {
        }

        @JsonProperty(value="authorization_endpoint")
        public void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @JsonProperty(value="claims_parameter_supported")
        public void setClaimsParameterSupported(Boolean claimsParameterSupported) {
            this.claimsParameterSupported = claimsParameterSupported;
        }

        @JsonProperty(value="issuer")
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @JsonProperty(value="jwks_uri")
        public void setJavaWebKeySetEndpoint(String javaWebKeySetEndpoint) {
            this.javaWebKeySetEndpoint = javaWebKeySetEndpoint;
        }

        @JsonProperty(value="service_documentation")
        public void setServiceDocumentation(String serviceDocumentation) {
            this.serviceDocumentation = serviceDocumentation;
        }

        @JsonProperty(value="claim_types_supported")
        public void setSupportedClaimTypes(List<String> supportedClaimTypes) {
            this.supportedClaimTypes = supportedClaimTypes;
        }

        @JsonProperty(value="claims_supported")
        public void setSupportedClaims(List<String> supportedClaims) {
            this.supportedClaims = supportedClaims;
        }

        @JsonProperty(value="id_token_encryption_alg_values_supported")
        public void setSupportedIdTokenEncryptionAlgorithms(List<String> supportedIdTokenEncryptionAlgorithms) {
            this.supportedIdTokenEncryptionAlgorithms = supportedIdTokenEncryptionAlgorithms;
        }

        @JsonProperty(value="id_token_signing_alg_values_supported")
        public void setSupportedIdTokenSigningAlgorithms(List<String> supportedIdTokenSigningAlgorithms) {
            this.supportedIdTokenSigningAlgorithms = supportedIdTokenSigningAlgorithms;
        }

        @JsonProperty(value="response_types_supported")
        public void setSupportedResponseTypes(List<String> supportedResponseTypes) {
            this.supportedResponseTypes = supportedResponseTypes;
        }

        @JsonProperty(value="scopes_supported")
        public void setSupportedScopes(List<String> supportedScopes) {
            this.supportedScopes = supportedScopes;
        }

        @JsonProperty(value="subject_types_supported")
        public void setSupportedSubjectTypes(List<String> supportedSubjectTypes) {
            this.supportedSubjectTypes = supportedSubjectTypes;
        }

        @JsonProperty(value="token_endpoint_auth_methods_supported")
        public void setSupportedTokenEndpointAuthorizationMethods(List<String> supportedTokenEndpointAuthorizationMethods) {
            this.supportedTokenEndpointAuthorizationMethods = supportedTokenEndpointAuthorizationMethods;
        }

        @JsonProperty(value="token_endpoint_auth_signing_alg_values_supported")
        public void setSupportedTokenEndpointAuthorizationSigningAlgorithms(List<String> supportedTokenEndpointAuthorizationSigningAlgorithms) {
            this.supportedTokenEndpointAuthorizationSigningAlgorithms = supportedTokenEndpointAuthorizationSigningAlgorithms;
        }

        @JsonProperty(value="ui_locales_supported")
        public void setSupportedUiLocales(List<Locale> supportedUiLocales) {
            this.supportedUiLocales = supportedUiLocales;
        }

        @JsonProperty(value="token_endpoint")
        public void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @JsonProperty(value="userinfo_endpoint")
        public void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        @Override
        public String getAuthorizationEndpoint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getClaimsParameterSupported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIssuer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getJavaWebKeySetEndpoint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceDocumentation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSupportedClaimTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSupportedClaims() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSupportedIdTokenEncryptionAlgorithms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSupportedIdTokenSigningAlgorithms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSupportedResponseTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSupportedScopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSupportedSubjectTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSupportedTokenEndpointAuthorizationMethods() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSupportedTokenEndpointAuthorizationSigningAlgorithms() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Locale> getSupportedUiLocales() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTokenEndpoint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserInfoEndpoint() {
            throw new UnsupportedOperationException();
        }
    }
}

