/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients.CreateClient;
import org.cloudfoundry.uaa.clients._BatchCreateClientsRequest;
import org.immutables.value.Generated;

@Generated(from="_BatchCreateClientsRequest", generator="Immutables")
public final class BatchCreateClientsRequest
extends _BatchCreateClientsRequest {
    private final List<CreateClient> clients;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private BatchCreateClientsRequest(Builder builder) {
        this.clients = BatchCreateClientsRequest.createUnmodifiableList(true, builder.clients);
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    @JsonProperty(value="clients")
    @JsonIgnore
    public List<CreateClient> getClients() {
        return this.clients;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="identityZoneSubdomain")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BatchCreateClientsRequest && this.equalTo((BatchCreateClientsRequest)another);
    }

    private boolean equalTo(BatchCreateClientsRequest another) {
        return this.clients.equals(another.clients) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clients.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "BatchCreateClientsRequest{clients=" + this.clients + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BatchCreateClientsRequest fromJson(Json json) {
        Builder builder = BatchCreateClientsRequest.builder();
        if (json.clients != null) {
            builder.addAllClients(json.clients);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.identityZoneSubdomain != null) {
            builder.identityZoneSubdomain(json.identityZoneSubdomain);
        }
        return builder.build();
    }

    private static BatchCreateClientsRequest validate(BatchCreateClientsRequest instance) {
        instance.checkClients();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_BatchCreateClientsRequest", generator="Immutables")
    public static final class Builder {
        private List<CreateClient> clients = new ArrayList<CreateClient>();
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BatchCreateClientsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_BatchCreateClientsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _BatchCreateClientsRequest) {
                instance = (_BatchCreateClientsRequest)object;
                this.addAllClients(((_BatchCreateClientsRequest)instance).getClients());
            }
        }

        public final Builder client(CreateClient element) {
            this.clients.add(Objects.requireNonNull(element, "clients element"));
            return this;
        }

        public final Builder clients(CreateClient ... elements) {
            for (CreateClient element : elements) {
                this.clients.add(Objects.requireNonNull(element, "clients element"));
            }
            return this;
        }

        public final Builder clients(Iterable<? extends CreateClient> elements) {
            this.clients.clear();
            return this.addAllClients(elements);
        }

        public final Builder addAllClients(Iterable<? extends CreateClient> elements) {
            for (CreateClient createClient : elements) {
                this.clients.add(Objects.requireNonNull(createClient, "clients element"));
            }
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public BatchCreateClientsRequest build() {
            return BatchCreateClientsRequest.validate(new BatchCreateClientsRequest(this));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_BatchCreateClientsRequest", generator="Immutables")
    static final class Json
    extends _BatchCreateClientsRequest {
        List<CreateClient> clients = Collections.emptyList();
        String identityZoneId;
        String identityZoneSubdomain;

        Json() {
        }

        @JsonProperty(value="clients")
        @JsonIgnore
        public void setClients(List<CreateClient> clients) {
            this.clients = clients;
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="identityZoneSubdomain")
        @JsonIgnore
        public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
        }

        @Override
        public List<CreateClient> getClients() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneSubdomain() {
            throw new UnsupportedOperationException();
        }
    }
}

