/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Optional;
import org.cloudfoundry.uaa.groups.AbstractMember;
import org.cloudfoundry.uaa.groups.Entity;
import org.cloudfoundry.uaa.groups.GroupEntity;
import org.cloudfoundry.uaa.groups.Member;
import org.cloudfoundry.uaa.groups.MemberType;
import org.cloudfoundry.uaa.groups.UserEntity;
import org.immutables.value.Value;

@JsonDeserialize(using=MemberDeserializer.class)
@Value.Immutable
abstract class _Member
extends AbstractMember {
    _Member() {
    }

    abstract Optional<Entity> getEntity();

    static final class MemberDeserializer
    extends StdDeserializer<Member> {
        private static final long serialVersionUID = 6109722182337225713L;

        MemberDeserializer() {
            super(Member.class);
        }

        public Member deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Member.Builder builder = Member.builder();
            ObjectCodec codec = p.getCodec();
            ObjectNode tree = (ObjectNode)p.readValueAsTree();
            if (tree.has("entity")) {
                JsonNode entity = tree.get("entity");
                String type = tree.get("type").asText();
                if (MemberType.GROUP.getValue().equalsIgnoreCase(type)) {
                    builder.entity((Entity)codec.treeToValue((TreeNode)entity, GroupEntity.class));
                } else if (MemberType.USER.getValue().equalsIgnoreCase(type)) {
                    builder.entity((Entity)codec.treeToValue((TreeNode)entity, UserEntity.class));
                } else {
                    throw new IllegalArgumentException(String.format("Unknown member type: %s", type));
                }
            }
            builder.memberId(tree.get("value").asText());
            if (tree.has("origin")) {
                builder.origin(tree.get("origin").asText());
            }
            if (tree.has("type")) {
                builder.type((MemberType)((Object)codec.treeToValue((TreeNode)tree.get("type"), MemberType.class)));
            }
            return builder.build();
        }
    }
}

