/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityproviders.AbstractExternalIdentityProviderConfiguration;
import org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration;
import org.cloudfoundry.uaa.identityproviders.AttributeMappings;
import org.cloudfoundry.uaa.identityproviders.LdapGroupFile;
import org.cloudfoundry.uaa.identityproviders.LdapProfileFile;
import org.cloudfoundry.uaa.identityproviders.TlsConfiguration;
import org.cloudfoundry.uaa.identityproviders._LdapConfiguration;
import org.immutables.value.Generated;

@Generated(from="_LdapConfiguration", generator="Immutables")
public final class LdapConfiguration
extends _LdapConfiguration {
    @Nullable
    private final Boolean addShadowUserOnLogin;
    @Nullable
    private final Boolean autoAddGroups;
    @Nullable
    private final String baseUrl;
    @Nullable
    private final String bindPassword;
    @Nullable
    private final String bindUserDistinguishedName;
    @Nullable
    private final String groupRoleAttribute;
    @Nullable
    private final String groupSearchBase;
    @Nullable
    private final Integer groupSearchDepthLimit;
    @Nullable
    private final String groupSearchFilter;
    @Nullable
    private final Boolean groupSearchSubTree;
    @Nullable
    private final Boolean groupsIgnorePartialResults;
    @Nullable
    private final LdapGroupFile ldapGroupFile;
    @Nullable
    private final LdapProfileFile ldapProfileFile;
    @Nullable
    private final Boolean localPasswordCompare;
    @Nullable
    private final String mailAttributeName;
    @Nullable
    private final String mailSubstitute;
    @Nullable
    private final Boolean mailSubstituteOverridesLdap;
    @Nullable
    private final String passwordAttributeName;
    @Nullable
    private final String passwordEncoder;
    @Nullable
    private final String referral;
    @Nullable
    private final Boolean skipSSLVerification;
    @Nullable
    private final TlsConfiguration tlsConfiguration;
    @Nullable
    private final String userDistinguishedNamePattern;
    @Nullable
    private final String userDistinguishedNamePatternDelimiter;
    @Nullable
    private final String userSearchBase;
    @Nullable
    private final String userSearchFilter;
    @Nullable
    private final AttributeMappings attributeMappings;
    @Nullable
    private final List<String> externalGroupsWhitelist;
    @Nullable
    private final Boolean storeCustomAttributes;
    @Nullable
    private final List<String> emailDomains;
    @Nullable
    private final String providerDescription;

    private LdapConfiguration(Builder builder) {
        this.addShadowUserOnLogin = builder.addShadowUserOnLogin;
        this.autoAddGroups = builder.autoAddGroups;
        this.baseUrl = builder.baseUrl;
        this.bindPassword = builder.bindPassword;
        this.bindUserDistinguishedName = builder.bindUserDistinguishedName;
        this.groupRoleAttribute = builder.groupRoleAttribute;
        this.groupSearchBase = builder.groupSearchBase;
        this.groupSearchDepthLimit = builder.groupSearchDepthLimit;
        this.groupSearchFilter = builder.groupSearchFilter;
        this.groupSearchSubTree = builder.groupSearchSubTree;
        this.groupsIgnorePartialResults = builder.groupsIgnorePartialResults;
        this.ldapGroupFile = builder.ldapGroupFile;
        this.ldapProfileFile = builder.ldapProfileFile;
        this.localPasswordCompare = builder.localPasswordCompare;
        this.mailAttributeName = builder.mailAttributeName;
        this.mailSubstitute = builder.mailSubstitute;
        this.mailSubstituteOverridesLdap = builder.mailSubstituteOverridesLdap;
        this.passwordAttributeName = builder.passwordAttributeName;
        this.passwordEncoder = builder.passwordEncoder;
        this.referral = builder.referral;
        this.skipSSLVerification = builder.skipSSLVerification;
        this.tlsConfiguration = builder.tlsConfiguration;
        this.userDistinguishedNamePattern = builder.userDistinguishedNamePattern;
        this.userDistinguishedNamePatternDelimiter = builder.userDistinguishedNamePatternDelimiter;
        this.userSearchBase = builder.userSearchBase;
        this.userSearchFilter = builder.userSearchFilter;
        this.attributeMappings = builder.attributeMappings;
        this.externalGroupsWhitelist = builder.externalGroupsWhitelist == null ? null : LdapConfiguration.createUnmodifiableList(true, builder.externalGroupsWhitelist);
        this.storeCustomAttributes = builder.storeCustomAttributes;
        this.emailDomains = builder.emailDomains == null ? null : LdapConfiguration.createUnmodifiableList(true, builder.emailDomains);
        this.providerDescription = builder.providerDescription;
    }

    @Override
    @JsonProperty(value="addShadowUserOnLogin")
    @Nullable
    public Boolean getAddShadowUserOnLogin() {
        return this.addShadowUserOnLogin;
    }

    @Override
    @JsonProperty(value="autoAddGroups")
    @Nullable
    public Boolean getAutoAddGroups() {
        return this.autoAddGroups;
    }

    @Override
    @JsonProperty(value="baseUrl")
    @Nullable
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @JsonProperty(value="bindPassword")
    @Nullable
    public String getBindPassword() {
        return this.bindPassword;
    }

    @Override
    @JsonProperty(value="bindUserDn")
    @Nullable
    public String getBindUserDistinguishedName() {
        return this.bindUserDistinguishedName;
    }

    @Override
    @JsonProperty(value="groupRoleAttribute")
    @Nullable
    public String getGroupRoleAttribute() {
        return this.groupRoleAttribute;
    }

    @Override
    @JsonProperty(value="groupSearchBase")
    @Nullable
    public String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    @Override
    @JsonProperty(value="maxGroupSearchDepth")
    @Nullable
    public Integer getGroupSearchDepthLimit() {
        return this.groupSearchDepthLimit;
    }

    @Override
    @JsonProperty(value="groupSearchFilter")
    @Nullable
    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    @Override
    @JsonProperty(value="groupSearchSubTree")
    @Nullable
    public Boolean getGroupSearchSubTree() {
        return this.groupSearchSubTree;
    }

    @Override
    @JsonProperty(value="groupsIgnorePartialResults")
    @Nullable
    public Boolean getGroupsIgnorePartialResults() {
        return this.groupsIgnorePartialResults;
    }

    @Override
    @JsonProperty(value="ldapGroupFile")
    @Nullable
    public LdapGroupFile getLdapGroupFile() {
        return this.ldapGroupFile;
    }

    @Override
    @JsonProperty(value="ldapProfileFile")
    @Nullable
    public LdapProfileFile getLdapProfileFile() {
        return this.ldapProfileFile;
    }

    @Override
    @JsonProperty(value="localPasswordCompare")
    @Nullable
    public Boolean getLocalPasswordCompare() {
        return this.localPasswordCompare;
    }

    @Override
    @JsonProperty(value="mailAttributeName")
    @Nullable
    public String getMailAttributeName() {
        return this.mailAttributeName;
    }

    @Override
    @JsonProperty(value="mailSubstitute")
    @Nullable
    public String getMailSubstitute() {
        return this.mailSubstitute;
    }

    @Override
    @JsonProperty(value="mailSubstituteOverridesLdap")
    @Nullable
    public Boolean getMailSubstituteOverridesLdap() {
        return this.mailSubstituteOverridesLdap;
    }

    @Override
    @JsonProperty(value="passwordAttributeName")
    @Nullable
    public String getPasswordAttributeName() {
        return this.passwordAttributeName;
    }

    @Override
    @JsonProperty(value="passwordEncoder")
    @Nullable
    public String getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @Override
    @JsonProperty(value="referral")
    @Nullable
    public String getReferral() {
        return this.referral;
    }

    @Override
    @JsonProperty(value="skipSSLVerification")
    @Nullable
    public Boolean getSkipSSLVerification() {
        return this.skipSSLVerification;
    }

    @Override
    @JsonProperty(value="tlsConfiguration")
    @Nullable
    public TlsConfiguration getTlsConfiguration() {
        return this.tlsConfiguration;
    }

    @Override
    @JsonProperty(value="userDNPattern")
    @Nullable
    public String getUserDistinguishedNamePattern() {
        return this.userDistinguishedNamePattern;
    }

    @Override
    @JsonProperty(value="userDNPatternDelimiter")
    @Nullable
    public String getUserDistinguishedNamePatternDelimiter() {
        return this.userDistinguishedNamePatternDelimiter;
    }

    @Override
    @JsonProperty(value="userSearchBase")
    @Nullable
    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    @Override
    @JsonProperty(value="userSearchFilter")
    @Nullable
    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    @Override
    @JsonProperty(value="attributeMappings")
    @Nullable
    public AttributeMappings getAttributeMappings() {
        return this.attributeMappings;
    }

    @Override
    @JsonProperty(value="externalGroupsWhitelist")
    @Nullable
    public List<String> getExternalGroupsWhitelist() {
        return this.externalGroupsWhitelist;
    }

    @Override
    @JsonProperty(value="storeCustomAttributes")
    @Nullable
    public Boolean getStoreCustomAttributes() {
        return this.storeCustomAttributes;
    }

    @Override
    @JsonProperty(value="emailDomain")
    @Nullable
    public List<String> getEmailDomains() {
        return this.emailDomains;
    }

    @Override
    @JsonProperty(value="providerDescription")
    @Nullable
    public String getProviderDescription() {
        return this.providerDescription;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LdapConfiguration && this.equalTo((LdapConfiguration)another);
    }

    private boolean equalTo(LdapConfiguration another) {
        return Objects.equals(this.addShadowUserOnLogin, another.addShadowUserOnLogin) && Objects.equals(this.autoAddGroups, another.autoAddGroups) && Objects.equals(this.baseUrl, another.baseUrl) && Objects.equals(this.bindPassword, another.bindPassword) && Objects.equals(this.bindUserDistinguishedName, another.bindUserDistinguishedName) && Objects.equals(this.groupRoleAttribute, another.groupRoleAttribute) && Objects.equals(this.groupSearchBase, another.groupSearchBase) && Objects.equals(this.groupSearchDepthLimit, another.groupSearchDepthLimit) && Objects.equals(this.groupSearchFilter, another.groupSearchFilter) && Objects.equals(this.groupSearchSubTree, another.groupSearchSubTree) && Objects.equals(this.groupsIgnorePartialResults, another.groupsIgnorePartialResults) && Objects.equals((Object)this.ldapGroupFile, (Object)another.ldapGroupFile) && Objects.equals((Object)this.ldapProfileFile, (Object)another.ldapProfileFile) && Objects.equals(this.localPasswordCompare, another.localPasswordCompare) && Objects.equals(this.mailAttributeName, another.mailAttributeName) && Objects.equals(this.mailSubstitute, another.mailSubstitute) && Objects.equals(this.mailSubstituteOverridesLdap, another.mailSubstituteOverridesLdap) && Objects.equals(this.passwordAttributeName, another.passwordAttributeName) && Objects.equals(this.passwordEncoder, another.passwordEncoder) && Objects.equals(this.referral, another.referral) && Objects.equals(this.skipSSLVerification, another.skipSSLVerification) && Objects.equals((Object)this.tlsConfiguration, (Object)another.tlsConfiguration) && Objects.equals(this.userDistinguishedNamePattern, another.userDistinguishedNamePattern) && Objects.equals(this.userDistinguishedNamePatternDelimiter, another.userDistinguishedNamePatternDelimiter) && Objects.equals(this.userSearchBase, another.userSearchBase) && Objects.equals(this.userSearchFilter, another.userSearchFilter) && Objects.equals(this.attributeMappings, another.attributeMappings) && Objects.equals(this.externalGroupsWhitelist, another.externalGroupsWhitelist) && Objects.equals(this.storeCustomAttributes, another.storeCustomAttributes) && Objects.equals(this.emailDomains, another.emailDomains) && Objects.equals(this.providerDescription, another.providerDescription);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.addShadowUserOnLogin);
        h += (h << 5) + Objects.hashCode(this.autoAddGroups);
        h += (h << 5) + Objects.hashCode(this.baseUrl);
        h += (h << 5) + Objects.hashCode(this.bindPassword);
        h += (h << 5) + Objects.hashCode(this.bindUserDistinguishedName);
        h += (h << 5) + Objects.hashCode(this.groupRoleAttribute);
        h += (h << 5) + Objects.hashCode(this.groupSearchBase);
        h += (h << 5) + Objects.hashCode(this.groupSearchDepthLimit);
        h += (h << 5) + Objects.hashCode(this.groupSearchFilter);
        h += (h << 5) + Objects.hashCode(this.groupSearchSubTree);
        h += (h << 5) + Objects.hashCode(this.groupsIgnorePartialResults);
        h += (h << 5) + Objects.hashCode((Object)this.ldapGroupFile);
        h += (h << 5) + Objects.hashCode((Object)this.ldapProfileFile);
        h += (h << 5) + Objects.hashCode(this.localPasswordCompare);
        h += (h << 5) + Objects.hashCode(this.mailAttributeName);
        h += (h << 5) + Objects.hashCode(this.mailSubstitute);
        h += (h << 5) + Objects.hashCode(this.mailSubstituteOverridesLdap);
        h += (h << 5) + Objects.hashCode(this.passwordAttributeName);
        h += (h << 5) + Objects.hashCode(this.passwordEncoder);
        h += (h << 5) + Objects.hashCode(this.referral);
        h += (h << 5) + Objects.hashCode(this.skipSSLVerification);
        h += (h << 5) + Objects.hashCode((Object)this.tlsConfiguration);
        h += (h << 5) + Objects.hashCode(this.userDistinguishedNamePattern);
        h += (h << 5) + Objects.hashCode(this.userDistinguishedNamePatternDelimiter);
        h += (h << 5) + Objects.hashCode(this.userSearchBase);
        h += (h << 5) + Objects.hashCode(this.userSearchFilter);
        h += (h << 5) + Objects.hashCode(this.attributeMappings);
        h += (h << 5) + Objects.hashCode(this.externalGroupsWhitelist);
        h += (h << 5) + Objects.hashCode(this.storeCustomAttributes);
        h += (h << 5) + Objects.hashCode(this.emailDomains);
        h += (h << 5) + Objects.hashCode(this.providerDescription);
        return h;
    }

    public String toString() {
        return "LdapConfiguration{addShadowUserOnLogin=" + this.addShadowUserOnLogin + ", autoAddGroups=" + this.autoAddGroups + ", baseUrl=" + this.baseUrl + ", bindPassword=" + this.bindPassword + ", bindUserDistinguishedName=" + this.bindUserDistinguishedName + ", groupRoleAttribute=" + this.groupRoleAttribute + ", groupSearchBase=" + this.groupSearchBase + ", groupSearchDepthLimit=" + this.groupSearchDepthLimit + ", groupSearchFilter=" + this.groupSearchFilter + ", groupSearchSubTree=" + this.groupSearchSubTree + ", groupsIgnorePartialResults=" + this.groupsIgnorePartialResults + ", ldapGroupFile=" + (Object)((Object)this.ldapGroupFile) + ", ldapProfileFile=" + (Object)((Object)this.ldapProfileFile) + ", localPasswordCompare=" + this.localPasswordCompare + ", mailAttributeName=" + this.mailAttributeName + ", mailSubstitute=" + this.mailSubstitute + ", mailSubstituteOverridesLdap=" + this.mailSubstituteOverridesLdap + ", passwordAttributeName=" + this.passwordAttributeName + ", passwordEncoder=" + this.passwordEncoder + ", referral=" + this.referral + ", skipSSLVerification=" + this.skipSSLVerification + ", tlsConfiguration=" + (Object)((Object)this.tlsConfiguration) + ", userDistinguishedNamePattern=" + this.userDistinguishedNamePattern + ", userDistinguishedNamePatternDelimiter=" + this.userDistinguishedNamePatternDelimiter + ", userSearchBase=" + this.userSearchBase + ", userSearchFilter=" + this.userSearchFilter + ", attributeMappings=" + this.attributeMappings + ", externalGroupsWhitelist=" + this.externalGroupsWhitelist + ", storeCustomAttributes=" + this.storeCustomAttributes + ", emailDomains=" + this.emailDomains + ", providerDescription=" + this.providerDescription + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static LdapConfiguration fromJson(Json json) {
        Builder builder = LdapConfiguration.builder();
        if (json.addShadowUserOnLogin != null) {
            builder.addShadowUserOnLogin(json.addShadowUserOnLogin);
        }
        if (json.autoAddGroups != null) {
            builder.autoAddGroups(json.autoAddGroups);
        }
        if (json.baseUrl != null) {
            builder.baseUrl(json.baseUrl);
        }
        if (json.bindPassword != null) {
            builder.bindPassword(json.bindPassword);
        }
        if (json.bindUserDistinguishedName != null) {
            builder.bindUserDistinguishedName(json.bindUserDistinguishedName);
        }
        if (json.groupRoleAttribute != null) {
            builder.groupRoleAttribute(json.groupRoleAttribute);
        }
        if (json.groupSearchBase != null) {
            builder.groupSearchBase(json.groupSearchBase);
        }
        if (json.groupSearchDepthLimit != null) {
            builder.groupSearchDepthLimit(json.groupSearchDepthLimit);
        }
        if (json.groupSearchFilter != null) {
            builder.groupSearchFilter(json.groupSearchFilter);
        }
        if (json.groupSearchSubTree != null) {
            builder.groupSearchSubTree(json.groupSearchSubTree);
        }
        if (json.groupsIgnorePartialResults != null) {
            builder.groupsIgnorePartialResults(json.groupsIgnorePartialResults);
        }
        if (json.ldapGroupFile != null) {
            builder.ldapGroupFile(json.ldapGroupFile);
        }
        if (json.ldapProfileFile != null) {
            builder.ldapProfileFile(json.ldapProfileFile);
        }
        if (json.localPasswordCompare != null) {
            builder.localPasswordCompare(json.localPasswordCompare);
        }
        if (json.mailAttributeName != null) {
            builder.mailAttributeName(json.mailAttributeName);
        }
        if (json.mailSubstitute != null) {
            builder.mailSubstitute(json.mailSubstitute);
        }
        if (json.mailSubstituteOverridesLdap != null) {
            builder.mailSubstituteOverridesLdap(json.mailSubstituteOverridesLdap);
        }
        if (json.passwordAttributeName != null) {
            builder.passwordAttributeName(json.passwordAttributeName);
        }
        if (json.passwordEncoder != null) {
            builder.passwordEncoder(json.passwordEncoder);
        }
        if (json.referral != null) {
            builder.referral(json.referral);
        }
        if (json.skipSSLVerification != null) {
            builder.skipSSLVerification(json.skipSSLVerification);
        }
        if (json.tlsConfiguration != null) {
            builder.tlsConfiguration(json.tlsConfiguration);
        }
        if (json.userDistinguishedNamePattern != null) {
            builder.userDistinguishedNamePattern(json.userDistinguishedNamePattern);
        }
        if (json.userDistinguishedNamePatternDelimiter != null) {
            builder.userDistinguishedNamePatternDelimiter(json.userDistinguishedNamePatternDelimiter);
        }
        if (json.userSearchBase != null) {
            builder.userSearchBase(json.userSearchBase);
        }
        if (json.userSearchFilter != null) {
            builder.userSearchFilter(json.userSearchFilter);
        }
        if (json.attributeMappings != null) {
            builder.attributeMappings(json.attributeMappings);
        }
        if (json.externalGroupsWhitelist != null) {
            builder.addAllExternalGroupsWhitelist(json.externalGroupsWhitelist);
        }
        if (json.storeCustomAttributes != null) {
            builder.storeCustomAttributes(json.storeCustomAttributes);
        }
        if (json.emailDomains != null) {
            builder.addAllEmailDomains(json.emailDomains);
        }
        if (json.providerDescription != null) {
            builder.providerDescription(json.providerDescription);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_LdapConfiguration", generator="Immutables")
    public static final class Builder {
        private Boolean addShadowUserOnLogin;
        private Boolean autoAddGroups;
        private String baseUrl;
        private String bindPassword;
        private String bindUserDistinguishedName;
        private String groupRoleAttribute;
        private String groupSearchBase;
        private Integer groupSearchDepthLimit;
        private String groupSearchFilter;
        private Boolean groupSearchSubTree;
        private Boolean groupsIgnorePartialResults;
        private LdapGroupFile ldapGroupFile;
        private LdapProfileFile ldapProfileFile;
        private Boolean localPasswordCompare;
        private String mailAttributeName;
        private String mailSubstitute;
        private Boolean mailSubstituteOverridesLdap;
        private String passwordAttributeName;
        private String passwordEncoder;
        private String referral;
        private Boolean skipSSLVerification;
        private TlsConfiguration tlsConfiguration;
        private String userDistinguishedNamePattern;
        private String userDistinguishedNamePatternDelimiter;
        private String userSearchBase;
        private String userSearchFilter;
        private AttributeMappings attributeMappings;
        private List<String> externalGroupsWhitelist = null;
        private Boolean storeCustomAttributes;
        private List<String> emailDomains = null;
        private String providerDescription;

        private Builder() {
        }

        public final Builder from(AbstractIdentityProviderConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractExternalIdentityProviderConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LdapConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_LdapConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractIdentityProviderConfiguration instance;
            if (object instanceof AbstractIdentityProviderConfiguration) {
                String providerDescriptionValue;
                instance = (AbstractIdentityProviderConfiguration)object;
                List<String> emailDomainsValue = instance.getEmailDomains();
                if (emailDomainsValue != null) {
                    this.addAllEmailDomains(emailDomainsValue);
                }
                if ((providerDescriptionValue = instance.getProviderDescription()) != null) {
                    this.providerDescription(providerDescriptionValue);
                }
            }
            if (object instanceof AbstractExternalIdentityProviderConfiguration) {
                Boolean storeCustomAttributesValue;
                AttributeMappings attributeMappingsValue;
                instance = (AbstractExternalIdentityProviderConfiguration)object;
                List<String> externalGroupsWhitelistValue = ((AbstractExternalIdentityProviderConfiguration)instance).getExternalGroupsWhitelist();
                if (externalGroupsWhitelistValue != null) {
                    this.addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
                }
                if ((attributeMappingsValue = ((AbstractExternalIdentityProviderConfiguration)instance).getAttributeMappings()) != null) {
                    this.attributeMappings(attributeMappingsValue);
                }
                if ((storeCustomAttributesValue = ((AbstractExternalIdentityProviderConfiguration)instance).getStoreCustomAttributes()) != null) {
                    this.storeCustomAttributes(storeCustomAttributesValue);
                }
            }
            if (object instanceof _LdapConfiguration) {
                String passwordAttributeNameValue;
                String mailAttributeNameValue;
                String referralValue;
                String groupSearchBaseValue;
                String baseUrlValue;
                String passwordEncoderValue;
                String userDistinguishedNamePatternDelimiterValue;
                Boolean localPasswordCompareValue;
                Boolean addShadowUserOnLoginValue;
                Boolean groupSearchSubTreeValue;
                String userDistinguishedNamePatternValue;
                Boolean groupsIgnorePartialResultsValue;
                TlsConfiguration tlsConfigurationValue;
                String bindUserDistinguishedNameValue;
                String mailSubstituteValue;
                Integer groupSearchDepthLimitValue;
                String groupSearchFilterValue;
                String userSearchFilterValue;
                String groupRoleAttributeValue;
                String userSearchBaseValue;
                LdapProfileFile ldapProfileFileValue;
                Boolean autoAddGroupsValue;
                LdapGroupFile ldapGroupFileValue;
                Boolean skipSSLVerificationValue;
                Boolean mailSubstituteOverridesLdapValue;
                instance = (_LdapConfiguration)object;
                String bindPasswordValue = ((_LdapConfiguration)instance).getBindPassword();
                if (bindPasswordValue != null) {
                    this.bindPassword(bindPasswordValue);
                }
                if ((mailSubstituteOverridesLdapValue = ((_LdapConfiguration)instance).getMailSubstituteOverridesLdap()) != null) {
                    this.mailSubstituteOverridesLdap(mailSubstituteOverridesLdapValue);
                }
                if ((skipSSLVerificationValue = ((_LdapConfiguration)instance).getSkipSSLVerification()) != null) {
                    this.skipSSLVerification(skipSSLVerificationValue);
                }
                if ((ldapGroupFileValue = ((_LdapConfiguration)instance).getLdapGroupFile()) != null) {
                    this.ldapGroupFile(ldapGroupFileValue);
                }
                if ((autoAddGroupsValue = ((_LdapConfiguration)instance).getAutoAddGroups()) != null) {
                    this.autoAddGroups(autoAddGroupsValue);
                }
                if ((ldapProfileFileValue = ((_LdapConfiguration)instance).getLdapProfileFile()) != null) {
                    this.ldapProfileFile(ldapProfileFileValue);
                }
                if ((userSearchBaseValue = ((_LdapConfiguration)instance).getUserSearchBase()) != null) {
                    this.userSearchBase(userSearchBaseValue);
                }
                if ((groupRoleAttributeValue = ((_LdapConfiguration)instance).getGroupRoleAttribute()) != null) {
                    this.groupRoleAttribute(groupRoleAttributeValue);
                }
                if ((userSearchFilterValue = ((_LdapConfiguration)instance).getUserSearchFilter()) != null) {
                    this.userSearchFilter(userSearchFilterValue);
                }
                if ((groupSearchFilterValue = ((_LdapConfiguration)instance).getGroupSearchFilter()) != null) {
                    this.groupSearchFilter(groupSearchFilterValue);
                }
                if ((groupSearchDepthLimitValue = ((_LdapConfiguration)instance).getGroupSearchDepthLimit()) != null) {
                    this.groupSearchDepthLimit(groupSearchDepthLimitValue);
                }
                if ((mailSubstituteValue = ((_LdapConfiguration)instance).getMailSubstitute()) != null) {
                    this.mailSubstitute(mailSubstituteValue);
                }
                if ((bindUserDistinguishedNameValue = ((_LdapConfiguration)instance).getBindUserDistinguishedName()) != null) {
                    this.bindUserDistinguishedName(bindUserDistinguishedNameValue);
                }
                if ((tlsConfigurationValue = ((_LdapConfiguration)instance).getTlsConfiguration()) != null) {
                    this.tlsConfiguration(tlsConfigurationValue);
                }
                if ((groupsIgnorePartialResultsValue = ((_LdapConfiguration)instance).getGroupsIgnorePartialResults()) != null) {
                    this.groupsIgnorePartialResults(groupsIgnorePartialResultsValue);
                }
                if ((userDistinguishedNamePatternValue = ((_LdapConfiguration)instance).getUserDistinguishedNamePattern()) != null) {
                    this.userDistinguishedNamePattern(userDistinguishedNamePatternValue);
                }
                if ((groupSearchSubTreeValue = ((_LdapConfiguration)instance).getGroupSearchSubTree()) != null) {
                    this.groupSearchSubTree(groupSearchSubTreeValue);
                }
                if ((addShadowUserOnLoginValue = ((_LdapConfiguration)instance).getAddShadowUserOnLogin()) != null) {
                    this.addShadowUserOnLogin(addShadowUserOnLoginValue);
                }
                if ((localPasswordCompareValue = ((_LdapConfiguration)instance).getLocalPasswordCompare()) != null) {
                    this.localPasswordCompare(localPasswordCompareValue);
                }
                if ((userDistinguishedNamePatternDelimiterValue = ((_LdapConfiguration)instance).getUserDistinguishedNamePatternDelimiter()) != null) {
                    this.userDistinguishedNamePatternDelimiter(userDistinguishedNamePatternDelimiterValue);
                }
                if ((passwordEncoderValue = ((_LdapConfiguration)instance).getPasswordEncoder()) != null) {
                    this.passwordEncoder(passwordEncoderValue);
                }
                if ((baseUrlValue = ((_LdapConfiguration)instance).getBaseUrl()) != null) {
                    this.baseUrl(baseUrlValue);
                }
                if ((groupSearchBaseValue = ((_LdapConfiguration)instance).getGroupSearchBase()) != null) {
                    this.groupSearchBase(groupSearchBaseValue);
                }
                if ((referralValue = ((_LdapConfiguration)instance).getReferral()) != null) {
                    this.referral(referralValue);
                }
                if ((mailAttributeNameValue = ((_LdapConfiguration)instance).getMailAttributeName()) != null) {
                    this.mailAttributeName(mailAttributeNameValue);
                }
                if ((passwordAttributeNameValue = ((_LdapConfiguration)instance).getPasswordAttributeName()) != null) {
                    this.passwordAttributeName(passwordAttributeNameValue);
                }
            }
        }

        @JsonProperty(value="addShadowUserOnLogin")
        public final Builder addShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
            this.addShadowUserOnLogin = addShadowUserOnLogin;
            return this;
        }

        @JsonProperty(value="autoAddGroups")
        public final Builder autoAddGroups(@Nullable Boolean autoAddGroups) {
            this.autoAddGroups = autoAddGroups;
            return this;
        }

        @JsonProperty(value="baseUrl")
        public final Builder baseUrl(@Nullable String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @JsonProperty(value="bindPassword")
        public final Builder bindPassword(@Nullable String bindPassword) {
            this.bindPassword = bindPassword;
            return this;
        }

        @JsonProperty(value="bindUserDn")
        public final Builder bindUserDistinguishedName(@Nullable String bindUserDistinguishedName) {
            this.bindUserDistinguishedName = bindUserDistinguishedName;
            return this;
        }

        @JsonProperty(value="groupRoleAttribute")
        public final Builder groupRoleAttribute(@Nullable String groupRoleAttribute) {
            this.groupRoleAttribute = groupRoleAttribute;
            return this;
        }

        @JsonProperty(value="groupSearchBase")
        public final Builder groupSearchBase(@Nullable String groupSearchBase) {
            this.groupSearchBase = groupSearchBase;
            return this;
        }

        @JsonProperty(value="maxGroupSearchDepth")
        public final Builder groupSearchDepthLimit(@Nullable Integer groupSearchDepthLimit) {
            this.groupSearchDepthLimit = groupSearchDepthLimit;
            return this;
        }

        @JsonProperty(value="groupSearchFilter")
        public final Builder groupSearchFilter(@Nullable String groupSearchFilter) {
            this.groupSearchFilter = groupSearchFilter;
            return this;
        }

        @JsonProperty(value="groupSearchSubTree")
        public final Builder groupSearchSubTree(@Nullable Boolean groupSearchSubTree) {
            this.groupSearchSubTree = groupSearchSubTree;
            return this;
        }

        @JsonProperty(value="groupsIgnorePartialResults")
        public final Builder groupsIgnorePartialResults(@Nullable Boolean groupsIgnorePartialResults) {
            this.groupsIgnorePartialResults = groupsIgnorePartialResults;
            return this;
        }

        @JsonProperty(value="ldapGroupFile")
        public final Builder ldapGroupFile(@Nullable LdapGroupFile ldapGroupFile) {
            this.ldapGroupFile = ldapGroupFile;
            return this;
        }

        @JsonProperty(value="ldapProfileFile")
        public final Builder ldapProfileFile(@Nullable LdapProfileFile ldapProfileFile) {
            this.ldapProfileFile = ldapProfileFile;
            return this;
        }

        @JsonProperty(value="localPasswordCompare")
        public final Builder localPasswordCompare(@Nullable Boolean localPasswordCompare) {
            this.localPasswordCompare = localPasswordCompare;
            return this;
        }

        @JsonProperty(value="mailAttributeName")
        public final Builder mailAttributeName(@Nullable String mailAttributeName) {
            this.mailAttributeName = mailAttributeName;
            return this;
        }

        @JsonProperty(value="mailSubstitute")
        public final Builder mailSubstitute(@Nullable String mailSubstitute) {
            this.mailSubstitute = mailSubstitute;
            return this;
        }

        @JsonProperty(value="mailSubstituteOverridesLdap")
        public final Builder mailSubstituteOverridesLdap(@Nullable Boolean mailSubstituteOverridesLdap) {
            this.mailSubstituteOverridesLdap = mailSubstituteOverridesLdap;
            return this;
        }

        @JsonProperty(value="passwordAttributeName")
        public final Builder passwordAttributeName(@Nullable String passwordAttributeName) {
            this.passwordAttributeName = passwordAttributeName;
            return this;
        }

        @JsonProperty(value="passwordEncoder")
        public final Builder passwordEncoder(@Nullable String passwordEncoder) {
            this.passwordEncoder = passwordEncoder;
            return this;
        }

        @JsonProperty(value="referral")
        public final Builder referral(@Nullable String referral) {
            this.referral = referral;
            return this;
        }

        @JsonProperty(value="skipSSLVerification")
        public final Builder skipSSLVerification(@Nullable Boolean skipSSLVerification) {
            this.skipSSLVerification = skipSSLVerification;
            return this;
        }

        @JsonProperty(value="tlsConfiguration")
        public final Builder tlsConfiguration(@Nullable TlsConfiguration tlsConfiguration) {
            this.tlsConfiguration = tlsConfiguration;
            return this;
        }

        @JsonProperty(value="userDNPattern")
        public final Builder userDistinguishedNamePattern(@Nullable String userDistinguishedNamePattern) {
            this.userDistinguishedNamePattern = userDistinguishedNamePattern;
            return this;
        }

        @JsonProperty(value="userDNPatternDelimiter")
        public final Builder userDistinguishedNamePatternDelimiter(@Nullable String userDistinguishedNamePatternDelimiter) {
            this.userDistinguishedNamePatternDelimiter = userDistinguishedNamePatternDelimiter;
            return this;
        }

        @JsonProperty(value="userSearchBase")
        public final Builder userSearchBase(@Nullable String userSearchBase) {
            this.userSearchBase = userSearchBase;
            return this;
        }

        @JsonProperty(value="userSearchFilter")
        public final Builder userSearchFilter(@Nullable String userSearchFilter) {
            this.userSearchFilter = userSearchFilter;
            return this;
        }

        @JsonProperty(value="attributeMappings")
        public final Builder attributeMappings(@Nullable AttributeMappings attributeMappings) {
            this.attributeMappings = attributeMappings;
            return this;
        }

        public final Builder externalGroupsWhitelist(String element) {
            if (this.externalGroupsWhitelist == null) {
                this.externalGroupsWhitelist = new ArrayList<String>();
            }
            this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
            return this;
        }

        public final Builder externalGroupsWhitelist(String ... elements) {
            if (this.externalGroupsWhitelist == null) {
                this.externalGroupsWhitelist = new ArrayList<String>();
            }
            for (String element : elements) {
                this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
            }
            return this;
        }

        @JsonProperty(value="externalGroupsWhitelist")
        public final Builder externalGroupsWhitelist(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.externalGroupsWhitelist = null;
                return this;
            }
            this.externalGroupsWhitelist = new ArrayList<String>();
            return this.addAllExternalGroupsWhitelist(elements);
        }

        public final Builder addAllExternalGroupsWhitelist(Iterable<String> elements) {
            Objects.requireNonNull(elements, "externalGroupsWhitelist element");
            if (this.externalGroupsWhitelist == null) {
                this.externalGroupsWhitelist = new ArrayList<String>();
            }
            for (String element : elements) {
                this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
            }
            return this;
        }

        @JsonProperty(value="storeCustomAttributes")
        public final Builder storeCustomAttributes(@Nullable Boolean storeCustomAttributes) {
            this.storeCustomAttributes = storeCustomAttributes;
            return this;
        }

        public final Builder emailDomain(String element) {
            if (this.emailDomains == null) {
                this.emailDomains = new ArrayList<String>();
            }
            this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
            return this;
        }

        public final Builder emailDomains(String ... elements) {
            if (this.emailDomains == null) {
                this.emailDomains = new ArrayList<String>();
            }
            for (String element : elements) {
                this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
            }
            return this;
        }

        @JsonProperty(value="emailDomain")
        public final Builder emailDomains(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.emailDomains = null;
                return this;
            }
            this.emailDomains = new ArrayList<String>();
            return this.addAllEmailDomains(elements);
        }

        public final Builder addAllEmailDomains(Iterable<String> elements) {
            Objects.requireNonNull(elements, "emailDomains element");
            if (this.emailDomains == null) {
                this.emailDomains = new ArrayList<String>();
            }
            for (String element : elements) {
                this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
            }
            return this;
        }

        @JsonProperty(value="providerDescription")
        public final Builder providerDescription(@Nullable String providerDescription) {
            this.providerDescription = providerDescription;
            return this;
        }

        public LdapConfiguration build() {
            return new LdapConfiguration(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_LdapConfiguration", generator="Immutables")
    static final class Json
    extends _LdapConfiguration {
        Boolean addShadowUserOnLogin;
        Boolean autoAddGroups;
        String baseUrl;
        String bindPassword;
        String bindUserDistinguishedName;
        String groupRoleAttribute;
        String groupSearchBase;
        Integer groupSearchDepthLimit;
        String groupSearchFilter;
        Boolean groupSearchSubTree;
        Boolean groupsIgnorePartialResults;
        LdapGroupFile ldapGroupFile;
        LdapProfileFile ldapProfileFile;
        Boolean localPasswordCompare;
        String mailAttributeName;
        String mailSubstitute;
        Boolean mailSubstituteOverridesLdap;
        String passwordAttributeName;
        String passwordEncoder;
        String referral;
        Boolean skipSSLVerification;
        TlsConfiguration tlsConfiguration;
        String userDistinguishedNamePattern;
        String userDistinguishedNamePatternDelimiter;
        String userSearchBase;
        String userSearchFilter;
        AttributeMappings attributeMappings;
        List<String> externalGroupsWhitelist = null;
        Boolean storeCustomAttributes;
        List<String> emailDomains = null;
        String providerDescription;

        Json() {
        }

        @JsonProperty(value="addShadowUserOnLogin")
        public void setAddShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
            this.addShadowUserOnLogin = addShadowUserOnLogin;
        }

        @JsonProperty(value="autoAddGroups")
        public void setAutoAddGroups(@Nullable Boolean autoAddGroups) {
            this.autoAddGroups = autoAddGroups;
        }

        @JsonProperty(value="baseUrl")
        public void setBaseUrl(@Nullable String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @JsonProperty(value="bindPassword")
        public void setBindPassword(@Nullable String bindPassword) {
            this.bindPassword = bindPassword;
        }

        @JsonProperty(value="bindUserDn")
        public void setBindUserDistinguishedName(@Nullable String bindUserDistinguishedName) {
            this.bindUserDistinguishedName = bindUserDistinguishedName;
        }

        @JsonProperty(value="groupRoleAttribute")
        public void setGroupRoleAttribute(@Nullable String groupRoleAttribute) {
            this.groupRoleAttribute = groupRoleAttribute;
        }

        @JsonProperty(value="groupSearchBase")
        public void setGroupSearchBase(@Nullable String groupSearchBase) {
            this.groupSearchBase = groupSearchBase;
        }

        @JsonProperty(value="maxGroupSearchDepth")
        public void setGroupSearchDepthLimit(@Nullable Integer groupSearchDepthLimit) {
            this.groupSearchDepthLimit = groupSearchDepthLimit;
        }

        @JsonProperty(value="groupSearchFilter")
        public void setGroupSearchFilter(@Nullable String groupSearchFilter) {
            this.groupSearchFilter = groupSearchFilter;
        }

        @JsonProperty(value="groupSearchSubTree")
        public void setGroupSearchSubTree(@Nullable Boolean groupSearchSubTree) {
            this.groupSearchSubTree = groupSearchSubTree;
        }

        @JsonProperty(value="groupsIgnorePartialResults")
        public void setGroupsIgnorePartialResults(@Nullable Boolean groupsIgnorePartialResults) {
            this.groupsIgnorePartialResults = groupsIgnorePartialResults;
        }

        @JsonProperty(value="ldapGroupFile")
        public void setLdapGroupFile(@Nullable LdapGroupFile ldapGroupFile) {
            this.ldapGroupFile = ldapGroupFile;
        }

        @JsonProperty(value="ldapProfileFile")
        public void setLdapProfileFile(@Nullable LdapProfileFile ldapProfileFile) {
            this.ldapProfileFile = ldapProfileFile;
        }

        @JsonProperty(value="localPasswordCompare")
        public void setLocalPasswordCompare(@Nullable Boolean localPasswordCompare) {
            this.localPasswordCompare = localPasswordCompare;
        }

        @JsonProperty(value="mailAttributeName")
        public void setMailAttributeName(@Nullable String mailAttributeName) {
            this.mailAttributeName = mailAttributeName;
        }

        @JsonProperty(value="mailSubstitute")
        public void setMailSubstitute(@Nullable String mailSubstitute) {
            this.mailSubstitute = mailSubstitute;
        }

        @JsonProperty(value="mailSubstituteOverridesLdap")
        public void setMailSubstituteOverridesLdap(@Nullable Boolean mailSubstituteOverridesLdap) {
            this.mailSubstituteOverridesLdap = mailSubstituteOverridesLdap;
        }

        @JsonProperty(value="passwordAttributeName")
        public void setPasswordAttributeName(@Nullable String passwordAttributeName) {
            this.passwordAttributeName = passwordAttributeName;
        }

        @JsonProperty(value="passwordEncoder")
        public void setPasswordEncoder(@Nullable String passwordEncoder) {
            this.passwordEncoder = passwordEncoder;
        }

        @JsonProperty(value="referral")
        public void setReferral(@Nullable String referral) {
            this.referral = referral;
        }

        @JsonProperty(value="skipSSLVerification")
        public void setSkipSSLVerification(@Nullable Boolean skipSSLVerification) {
            this.skipSSLVerification = skipSSLVerification;
        }

        @JsonProperty(value="tlsConfiguration")
        public void setTlsConfiguration(@Nullable TlsConfiguration tlsConfiguration) {
            this.tlsConfiguration = tlsConfiguration;
        }

        @JsonProperty(value="userDNPattern")
        public void setUserDistinguishedNamePattern(@Nullable String userDistinguishedNamePattern) {
            this.userDistinguishedNamePattern = userDistinguishedNamePattern;
        }

        @JsonProperty(value="userDNPatternDelimiter")
        public void setUserDistinguishedNamePatternDelimiter(@Nullable String userDistinguishedNamePatternDelimiter) {
            this.userDistinguishedNamePatternDelimiter = userDistinguishedNamePatternDelimiter;
        }

        @JsonProperty(value="userSearchBase")
        public void setUserSearchBase(@Nullable String userSearchBase) {
            this.userSearchBase = userSearchBase;
        }

        @JsonProperty(value="userSearchFilter")
        public void setUserSearchFilter(@Nullable String userSearchFilter) {
            this.userSearchFilter = userSearchFilter;
        }

        @JsonProperty(value="attributeMappings")
        public void setAttributeMappings(@Nullable AttributeMappings attributeMappings) {
            this.attributeMappings = attributeMappings;
        }

        @JsonProperty(value="externalGroupsWhitelist")
        public void setExternalGroupsWhitelist(@Nullable List<String> externalGroupsWhitelist) {
            this.externalGroupsWhitelist = externalGroupsWhitelist;
        }

        @JsonProperty(value="storeCustomAttributes")
        public void setStoreCustomAttributes(@Nullable Boolean storeCustomAttributes) {
            this.storeCustomAttributes = storeCustomAttributes;
        }

        @JsonProperty(value="emailDomain")
        public void setEmailDomains(@Nullable List<String> emailDomains) {
            this.emailDomains = emailDomains;
        }

        @JsonProperty(value="providerDescription")
        public void setProviderDescription(@Nullable String providerDescription) {
            this.providerDescription = providerDescription;
        }

        @Override
        public Boolean getAddShadowUserOnLogin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getAutoAddGroups() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBaseUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBindPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBindUserDistinguishedName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGroupRoleAttribute() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGroupSearchBase() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getGroupSearchDepthLimit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGroupSearchFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getGroupSearchSubTree() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getGroupsIgnorePartialResults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LdapGroupFile getLdapGroupFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LdapProfileFile getLdapProfileFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getLocalPasswordCompare() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMailAttributeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMailSubstitute() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getMailSubstituteOverridesLdap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPasswordAttributeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPasswordEncoder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getReferral() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getSkipSSLVerification() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TlsConfiguration getTlsConfiguration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserDistinguishedNamePattern() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserDistinguishedNamePatternDelimiter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserSearchBase() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserSearchFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AttributeMappings getAttributeMappings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getExternalGroupsWhitelist() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getStoreCustomAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getEmailDomains() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProviderDescription() {
            throw new UnsupportedOperationException();
        }
    }
}

