/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.organizations._ListOrganizationServicesRequest;

public final class ListOrganizationServicesRequest
extends _ListOrganizationServicesRequest {
    @Nullable
    private final Boolean active;
    @Nullable
    private final List<String> labels;
    private final String organizationId;
    @Nullable
    private final List<String> providers;
    @Nullable
    private final List<String> serviceBrokerIds;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListOrganizationServicesRequest(Builder builder) {
        this.active = builder.active;
        this.labels = builder.labels == null ? null : ListOrganizationServicesRequest.createUnmodifiableList(true, builder.labels);
        this.organizationId = builder.organizationId;
        this.providers = builder.providers == null ? null : ListOrganizationServicesRequest.createUnmodifiableList(true, builder.providers);
        this.serviceBrokerIds = builder.serviceBrokerIds == null ? null : ListOrganizationServicesRequest.createUnmodifiableList(true, builder.serviceBrokerIds);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @Override
    @Nullable
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @Deprecated
    @Nullable
    public List<String> getProviders() {
        return this.providers;
    }

    @Override
    @Nullable
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListOrganizationServicesRequest && this.equalTo((ListOrganizationServicesRequest)another);
    }

    private boolean equalTo(ListOrganizationServicesRequest another) {
        return Objects.equals(this.active, another.active) && Objects.equals(this.labels, another.labels) && this.organizationId.equals(another.organizationId) && Objects.equals(this.providers, another.providers) && Objects.equals(this.serviceBrokerIds, another.serviceBrokerIds) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.active);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + this.organizationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.providers);
        h += (h << 5) + Objects.hashCode(this.serviceBrokerIds);
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListOrganizationServicesRequest{active=" + this.active + ", labels=" + this.labels + ", organizationId=" + this.organizationId + ", providers=" + this.providers + ", serviceBrokerIds=" + this.serviceBrokerIds + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private long initBits = 1L;
        private Boolean active;
        private List<String> labels = null;
        private String organizationId;
        private List<String> providers = null;
        private List<String> serviceBrokerIds = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListOrganizationServicesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListOrganizationServicesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListOrganizationServicesRequest) {
                List<String> labelsValue;
                List<String> providersValue;
                List<String> serviceBrokerIdsValue;
                instance = (_ListOrganizationServicesRequest)object;
                this.organizationId(((_ListOrganizationServicesRequest)instance).getOrganizationId());
                Boolean activeValue = ((_ListOrganizationServicesRequest)instance).getActive();
                if (activeValue != null) {
                    this.active(activeValue);
                }
                if ((serviceBrokerIdsValue = ((_ListOrganizationServicesRequest)instance).getServiceBrokerIds()) != null) {
                    this.addAllServiceBrokerIds(serviceBrokerIdsValue);
                }
                if ((providersValue = ((_ListOrganizationServicesRequest)instance).getProviders()) != null) {
                    this.addAllProviders(providersValue);
                }
                if ((labelsValue = ((_ListOrganizationServicesRequest)instance).getLabels()) != null) {
                    this.addAllLabels(labelsValue);
                }
            }
        }

        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        public final Builder label(String element) {
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            this.labels.add(Objects.requireNonNull(element, "labels element"));
            return this;
        }

        public final Builder label(String ... elements) {
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.labels.add(Objects.requireNonNull(element, "labels element"));
            }
            return this;
        }

        public final Builder labels(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.labels = null;
                return this;
            }
            this.labels = new ArrayList<String>();
            return this.addAllLabels(elements);
        }

        public final Builder addAllLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "labels element");
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.labels.add(Objects.requireNonNull(element, "labels element"));
            }
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        public final Builder provider(String element) {
            if (this.providers == null) {
                this.providers = new ArrayList<String>();
            }
            this.providers.add(Objects.requireNonNull(element, "providers element"));
            return this;
        }

        @Deprecated
        public final Builder provider(String ... elements) {
            if (this.providers == null) {
                this.providers = new ArrayList<String>();
            }
            for (String element : elements) {
                this.providers.add(Objects.requireNonNull(element, "providers element"));
            }
            return this;
        }

        @Deprecated
        public final Builder providers(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.providers = null;
                return this;
            }
            this.providers = new ArrayList<String>();
            return this.addAllProviders(elements);
        }

        @Deprecated
        public final Builder addAllProviders(Iterable<String> elements) {
            Objects.requireNonNull(elements, "providers element");
            if (this.providers == null) {
                this.providers = new ArrayList<String>();
            }
            for (String element : elements) {
                this.providers.add(Objects.requireNonNull(element, "providers element"));
            }
            return this;
        }

        public final Builder serviceBrokerId(String element) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList<String>();
            }
            this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
            return this;
        }

        public final Builder serviceBrokerId(String ... elements) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
            }
            return this;
        }

        public final Builder serviceBrokerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceBrokerIds = null;
                return this;
            }
            this.serviceBrokerIds = new ArrayList<String>();
            return this.addAllServiceBrokerIds(elements);
        }

        public final Builder addAllServiceBrokerIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceBrokerIds element");
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationServicesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListOrganizationServicesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build ListOrganizationServicesRequest, some of required attributes are not set " + attributes;
        }
    }
}

