/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v2.serviceplans._Schema;

public final class Schema
extends _Schema {
    private final Map<String, String> parameters;

    private Schema(Builder builder) {
        this.parameters = Schema.createUnmodifiableMap(false, false, builder.parameters);
    }

    @Override
    @JsonProperty(value="parameters")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Schema && this.equalTo((Schema)another);
    }

    private boolean equalTo(Schema another) {
        return this.parameters.equals(another.parameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.parameters.hashCode();
        return h;
    }

    public String toString() {
        return "Schema{parameters=" + this.parameters + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Schema fromJson(Json json) {
        Builder builder = Schema.builder();
        if (json.parameters != null) {
            builder.putAllParameters(json.parameters);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Map<String, String> parameters = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(Schema instance) {
            return this.from((_Schema)instance);
        }

        final Builder from(_Schema instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllParameters(instance.getParameters());
            return this;
        }

        public final Builder parameter(String key, String value) {
            this.parameters.put(Objects.requireNonNull(key, "parameters key"), Objects.requireNonNull(value, "parameters value"));
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            return this;
        }

        @JsonProperty(value="parameters")
        public final Builder parameters(Map<String, ? extends String> parameters) {
            this.parameters.clear();
            return this.putAllParameters(parameters);
        }

        public final Builder putAllParameters(Map<String, ? extends String> parameters) {
            for (Map.Entry<String, ? extends String> entry : parameters.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            }
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Schema {
        Map<String, String> parameters = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="parameters")
        public void setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        @Override
        public Map<String, String> getParameters() {
            throw new UnsupportedOperationException();
        }
    }
}

