/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.networking.v1.policies;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.networking.v1.policies.Policy;
import org.cloudfoundry.networking.v1.policies._ListPoliciesResponse;

public final class ListPoliciesResponse
extends _ListPoliciesResponse {
    private final List<Policy> policies;
    private final Integer totalPolicies;

    private ListPoliciesResponse(Builder builder) {
        this.policies = ListPoliciesResponse.createUnmodifiableList(true, builder.policies);
        this.totalPolicies = builder.totalPolicies;
    }

    @Override
    @JsonProperty(value="policies")
    public List<Policy> getPolicies() {
        return this.policies;
    }

    @Override
    @JsonProperty(value="total_policies")
    public Integer getTotalPolicies() {
        return this.totalPolicies;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListPoliciesResponse && this.equalTo((ListPoliciesResponse)another);
    }

    private boolean equalTo(ListPoliciesResponse another) {
        return this.policies.equals(another.policies) && this.totalPolicies.equals(another.totalPolicies);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.policies.hashCode();
        h += (h << 5) + this.totalPolicies.hashCode();
        return h;
    }

    public String toString() {
        return "ListPoliciesResponse{policies=" + this.policies + ", totalPolicies=" + this.totalPolicies + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListPoliciesResponse fromJson(Json json) {
        Builder builder = ListPoliciesResponse.builder();
        if (json.policies != null) {
            builder.addAllPolicies(json.policies);
        }
        if (json.totalPolicies != null) {
            builder.totalPolicies(json.totalPolicies);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TOTAL_POLICIES = 1L;
        private long initBits = 1L;
        private List<Policy> policies = new ArrayList<Policy>();
        private Integer totalPolicies;

        private Builder() {
        }

        public final Builder from(ListPoliciesResponse instance) {
            return this.from((_ListPoliciesResponse)instance);
        }

        final Builder from(_ListPoliciesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPolicies(instance.getPolicies());
            this.totalPolicies(instance.getTotalPolicies());
            return this;
        }

        public final Builder policy(Policy element) {
            this.policies.add(Objects.requireNonNull(element, "policies element"));
            return this;
        }

        public final Builder policy(Policy ... elements) {
            for (Policy element : elements) {
                this.policies.add(Objects.requireNonNull(element, "policies element"));
            }
            return this;
        }

        @JsonProperty(value="policies")
        public final Builder policies(Iterable<? extends Policy> elements) {
            this.policies.clear();
            return this.addAllPolicies(elements);
        }

        public final Builder addAllPolicies(Iterable<? extends Policy> elements) {
            for (Policy policy : elements) {
                this.policies.add(Objects.requireNonNull(policy, "policies element"));
            }
            return this;
        }

        @JsonProperty(value="total_policies")
        public final Builder totalPolicies(Integer totalPolicies) {
            this.totalPolicies = Objects.requireNonNull(totalPolicies, "totalPolicies");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ListPoliciesResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListPoliciesResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalPolicies");
            }
            return "Cannot build ListPoliciesResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ListPoliciesResponse {
        List<Policy> policies = Collections.emptyList();
        Integer totalPolicies;

        Json() {
        }

        @JsonProperty(value="policies")
        public void setPolicies(List<Policy> policies) {
            this.policies = policies;
        }

        @JsonProperty(value="total_policies")
        public void setTotalPolicies(Integer totalPolicies) {
            this.totalPolicies = totalPolicies;
        }

        @Override
        public List<Policy> getPolicies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getTotalPolicies() {
            throw new UnsupportedOperationException();
        }
    }
}

