/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupIdRequest;

public final class UnmapExternalGroupByGroupIdRequest
extends _UnmapExternalGroupByGroupIdRequest {
    private final String externalGroup;
    private final String groupId;
    private final String origin;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private UnmapExternalGroupByGroupIdRequest(Builder builder) {
        this.externalGroup = builder.externalGroup;
        this.groupId = builder.groupId;
        this.origin = builder.origin;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    public String getExternalGroup() {
        return this.externalGroup;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnmapExternalGroupByGroupIdRequest && this.equalTo((UnmapExternalGroupByGroupIdRequest)another);
    }

    private boolean equalTo(UnmapExternalGroupByGroupIdRequest another) {
        return this.externalGroup.equals(another.externalGroup) && this.groupId.equals(another.groupId) && this.origin.equals(another.origin) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.externalGroup.hashCode();
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.origin.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "UnmapExternalGroupByGroupIdRequest{externalGroup=" + this.externalGroup + ", groupId=" + this.groupId + ", origin=" + this.origin + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXTERNAL_GROUP = 1L;
        private static final long INIT_BIT_GROUP_ID = 2L;
        private static final long INIT_BIT_ORIGIN = 4L;
        private long initBits = 7L;
        private String externalGroup;
        private String groupId;
        private String origin;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UnmapExternalGroupByGroupIdRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_UnmapExternalGroupByGroupIdRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _UnmapExternalGroupByGroupIdRequest) {
                instance = (_UnmapExternalGroupByGroupIdRequest)object;
                this.externalGroup(((_UnmapExternalGroupByGroupIdRequest)instance).getExternalGroup());
                this.groupId(((_UnmapExternalGroupByGroupIdRequest)instance).getGroupId());
                this.origin(((_UnmapExternalGroupByGroupIdRequest)instance).getOrigin());
            }
        }

        public final Builder externalGroup(String externalGroup) {
            this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public UnmapExternalGroupByGroupIdRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UnmapExternalGroupByGroupIdRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("externalGroup");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("origin");
            }
            return "Cannot build UnmapExternalGroupByGroupIdRequest, some of required attributes are not set " + attributes;
        }
    }
}

