/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.tokens._CheckTokenRequest;

public final class CheckTokenRequest
extends _CheckTokenRequest {
    private final String clientId;
    private final String clientSecret;
    @Nullable
    private final List<String> scopes;
    private final String token;

    private CheckTokenRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.scopes = builder.scopes == null ? null : CheckTokenRequest.createUnmodifiableList(true, builder.scopes);
        this.token = builder.token;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CheckTokenRequest && this.equalTo((CheckTokenRequest)another);
    }

    private boolean equalTo(CheckTokenRequest another) {
        return this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret) && Objects.equals(this.scopes, another.scopes) && this.token.equals(another.token);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.clientSecret.hashCode();
        h += (h << 5) + Objects.hashCode(this.scopes);
        h += (h << 5) + this.token.hashCode();
        return h;
    }

    public String toString() {
        return "CheckTokenRequest{clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scopes=" + this.scopes + ", token=" + this.token + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_CLIENT_SECRET = 2L;
        private static final long INIT_BIT_TOKEN = 4L;
        private long initBits = 7L;
        private String clientId;
        private String clientSecret;
        private List<String> scopes = null;
        private String token;

        private Builder() {
        }

        public final Builder from(CheckTokenRequest instance) {
            return this.from((_CheckTokenRequest)instance);
        }

        final Builder from(_CheckTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.getClientId());
            this.clientSecret(instance.getClientSecret());
            List<String> scopesValue = instance.getScopes();
            if (scopesValue != null) {
                this.addAllScopes(scopesValue);
            }
            this.token(instance.getToken());
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder scope(String element) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder scope(String ... elements) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder scopes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.scopes = null;
                return this;
            }
            this.scopes = new ArrayList<String>();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "scopes element");
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public CheckTokenRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CheckTokenRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientSecret");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build CheckTokenRequest, some of required attributes are not set " + attributes;
        }
    }
}

