/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.tokens._CheckTokenResponse;

public final class CheckTokenResponse
extends _CheckTokenResponse {
    private final List<String> audiences;
    private final List<String> authorities;
    private final Long authorizationTime;
    private final String authorizedParty;
    private final String cid;
    private final String clientId;
    private final String email;
    private final Long expirationTime;
    private final String grantType;
    private final Long issuedAt;
    private final String issuer;
    private final String jwtId;
    private final String origin;
    private final Boolean revocable;
    private final String revocationSignature;
    private final List<String> scopes;
    private final String subject;
    private final String userId;
    private final String userName;
    private final String zoneId;

    private CheckTokenResponse(Builder builder) {
        this.audiences = CheckTokenResponse.createUnmodifiableList(true, builder.audiences);
        this.authorities = CheckTokenResponse.createUnmodifiableList(true, builder.authorities);
        this.authorizationTime = builder.authorizationTime;
        this.authorizedParty = builder.authorizedParty;
        this.cid = builder.cid;
        this.clientId = builder.clientId;
        this.email = builder.email;
        this.expirationTime = builder.expirationTime;
        this.grantType = builder.grantType;
        this.issuedAt = builder.issuedAt;
        this.issuer = builder.issuer;
        this.jwtId = builder.jwtId;
        this.origin = builder.origin;
        this.revocable = builder.revocable;
        this.revocationSignature = builder.revocationSignature;
        this.scopes = CheckTokenResponse.createUnmodifiableList(true, builder.scopes);
        this.subject = builder.subject;
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.zoneId = builder.zoneId;
    }

    @Override
    @JsonProperty(value="aud")
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    @JsonProperty(value="authorities")
    public List<String> getAuthorities() {
        return this.authorities;
    }

    @Override
    @JsonProperty(value="auth_time")
    public Long getAuthorizationTime() {
        return this.authorizationTime;
    }

    @Override
    @JsonProperty(value="azp")
    public String getAuthorizedParty() {
        return this.authorizedParty;
    }

    @Override
    @JsonProperty(value="cid")
    public String getCid() {
        return this.cid;
    }

    @Override
    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @Override
    @JsonProperty(value="exp")
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    @JsonProperty(value="grant_type")
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="iat")
    public Long getIssuedAt() {
        return this.issuedAt;
    }

    @Override
    @JsonProperty(value="iss")
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    @JsonProperty(value="jti")
    public String getJwtId() {
        return this.jwtId;
    }

    @Override
    @JsonProperty(value="origin")
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @JsonProperty(value="revocable")
    public Boolean getRevocable() {
        return this.revocable;
    }

    @Override
    @JsonProperty(value="rev_sig")
    public String getRevocationSignature() {
        return this.revocationSignature;
    }

    @Override
    @JsonProperty(value="scope")
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    @JsonProperty(value="sub")
    public String getSubject() {
        return this.subject;
    }

    @Override
    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="user_name")
    public String getUserName() {
        return this.userName;
    }

    @Override
    @JsonProperty(value="zid")
    public String getZoneId() {
        return this.zoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CheckTokenResponse && this.equalTo((CheckTokenResponse)another);
    }

    private boolean equalTo(CheckTokenResponse another) {
        return this.audiences.equals(another.audiences) && this.authorities.equals(another.authorities) && this.authorizationTime.equals(another.authorizationTime) && this.authorizedParty.equals(another.authorizedParty) && this.cid.equals(another.cid) && this.clientId.equals(another.clientId) && this.email.equals(another.email) && this.expirationTime.equals(another.expirationTime) && this.grantType.equals(another.grantType) && this.issuedAt.equals(another.issuedAt) && this.issuer.equals(another.issuer) && this.jwtId.equals(another.jwtId) && this.origin.equals(another.origin) && this.revocable.equals(another.revocable) && this.revocationSignature.equals(another.revocationSignature) && this.scopes.equals(another.scopes) && this.subject.equals(another.subject) && this.userId.equals(another.userId) && this.userName.equals(another.userName) && this.zoneId.equals(another.zoneId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.audiences.hashCode();
        h += (h << 5) + this.authorities.hashCode();
        h += (h << 5) + this.authorizationTime.hashCode();
        h += (h << 5) + this.authorizedParty.hashCode();
        h += (h << 5) + this.cid.hashCode();
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.email.hashCode();
        h += (h << 5) + this.expirationTime.hashCode();
        h += (h << 5) + this.grantType.hashCode();
        h += (h << 5) + this.issuedAt.hashCode();
        h += (h << 5) + this.issuer.hashCode();
        h += (h << 5) + this.jwtId.hashCode();
        h += (h << 5) + this.origin.hashCode();
        h += (h << 5) + this.revocable.hashCode();
        h += (h << 5) + this.revocationSignature.hashCode();
        h += (h << 5) + this.scopes.hashCode();
        h += (h << 5) + this.subject.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.userName.hashCode();
        h += (h << 5) + this.zoneId.hashCode();
        return h;
    }

    public String toString() {
        return "CheckTokenResponse{audiences=" + this.audiences + ", authorities=" + this.authorities + ", authorizationTime=" + this.authorizationTime + ", authorizedParty=" + this.authorizedParty + ", cid=" + this.cid + ", clientId=" + this.clientId + ", email=" + this.email + ", expirationTime=" + this.expirationTime + ", grantType=" + this.grantType + ", issuedAt=" + this.issuedAt + ", issuer=" + this.issuer + ", jwtId=" + this.jwtId + ", origin=" + this.origin + ", revocable=" + this.revocable + ", revocationSignature=" + this.revocationSignature + ", scopes=" + this.scopes + ", subject=" + this.subject + ", userId=" + this.userId + ", userName=" + this.userName + ", zoneId=" + this.zoneId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CheckTokenResponse fromJson(Json json) {
        Builder builder = CheckTokenResponse.builder();
        if (json.audiences != null) {
            builder.addAllAudiences(json.audiences);
        }
        if (json.authorities != null) {
            builder.addAllAuthorities(json.authorities);
        }
        if (json.authorizationTime != null) {
            builder.authorizationTime(json.authorizationTime);
        }
        if (json.authorizedParty != null) {
            builder.authorizedParty(json.authorizedParty);
        }
        if (json.cid != null) {
            builder.cid(json.cid);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.email != null) {
            builder.email(json.email);
        }
        if (json.expirationTime != null) {
            builder.expirationTime(json.expirationTime);
        }
        if (json.grantType != null) {
            builder.grantType(json.grantType);
        }
        if (json.issuedAt != null) {
            builder.issuedAt(json.issuedAt);
        }
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        if (json.jwtId != null) {
            builder.jwtId(json.jwtId);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        if (json.revocable != null) {
            builder.revocable(json.revocable);
        }
        if (json.revocationSignature != null) {
            builder.revocationSignature(json.revocationSignature);
        }
        if (json.scopes != null) {
            builder.addAllScopes(json.scopes);
        }
        if (json.subject != null) {
            builder.subject(json.subject);
        }
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.userName != null) {
            builder.userName(json.userName);
        }
        if (json.zoneId != null) {
            builder.zoneId(json.zoneId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_AUTHORIZATION_TIME = 1L;
        private static final long INIT_BIT_AUTHORIZED_PARTY = 2L;
        private static final long INIT_BIT_CID = 4L;
        private static final long INIT_BIT_CLIENT_ID = 8L;
        private static final long INIT_BIT_EMAIL = 16L;
        private static final long INIT_BIT_EXPIRATION_TIME = 32L;
        private static final long INIT_BIT_GRANT_TYPE = 64L;
        private static final long INIT_BIT_ISSUED_AT = 128L;
        private static final long INIT_BIT_ISSUER = 256L;
        private static final long INIT_BIT_JWT_ID = 512L;
        private static final long INIT_BIT_ORIGIN = 1024L;
        private static final long INIT_BIT_REVOCABLE = 2048L;
        private static final long INIT_BIT_REVOCATION_SIGNATURE = 4096L;
        private static final long INIT_BIT_SUBJECT = 8192L;
        private static final long INIT_BIT_USER_ID = 16384L;
        private static final long INIT_BIT_USER_NAME = 32768L;
        private static final long INIT_BIT_ZONE_ID = 65536L;
        private long initBits = 131071L;
        private List<String> audiences = new ArrayList<String>();
        private List<String> authorities = new ArrayList<String>();
        private Long authorizationTime;
        private String authorizedParty;
        private String cid;
        private String clientId;
        private String email;
        private Long expirationTime;
        private String grantType;
        private Long issuedAt;
        private String issuer;
        private String jwtId;
        private String origin;
        private Boolean revocable;
        private String revocationSignature;
        private List<String> scopes = new ArrayList<String>();
        private String subject;
        private String userId;
        private String userName;
        private String zoneId;

        private Builder() {
        }

        public final Builder from(CheckTokenResponse instance) {
            return this.from((_CheckTokenResponse)instance);
        }

        final Builder from(_CheckTokenResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAudiences(instance.getAudiences());
            this.addAllAuthorities(instance.getAuthorities());
            this.authorizationTime(instance.getAuthorizationTime());
            this.authorizedParty(instance.getAuthorizedParty());
            this.cid(instance.getCid());
            this.clientId(instance.getClientId());
            this.email(instance.getEmail());
            this.expirationTime(instance.getExpirationTime());
            this.grantType(instance.getGrantType());
            this.issuedAt(instance.getIssuedAt());
            this.issuer(instance.getIssuer());
            this.jwtId(instance.getJwtId());
            this.origin(instance.getOrigin());
            this.revocable(instance.getRevocable());
            this.revocationSignature(instance.getRevocationSignature());
            this.addAllScopes(instance.getScopes());
            this.subject(instance.getSubject());
            this.userId(instance.getUserId());
            this.userName(instance.getUserName());
            this.zoneId(instance.getZoneId());
            return this;
        }

        public final Builder audience(String element) {
            this.audiences.add(Objects.requireNonNull(element, "audiences element"));
            return this;
        }

        public final Builder audience(String ... elements) {
            for (String element : elements) {
                this.audiences.add(Objects.requireNonNull(element, "audiences element"));
            }
            return this;
        }

        @JsonProperty(value="aud")
        public final Builder audiences(Iterable<String> elements) {
            this.audiences.clear();
            return this.addAllAudiences(elements);
        }

        public final Builder addAllAudiences(Iterable<String> elements) {
            for (String element : elements) {
                this.audiences.add(Objects.requireNonNull(element, "audiences element"));
            }
            return this;
        }

        public final Builder authority(String element) {
            this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            return this;
        }

        public final Builder authority(String ... elements) {
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        @JsonProperty(value="authorities")
        public final Builder authorities(Iterable<String> elements) {
            this.authorities.clear();
            return this.addAllAuthorities(elements);
        }

        public final Builder addAllAuthorities(Iterable<String> elements) {
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        @JsonProperty(value="auth_time")
        public final Builder authorizationTime(Long authorizationTime) {
            this.authorizationTime = Objects.requireNonNull(authorizationTime, "authorizationTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="azp")
        public final Builder authorizedParty(String authorizedParty) {
            this.authorizedParty = Objects.requireNonNull(authorizedParty, "authorizedParty");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="cid")
        public final Builder cid(String cid) {
            this.cid = Objects.requireNonNull(cid, "cid");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="client_id")
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="email")
        public final Builder email(String email) {
            this.email = Objects.requireNonNull(email, "email");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="exp")
        public final Builder expirationTime(Long expirationTime) {
            this.expirationTime = Objects.requireNonNull(expirationTime, "expirationTime");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="grant_type")
        public final Builder grantType(String grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="iat")
        public final Builder issuedAt(Long issuedAt) {
            this.issuedAt = Objects.requireNonNull(issuedAt, "issuedAt");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="iss")
        public final Builder issuer(String issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="jti")
        public final Builder jwtId(String jwtId) {
            this.jwtId = Objects.requireNonNull(jwtId, "jwtId");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="origin")
        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="revocable")
        public final Builder revocable(Boolean revocable) {
            this.revocable = Objects.requireNonNull(revocable, "revocable");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @JsonProperty(value="rev_sig")
        public final Builder revocationSignature(String revocationSignature) {
            this.revocationSignature = Objects.requireNonNull(revocationSignature, "revocationSignature");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder scope(String element) {
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder scope(String ... elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @JsonProperty(value="scope")
        public final Builder scopes(Iterable<String> elements) {
            this.scopes.clear();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @JsonProperty(value="sub")
        public final Builder subject(String subject) {
            this.subject = Objects.requireNonNull(subject, "subject");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        @JsonProperty(value="user_id")
        public final Builder userId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        @JsonProperty(value="user_name")
        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        @JsonProperty(value="zid")
        public final Builder zoneId(String zoneId) {
            this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        public CheckTokenResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CheckTokenResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authorizationTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("authorizedParty");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("cid");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("email");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("expirationTime");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("grantType");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("issuedAt");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("issuer");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("jwtId");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("revocable");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("revocationSignature");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("subject");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("userName");
            }
            if ((this.initBits & 0x10000L) != 0L) {
                attributes.add("zoneId");
            }
            return "Cannot build CheckTokenResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _CheckTokenResponse {
        List<String> audiences = Collections.emptyList();
        List<String> authorities = Collections.emptyList();
        Long authorizationTime;
        String authorizedParty;
        String cid;
        String clientId;
        String email;
        Long expirationTime;
        String grantType;
        Long issuedAt;
        String issuer;
        String jwtId;
        String origin;
        Boolean revocable;
        String revocationSignature;
        List<String> scopes = Collections.emptyList();
        String subject;
        String userId;
        String userName;
        String zoneId;

        Json() {
        }

        @JsonProperty(value="aud")
        public void setAudiences(List<String> audiences) {
            this.audiences = audiences;
        }

        @JsonProperty(value="authorities")
        public void setAuthorities(List<String> authorities) {
            this.authorities = authorities;
        }

        @JsonProperty(value="auth_time")
        public void setAuthorizationTime(Long authorizationTime) {
            this.authorizationTime = authorizationTime;
        }

        @JsonProperty(value="azp")
        public void setAuthorizedParty(String authorizedParty) {
            this.authorizedParty = authorizedParty;
        }

        @JsonProperty(value="cid")
        public void setCid(String cid) {
            this.cid = cid;
        }

        @JsonProperty(value="client_id")
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="email")
        public void setEmail(String email) {
            this.email = email;
        }

        @JsonProperty(value="exp")
        public void setExpirationTime(Long expirationTime) {
            this.expirationTime = expirationTime;
        }

        @JsonProperty(value="grant_type")
        public void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @JsonProperty(value="iat")
        public void setIssuedAt(Long issuedAt) {
            this.issuedAt = issuedAt;
        }

        @JsonProperty(value="iss")
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @JsonProperty(value="jti")
        public void setJwtId(String jwtId) {
            this.jwtId = jwtId;
        }

        @JsonProperty(value="origin")
        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @JsonProperty(value="revocable")
        public void setRevocable(Boolean revocable) {
            this.revocable = revocable;
        }

        @JsonProperty(value="rev_sig")
        public void setRevocationSignature(String revocationSignature) {
            this.revocationSignature = revocationSignature;
        }

        @JsonProperty(value="scope")
        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        @JsonProperty(value="sub")
        public void setSubject(String subject) {
            this.subject = subject;
        }

        @JsonProperty(value="user_id")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="user_name")
        public void setUserName(String userName) {
            this.userName = userName;
        }

        @JsonProperty(value="zid")
        public void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public List<String> getAudiences() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAuthorities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getAuthorizationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthorizedParty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEmail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getIssuedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIssuer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getJwtId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getRevocable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevocationSignature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getScopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSubject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getZoneId() {
            throw new UnsupportedOperationException();
        }
    }
}

