/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.tokens.AbstractToken;
import org.cloudfoundry.uaa.tokens._GetTokenByPasswordResponse;

public final class GetTokenByPasswordResponse
extends _GetTokenByPasswordResponse {
    private final String refreshToken;
    private final String accessToken;
    private final Integer expiresInSeconds;
    private final String scopes;
    private final String tokenId;
    private final String tokenType;

    private GetTokenByPasswordResponse(Builder builder) {
        this.refreshToken = builder.refreshToken;
        this.accessToken = builder.accessToken;
        this.expiresInSeconds = builder.expiresInSeconds;
        this.scopes = builder.scopes;
        this.tokenId = builder.tokenId;
        this.tokenType = builder.tokenType;
    }

    @Override
    @JsonProperty(value="refresh_token")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    @JsonProperty(value="access_token")
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    @JsonProperty(value="expires_in")
    public Integer getExpiresInSeconds() {
        return this.expiresInSeconds;
    }

    @Override
    @JsonProperty(value="scope")
    public String getScopes() {
        return this.scopes;
    }

    @Override
    @JsonProperty(value="jti")
    public String getTokenId() {
        return this.tokenId;
    }

    @Override
    @JsonProperty(value="token_type")
    public String getTokenType() {
        return this.tokenType;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetTokenByPasswordResponse && this.equalTo((GetTokenByPasswordResponse)another);
    }

    private boolean equalTo(GetTokenByPasswordResponse another) {
        return this.refreshToken.equals(another.refreshToken) && this.accessToken.equals(another.accessToken) && this.expiresInSeconds.equals(another.expiresInSeconds) && this.scopes.equals(another.scopes) && this.tokenId.equals(another.tokenId) && this.tokenType.equals(another.tokenType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.refreshToken.hashCode();
        h += (h << 5) + this.accessToken.hashCode();
        h += (h << 5) + this.expiresInSeconds.hashCode();
        h += (h << 5) + this.scopes.hashCode();
        h += (h << 5) + this.tokenId.hashCode();
        h += (h << 5) + this.tokenType.hashCode();
        return h;
    }

    public String toString() {
        return "GetTokenByPasswordResponse{refreshToken=" + this.refreshToken + ", accessToken=" + this.accessToken + ", expiresInSeconds=" + this.expiresInSeconds + ", scopes=" + this.scopes + ", tokenId=" + this.tokenId + ", tokenType=" + this.tokenType + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetTokenByPasswordResponse fromJson(Json json) {
        Builder builder = GetTokenByPasswordResponse.builder();
        if (json.refreshToken != null) {
            builder.refreshToken(json.refreshToken);
        }
        if (json.accessToken != null) {
            builder.accessToken(json.accessToken);
        }
        if (json.expiresInSeconds != null) {
            builder.expiresInSeconds(json.expiresInSeconds);
        }
        if (json.scopes != null) {
            builder.scopes(json.scopes);
        }
        if (json.tokenId != null) {
            builder.tokenId(json.tokenId);
        }
        if (json.tokenType != null) {
            builder.tokenType(json.tokenType);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REFRESH_TOKEN = 1L;
        private static final long INIT_BIT_ACCESS_TOKEN = 2L;
        private static final long INIT_BIT_EXPIRES_IN_SECONDS = 4L;
        private static final long INIT_BIT_SCOPES = 8L;
        private static final long INIT_BIT_TOKEN_ID = 16L;
        private static final long INIT_BIT_TOKEN_TYPE = 32L;
        private long initBits = 63L;
        private String refreshToken;
        private String accessToken;
        private Integer expiresInSeconds;
        private String scopes;
        private String tokenId;
        private String tokenType;

        private Builder() {
        }

        public final Builder from(GetTokenByPasswordResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_GetTokenByPasswordResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractToken instance;
            if (object instanceof _GetTokenByPasswordResponse) {
                instance = (_GetTokenByPasswordResponse)object;
                this.refreshToken(((_GetTokenByPasswordResponse)instance).getRefreshToken());
            }
            if (object instanceof AbstractToken) {
                instance = (AbstractToken)object;
                this.scopes(instance.getScopes());
                this.tokenId(instance.getTokenId());
                this.accessToken(instance.getAccessToken());
                this.tokenType(instance.getTokenType());
                this.expiresInSeconds(instance.getExpiresInSeconds());
            }
        }

        @JsonProperty(value="refresh_token")
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="access_token")
        public final Builder accessToken(String accessToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expires_in")
        public final Builder expiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = Objects.requireNonNull(expiresInSeconds, "expiresInSeconds");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="scope")
        public final Builder scopes(String scopes) {
            this.scopes = Objects.requireNonNull(scopes, "scopes");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="jti")
        public final Builder tokenId(String tokenId) {
            this.tokenId = Objects.requireNonNull(tokenId, "tokenId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="token_type")
        public final Builder tokenType(String tokenType) {
            this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public GetTokenByPasswordResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetTokenByPasswordResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("refreshToken");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessToken");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("expiresInSeconds");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("scopes");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("tokenId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("tokenType");
            }
            return "Cannot build GetTokenByPasswordResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _GetTokenByPasswordResponse {
        String refreshToken;
        String accessToken;
        Integer expiresInSeconds;
        String scopes;
        String tokenId;
        String tokenType;

        Json() {
        }

        @JsonProperty(value="refresh_token")
        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @JsonProperty(value="access_token")
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @JsonProperty(value="expires_in")
        public void setExpiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
        }

        @JsonProperty(value="scope")
        public void setScopes(String scopes) {
            this.scopes = scopes;
        }

        @JsonProperty(value="jti")
        public void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @JsonProperty(value="token_type")
        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public String getRefreshToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAccessToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getExpiresInSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getScopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTokenId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTokenType() {
            throw new UnsupportedOperationException();
        }
    }
}

