/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.domains._ShareDomainRequest;
import org.immutables.value.Generated;

@Generated(from="_ShareDomainRequest", generator="Immutables")
public final class ShareDomainRequest
extends _ShareDomainRequest {
    private final List<Relationship> data;
    private final String domainId;

    private ShareDomainRequest(Builder builder) {
        this.data = ShareDomainRequest.createUnmodifiableList(true, builder.data);
        this.domainId = builder.domainId;
    }

    @Override
    @JsonProperty(value="data")
    public List<Relationship> getData() {
        return this.data;
    }

    @Override
    @JsonProperty(value="domainId")
    @JsonIgnore
    public String getDomainId() {
        return this.domainId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ShareDomainRequest && this.equalTo((ShareDomainRequest)another);
    }

    private boolean equalTo(ShareDomainRequest another) {
        return this.data.equals(another.data) && this.domainId.equals(another.domainId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + this.domainId.hashCode();
        return h;
    }

    public String toString() {
        return "ShareDomainRequest{data=" + this.data + ", domainId=" + this.domainId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ShareDomainRequest fromJson(Json json) {
        Builder builder = ShareDomainRequest.builder();
        if (json.data != null) {
            builder.addAllData(json.data);
        }
        if (json.domainId != null) {
            builder.domainId(json.domainId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ShareDomainRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DOMAIN_ID = 1L;
        private long initBits = 1L;
        private List<Relationship> data = new ArrayList<Relationship>();
        private String domainId;

        private Builder() {
        }

        public final Builder from(ShareDomainRequest instance) {
            return this.from((_ShareDomainRequest)instance);
        }

        final Builder from(_ShareDomainRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllData(instance.getData());
            this.domainId(instance.getDomainId());
            return this;
        }

        public final Builder data(Relationship element) {
            this.data.add(Objects.requireNonNull(element, "data element"));
            return this;
        }

        public final Builder data(Relationship ... elements) {
            for (Relationship element : elements) {
                this.data.add(Objects.requireNonNull(element, "data element"));
            }
            return this;
        }

        public final Builder data(Iterable<? extends Relationship> elements) {
            this.data.clear();
            return this.addAllData(elements);
        }

        public final Builder addAllData(Iterable<? extends Relationship> elements) {
            for (Relationship relationship : elements) {
                this.data.add(Objects.requireNonNull(relationship, "data element"));
            }
            return this;
        }

        public final Builder domainId(String domainId) {
            this.domainId = Objects.requireNonNull(domainId, "domainId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ShareDomainRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ShareDomainRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domainId");
            }
            return "Cannot build ShareDomainRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ShareDomainRequest", generator="Immutables")
    static final class Json
    extends _ShareDomainRequest {
        List<Relationship> data = Collections.emptyList();
        String domainId;

        Json() {
        }

        @JsonProperty(value="data")
        public void setData(List<Relationship> data) {
            this.data = data;
        }

        @JsonProperty(value="domainId")
        @JsonIgnore
        public void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public List<Relationship> getData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDomainId() {
            throw new UnsupportedOperationException();
        }
    }
}

