/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.droplets.DropletRelationships;
import org.cloudfoundry.client.v3.droplets._CopyDropletRequest;
import org.immutables.value.Generated;

@Generated(from="_CopyDropletRequest", generator="Immutables")
public final class CopyDropletRequest
extends _CopyDropletRequest {
    private final DropletRelationships relationships;
    private final String sourceDropletId;

    private CopyDropletRequest(Builder builder) {
        this.relationships = builder.relationships;
        this.sourceDropletId = builder.sourceDropletId;
    }

    @Override
    @JsonProperty(value="relationships")
    public DropletRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonIgnore
    public String getSourceDropletId() {
        return this.sourceDropletId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CopyDropletRequest && this.equalTo((CopyDropletRequest)another);
    }

    private boolean equalTo(CopyDropletRequest another) {
        return this.relationships.equals(another.relationships) && this.sourceDropletId.equals(another.sourceDropletId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.sourceDropletId.hashCode();
        return h;
    }

    public String toString() {
        return "CopyDropletRequest{relationships=" + this.relationships + ", sourceDropletId=" + this.sourceDropletId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CopyDropletRequest fromJson(Json json) {
        Builder builder = CopyDropletRequest.builder();
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.sourceDropletId != null) {
            builder.sourceDropletId(json.sourceDropletId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CopyDropletRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RELATIONSHIPS = 1L;
        private static final long INIT_BIT_SOURCE_DROPLET_ID = 2L;
        private long initBits = 3L;
        private DropletRelationships relationships;
        private String sourceDropletId;

        private Builder() {
        }

        public final Builder from(CopyDropletRequest instance) {
            return this.from((_CopyDropletRequest)instance);
        }

        final Builder from(_CopyDropletRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.relationships(instance.getRelationships());
            this.sourceDropletId(instance.getSourceDropletId());
            return this;
        }

        public final Builder relationships(DropletRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sourceDropletId(String sourceDropletId) {
            this.sourceDropletId = Objects.requireNonNull(sourceDropletId, "sourceDropletId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CopyDropletRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CopyDropletRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sourceDropletId");
            }
            return "Cannot build CopyDropletRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CopyDropletRequest", generator="Immutables")
    static final class Json
    extends _CopyDropletRequest {
        DropletRelationships relationships;
        String sourceDropletId;

        Json() {
        }

        @JsonProperty(value="relationships")
        public void setRelationships(DropletRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonIgnore
        public void setSourceDropletId(String sourceDropletId) {
            this.sourceDropletId = sourceDropletId;
        }

        @Override
        public DropletRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSourceDropletId() {
            throw new UnsupportedOperationException();
        }
    }
}

