/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Checksum;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.droplets.Buildpack;
import org.cloudfoundry.client.v3.droplets.Droplet;
import org.cloudfoundry.client.v3.droplets.DropletRelationships;
import org.cloudfoundry.client.v3.droplets.DropletState;
import org.cloudfoundry.client.v3.droplets._DropletResource;
import org.immutables.value.Generated;

@Generated(from="_DropletResource", generator="Immutables")
public final class DropletResource
extends _DropletResource {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    @Nullable
    private final List<Buildpack> buildpacks;
    @Nullable
    private final Checksum checksum;
    @Nullable
    private final String error;
    private final String executionMetadata;
    @Nullable
    private final String image;
    private final Lifecycle lifecycle;
    @Nullable
    private final Metadata metadata;
    @Nullable
    private final Map<String, String> processTypes;
    @Nullable
    private final DropletRelationships relationships;
    @Nullable
    private final String stack;
    private final DropletState state;

    private DropletResource(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = DropletResource.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.buildpacks = builder.buildpacks == null ? null : DropletResource.createUnmodifiableList(true, builder.buildpacks);
        this.checksum = builder.checksum;
        this.error = builder.error;
        this.executionMetadata = builder.executionMetadata;
        this.image = builder.image;
        this.lifecycle = builder.lifecycle;
        this.metadata = builder.metadata;
        this.processTypes = builder.processTypes == null ? null : DropletResource.createUnmodifiableMap(false, false, builder.processTypes);
        this.relationships = builder.relationships;
        this.stack = builder.stack;
        this.state = builder.state;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="buildpacks")
    @Nullable
    public List<Buildpack> getBuildpacks() {
        return this.buildpacks;
    }

    @Override
    @JsonProperty(value="checksum")
    @Nullable
    public Checksum getChecksum() {
        return this.checksum;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="execution_metadata")
    public String getExecutionMetadata() {
        return this.executionMetadata;
    }

    @Override
    @JsonProperty(value="image")
    @Nullable
    public String getImage() {
        return this.image;
    }

    @Override
    @JsonProperty(value="lifecycle")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="process_types")
    @Nullable
    public Map<String, String> getProcessTypes() {
        return this.processTypes;
    }

    @Override
    @JsonProperty(value="relationships")
    @Nullable
    public DropletRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="stack")
    @Nullable
    public String getStack() {
        return this.stack;
    }

    @Override
    @JsonProperty(value="state")
    public DropletState getState() {
        return this.state;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DropletResource && this.equalTo((DropletResource)another);
    }

    private boolean equalTo(DropletResource another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.buildpacks, another.buildpacks) && Objects.equals(this.checksum, another.checksum) && Objects.equals(this.error, another.error) && this.executionMetadata.equals(another.executionMetadata) && Objects.equals(this.image, another.image) && this.lifecycle.equals(another.lifecycle) && Objects.equals(this.metadata, another.metadata) && Objects.equals(this.processTypes, another.processTypes) && Objects.equals(this.relationships, another.relationships) && Objects.equals(this.stack, another.stack) && this.state.equals((Object)another.state);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.buildpacks);
        h += (h << 5) + Objects.hashCode(this.checksum);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.executionMetadata.hashCode();
        h += (h << 5) + Objects.hashCode(this.image);
        h += (h << 5) + this.lifecycle.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + Objects.hashCode(this.processTypes);
        h += (h << 5) + Objects.hashCode(this.relationships);
        h += (h << 5) + Objects.hashCode(this.stack);
        h += (h << 5) + this.state.hashCode();
        return h;
    }

    public String toString() {
        return "DropletResource{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", buildpacks=" + this.buildpacks + ", checksum=" + this.checksum + ", error=" + this.error + ", executionMetadata=" + this.executionMetadata + ", image=" + this.image + ", lifecycle=" + this.lifecycle + ", metadata=" + this.metadata + ", processTypes=" + this.processTypes + ", relationships=" + this.relationships + ", stack=" + this.stack + ", state=" + (Object)((Object)this.state) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static DropletResource fromJson(Json json) {
        Builder builder = DropletResource.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.buildpacks != null) {
            builder.addAllBuildpacks(json.buildpacks);
        }
        if (json.checksum != null) {
            builder.checksum(json.checksum);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.executionMetadata != null) {
            builder.executionMetadata(json.executionMetadata);
        }
        if (json.image != null) {
            builder.image(json.image);
        }
        if (json.lifecycle != null) {
            builder.lifecycle(json.lifecycle);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.processTypes != null) {
            builder.putAllProcessTypes(json.processTypes);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.stack != null) {
            builder.stack(json.stack);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_DropletResource", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_EXECUTION_METADATA = 4L;
        private static final long INIT_BIT_LIFECYCLE = 8L;
        private static final long INIT_BIT_STATE = 16L;
        private long initBits = 31L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private List<Buildpack> buildpacks = null;
        private Checksum checksum;
        private String error;
        private String executionMetadata;
        private String image;
        private Lifecycle lifecycle;
        private Metadata metadata;
        private Map<String, String> processTypes = null;
        private DropletRelationships relationships;
        private String stack;
        private DropletState state;

        private Builder() {
        }

        public final Builder from(Droplet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DropletResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_DropletResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof Droplet) {
                Map<String, String> processTypesValue;
                String stackValue;
                Metadata metadataValue;
                DropletRelationships relationshipsValue;
                instance = (Droplet)object;
                List<Buildpack> buildpacksValue = ((Droplet)instance).getBuildpacks();
                if (buildpacksValue != null) {
                    this.addAllBuildpacks(buildpacksValue);
                }
                this.lifecycle(((Droplet)instance).getLifecycle());
                String imageValue = ((Droplet)instance).getImage();
                if (imageValue != null) {
                    this.image(imageValue);
                }
                if ((relationshipsValue = ((Droplet)instance).getRelationships()) != null) {
                    this.relationships(relationshipsValue);
                }
                if ((metadataValue = ((Droplet)instance).getMetadata()) != null) {
                    this.metadata(metadataValue);
                }
                if ((stackValue = ((Droplet)instance).getStack()) != null) {
                    this.stack(stackValue);
                }
                this.executionMetadata(((Droplet)instance).getExecutionMetadata());
                Checksum checksumValue = ((Droplet)instance).getChecksum();
                if (checksumValue != null) {
                    this.checksum(checksumValue);
                }
                this.state(((Droplet)instance).getState());
                String errorValue = ((Droplet)instance).getError();
                if (errorValue != null) {
                    this.error(errorValue);
                }
                if ((processTypesValue = ((Droplet)instance).getProcessTypes()) != null) {
                    this.putAllProcessTypes(processTypesValue);
                }
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Builder buildpack(Buildpack element) {
            if (this.buildpacks == null) {
                this.buildpacks = new ArrayList<Buildpack>();
            }
            this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
            return this;
        }

        public final Builder buildpacks(Buildpack ... elements) {
            if (this.buildpacks == null) {
                this.buildpacks = new ArrayList<Buildpack>();
            }
            for (Buildpack element : elements) {
                this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
            }
            return this;
        }

        @JsonProperty(value="buildpacks")
        public final Builder buildpacks(@Nullable Iterable<? extends Buildpack> elements) {
            if (elements == null) {
                this.buildpacks = null;
                return this;
            }
            this.buildpacks = new ArrayList<Buildpack>();
            return this.addAllBuildpacks(elements);
        }

        public final Builder addAllBuildpacks(Iterable<? extends Buildpack> elements) {
            Objects.requireNonNull(elements, "buildpacks element");
            if (this.buildpacks == null) {
                this.buildpacks = new ArrayList<Buildpack>();
            }
            for (Buildpack buildpack : elements) {
                this.buildpacks.add(Objects.requireNonNull(buildpack, "buildpacks element"));
            }
            return this;
        }

        @JsonProperty(value="checksum")
        public final Builder checksum(@Nullable Checksum checksum) {
            this.checksum = checksum;
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="execution_metadata")
        public final Builder executionMetadata(String executionMetadata) {
            this.executionMetadata = Objects.requireNonNull(executionMetadata, "executionMetadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="image")
        public final Builder image(@Nullable String image) {
            this.image = image;
            return this;
        }

        @JsonProperty(value="lifecycle")
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Builder processType(String key, String value) {
            if (this.processTypes == null) {
                this.processTypes = new LinkedHashMap<String, String>();
            }
            this.processTypes.put(Objects.requireNonNull(key, "processTypes key"), Objects.requireNonNull(value, "processTypes value"));
            return this;
        }

        public final Builder processType(Map.Entry<String, ? extends String> entry) {
            if (this.processTypes == null) {
                this.processTypes = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.processTypes.put(Objects.requireNonNull(k, "processTypes key"), Objects.requireNonNull(v, "processTypes value"));
            return this;
        }

        @JsonProperty(value="process_types")
        public final Builder processTypes(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.processTypes = null;
                return this;
            }
            this.processTypes = new LinkedHashMap<String, String>();
            return this.putAllProcessTypes(entries);
        }

        public final Builder putAllProcessTypes(Map<String, ? extends String> entries) {
            if (this.processTypes == null) {
                this.processTypes = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.processTypes.put(Objects.requireNonNull(k, "processTypes key"), Objects.requireNonNull(v, "processTypes value"));
            }
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(@Nullable DropletRelationships relationships) {
            this.relationships = relationships;
            return this;
        }

        @JsonProperty(value="stack")
        public final Builder stack(@Nullable String stack) {
            this.stack = stack;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(DropletState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public DropletResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DropletResource(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("executionMetadata");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lifecycle");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build DropletResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_DropletResource", generator="Immutables")
    static final class Json
    extends _DropletResource {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        List<Buildpack> buildpacks = null;
        Checksum checksum;
        String error;
        String executionMetadata;
        String image;
        Lifecycle lifecycle;
        Metadata metadata;
        Map<String, String> processTypes = null;
        DropletRelationships relationships;
        String stack;
        DropletState state;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="buildpacks")
        public void setBuildpacks(@Nullable List<Buildpack> buildpacks) {
            this.buildpacks = buildpacks;
        }

        @JsonProperty(value="checksum")
        public void setChecksum(@Nullable Checksum checksum) {
            this.checksum = checksum;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="execution_metadata")
        public void setExecutionMetadata(String executionMetadata) {
            this.executionMetadata = executionMetadata;
        }

        @JsonProperty(value="image")
        public void setImage(@Nullable String image) {
            this.image = image;
        }

        @JsonProperty(value="lifecycle")
        public void setLifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="process_types")
        public void setProcessTypes(@Nullable Map<String, String> processTypes) {
            this.processTypes = processTypes;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(@Nullable DropletRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="stack")
        public void setStack(@Nullable String stack) {
            this.stack = stack;
        }

        @JsonProperty(value="state")
        public void setState(DropletState state) {
            this.state = state;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Buildpack> getBuildpacks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Checksum getChecksum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExecutionMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getImage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Lifecycle getLifecycle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getProcessTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DropletRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStack() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DropletState getState() {
            throw new UnsupportedOperationException();
        }
    }
}

