/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.roles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum RoleType {
    ORGANIZATION_AUDITOR,
    ORGANIZATION_BILLING_MANAGER,
    ORGANIZATION_MANAGER,
    ORGANIZATION_USER,
    SPACE_AUDITOR,
    SPACE_DEVELOPER,
    SPACE_MANAGER;

    public static final Set<RoleType> ORGANIZATION_ROLE_TYPES;
    public static final Set<RoleType> SPACE_ROLE_TYPES;
    private static final Map<String, RoleType> NAMES_TO_VALUES;

    @JsonCreator
    public static RoleType from(String s) {
        RoleType roleType = NAMES_TO_VALUES.get(s);
        if (roleType == null) {
            throw new IllegalArgumentException("Unknown role type: " + s);
        }
        return roleType;
    }

    @JsonValue
    public String getValue() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.getValue();
    }

    static {
        ORGANIZATION_ROLE_TYPES = EnumSet.of(ORGANIZATION_AUDITOR, ORGANIZATION_BILLING_MANAGER, ORGANIZATION_MANAGER, ORGANIZATION_USER);
        SPACE_ROLE_TYPES = EnumSet.of(SPACE_AUDITOR, SPACE_DEVELOPER, SPACE_MANAGER);
        NAMES_TO_VALUES = Arrays.stream(RoleType.values()).collect(Collectors.toMap(RoleType::getValue, roleType -> roleType));
    }
}

