/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.tasks.Result;
import org.cloudfoundry.client.v3.tasks.Task;
import org.cloudfoundry.client.v3.tasks.TaskRelationships;
import org.cloudfoundry.client.v3.tasks.TaskState;
import org.cloudfoundry.client.v3.tasks._TaskResource;
import org.immutables.value.Generated;

@Generated(from="_TaskResource", generator="Immutables")
public final class TaskResource
extends _TaskResource {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    @Nullable
    private final String command;
    private final Integer diskInMb;
    private final String dropletId;
    private final Integer memoryInMb;
    @Nullable
    private final Metadata metadata;
    private final String name;
    @Nullable
    private final Result result;
    private final Integer sequenceId;
    private final TaskState state;
    @Nullable
    private final TaskRelationships taskRelationships;

    private TaskResource(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = TaskResource.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.command = builder.command;
        this.diskInMb = builder.diskInMb;
        this.dropletId = builder.dropletId;
        this.memoryInMb = builder.memoryInMb;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.result = builder.result;
        this.sequenceId = builder.sequenceId;
        this.state = builder.state;
        this.taskRelationships = builder.taskRelationships;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="command")
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty(value="disk_in_mb")
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    @Override
    @JsonProperty(value="droplet_guid")
    public String getDropletId() {
        return this.dropletId;
    }

    @Override
    @JsonProperty(value="memory_in_mb")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="result")
    @Nullable
    public Result getResult() {
        return this.result;
    }

    @Override
    @JsonProperty(value="sequence_id")
    public Integer getSequenceId() {
        return this.sequenceId;
    }

    @Override
    @JsonProperty(value="state")
    public TaskState getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="relationships")
    @Nullable
    public TaskRelationships getTaskRelationships() {
        return this.taskRelationships;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TaskResource && this.equalTo((TaskResource)another);
    }

    private boolean equalTo(TaskResource another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.command, another.command) && this.diskInMb.equals(another.diskInMb) && this.dropletId.equals(another.dropletId) && this.memoryInMb.equals(another.memoryInMb) && Objects.equals(this.metadata, another.metadata) && this.name.equals(another.name) && Objects.equals(this.result, another.result) && this.sequenceId.equals(another.sequenceId) && this.state.equals((Object)another.state) && Objects.equals(this.taskRelationships, another.taskRelationships);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + this.diskInMb.hashCode();
        h += (h << 5) + this.dropletId.hashCode();
        h += (h << 5) + this.memoryInMb.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.result);
        h += (h << 5) + this.sequenceId.hashCode();
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + Objects.hashCode(this.taskRelationships);
        return h;
    }

    public String toString() {
        return "TaskResource{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", command=" + this.command + ", diskInMb=" + this.diskInMb + ", dropletId=" + this.dropletId + ", memoryInMb=" + this.memoryInMb + ", metadata=" + this.metadata + ", name=" + this.name + ", result=" + this.result + ", sequenceId=" + this.sequenceId + ", state=" + (Object)((Object)this.state) + ", taskRelationships=" + this.taskRelationships + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static TaskResource fromJson(Json json) {
        Builder builder = TaskResource.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.command != null) {
            builder.command(json.command);
        }
        if (json.diskInMb != null) {
            builder.diskInMb(json.diskInMb);
        }
        if (json.dropletId != null) {
            builder.dropletId(json.dropletId);
        }
        if (json.memoryInMb != null) {
            builder.memoryInMb(json.memoryInMb);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.result != null) {
            builder.result(json.result);
        }
        if (json.sequenceId != null) {
            builder.sequenceId(json.sequenceId);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.taskRelationships != null) {
            builder.taskRelationships(json.taskRelationships);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_TaskResource", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_DISK_IN_MB = 4L;
        private static final long INIT_BIT_DROPLET_ID = 8L;
        private static final long INIT_BIT_MEMORY_IN_MB = 16L;
        private static final long INIT_BIT_NAME = 32L;
        private static final long INIT_BIT_SEQUENCE_ID = 64L;
        private static final long INIT_BIT_STATE = 128L;
        private long initBits = 255L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private String command;
        private Integer diskInMb;
        private String dropletId;
        private Integer memoryInMb;
        private Metadata metadata;
        private String name;
        private Result result;
        private Integer sequenceId;
        private TaskState state;
        private TaskRelationships taskRelationships;

        private Builder() {
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Task instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TaskResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_TaskResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
            if (object instanceof Task) {
                String commandValue;
                Metadata metadataValue;
                instance = (Task)object;
                this.diskInMb(((Task)instance).getDiskInMb());
                Result resultValue = ((Task)instance).getResult();
                if (resultValue != null) {
                    this.result(resultValue);
                }
                if ((metadataValue = ((Task)instance).getMetadata()) != null) {
                    this.metadata(metadataValue);
                }
                this.dropletId(((Task)instance).getDropletId());
                this.memoryInMb(((Task)instance).getMemoryInMb());
                this.name(((Task)instance).getName());
                this.state(((Task)instance).getState());
                this.sequenceId(((Task)instance).getSequenceId());
                TaskRelationships taskRelationshipsValue = ((Task)instance).getTaskRelationships();
                if (taskRelationshipsValue != null) {
                    this.taskRelationships(taskRelationshipsValue);
                }
                if ((commandValue = ((Task)instance).getCommand()) != null) {
                    this.command(commandValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="command")
        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        @JsonProperty(value="disk_in_mb")
        public final Builder diskInMb(Integer diskInMb) {
            this.diskInMb = Objects.requireNonNull(diskInMb, "diskInMb");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="droplet_guid")
        public final Builder dropletId(String dropletId) {
            this.dropletId = Objects.requireNonNull(dropletId, "dropletId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="memory_in_mb")
        public final Builder memoryInMb(Integer memoryInMb) {
            this.memoryInMb = Objects.requireNonNull(memoryInMb, "memoryInMb");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="result")
        public final Builder result(@Nullable Result result) {
            this.result = result;
            return this;
        }

        @JsonProperty(value="sequence_id")
        public final Builder sequenceId(Integer sequenceId) {
            this.sequenceId = Objects.requireNonNull(sequenceId, "sequenceId");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(TaskState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder taskRelationships(@Nullable TaskRelationships taskRelationships) {
            this.taskRelationships = taskRelationships;
            return this;
        }

        public TaskResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TaskResource(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("diskInMb");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("dropletId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("memoryInMb");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("sequenceId");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build TaskResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_TaskResource", generator="Immutables")
    static final class Json
    extends _TaskResource {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        String command;
        Integer diskInMb;
        String dropletId;
        Integer memoryInMb;
        Metadata metadata;
        String name;
        Result result;
        Integer sequenceId;
        TaskState state;
        TaskRelationships taskRelationships;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="command")
        public void setCommand(@Nullable String command) {
            this.command = command;
        }

        @JsonProperty(value="disk_in_mb")
        public void setDiskInMb(Integer diskInMb) {
            this.diskInMb = diskInMb;
        }

        @JsonProperty(value="droplet_guid")
        public void setDropletId(String dropletId) {
            this.dropletId = dropletId;
        }

        @JsonProperty(value="memory_in_mb")
        public void setMemoryInMb(Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="result")
        public void setResult(@Nullable Result result) {
            this.result = result;
        }

        @JsonProperty(value="sequence_id")
        public void setSequenceId(Integer sequenceId) {
            this.sequenceId = sequenceId;
        }

        @JsonProperty(value="state")
        public void setState(TaskState state) {
            this.state = state;
        }

        @JsonProperty(value="relationships")
        public void setTaskRelationships(@Nullable TaskRelationships taskRelationships) {
            this.taskRelationships = taskRelationships;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getDiskInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDropletId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemoryInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Result getResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getSequenceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskState getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskRelationships getTaskRelationships() {
            throw new UnsupportedOperationException();
        }
    }
}

