/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum EnvelopeType {
    ANY("ANY"),
    LOG("LOG"),
    COUNTER("COUNTER"),
    GAUGE("GAUGE"),
    TIMER("TIMER"),
    EVENT("EVENT");

    private final String value;

    private EnvelopeType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static EnvelopeType from(String s) {
        switch (s.toLowerCase()) {
            case "any": {
                return ANY;
            }
            case "log": {
                return LOG;
            }
            case "counter": {
                return COUNTER;
            }
            case "gauge": {
                return GAUGE;
            }
            case "timer": {
                return TIMER;
            }
            case "event": {
                return EVENT;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown envelope type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

