package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _CopySourceApplicationRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CopySourceApplicationRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CopySourceApplicationRequest"})
public final class CopySourceApplicationRequest
    extends org.cloudfoundry.operations.applications._CopySourceApplicationRequest {
  private final String name;
  private final @Nullable Boolean restart;
  private final @Nullable Duration stagingTimeout;
  private final @Nullable Duration startupTimeout;
  private final String targetName;
  private final @Nullable String targetOrganization;
  private final @Nullable String targetSpace;

  private CopySourceApplicationRequest(CopySourceApplicationRequest.Builder builder) {
    this.name = builder.name;
    this.restart = builder.restart;
    this.stagingTimeout = builder.stagingTimeout;
    this.startupTimeout = builder.startupTimeout;
    this.targetName = builder.targetName;
    this.targetOrganization = builder.targetOrganization;
    this.targetSpace = builder.targetSpace;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Whether to restart the target application
   */
  @Override
  public @Nullable Boolean getRestart() {
    return restart;
  }

  /**
   * How long to wait for staging
   */
  @Override
  public @Nullable Duration getStagingTimeout() {
    return stagingTimeout;
  }

  /**
   * How long to wait for startup
   */
  @Override
  public @Nullable Duration getStartupTimeout() {
    return startupTimeout;
  }

  /**
   * The name of the target application
   */
  @Override
  public String getTargetName() {
    return targetName;
  }

  /**
   * The organization of the target application
   */
  @Override
  public @Nullable String getTargetOrganization() {
    return targetOrganization;
  }

  /**
   * The space of the target application
   */
  @Override
  public @Nullable String getTargetSpace() {
    return targetSpace;
  }

  /**
   * This instance is equal to all instances of {@code CopySourceApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CopySourceApplicationRequest
        && equalTo((CopySourceApplicationRequest) another);
  }

  private boolean equalTo(CopySourceApplicationRequest another) {
    return name.equals(another.name)
        && Objects.equals(restart, another.restart)
        && Objects.equals(stagingTimeout, another.stagingTimeout)
        && Objects.equals(startupTimeout, another.startupTimeout)
        && targetName.equals(another.targetName)
        && Objects.equals(targetOrganization, another.targetOrganization)
        && Objects.equals(targetSpace, another.targetSpace);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code restart}, {@code stagingTimeout}, {@code startupTimeout}, {@code targetName}, {@code targetOrganization}, {@code targetSpace}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(restart);
    h = h * 17 + Objects.hashCode(stagingTimeout);
    h = h * 17 + Objects.hashCode(startupTimeout);
    h = h * 17 + targetName.hashCode();
    h = h * 17 + Objects.hashCode(targetOrganization);
    h = h * 17 + Objects.hashCode(targetSpace);
    return h;
  }

  /**
   * Prints the immutable value {@code CopySourceApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CopySourceApplicationRequest{"
        + "name=" + name
        + ", restart=" + restart
        + ", stagingTimeout=" + stagingTimeout
        + ", startupTimeout=" + startupTimeout
        + ", targetName=" + targetName
        + ", targetOrganization=" + targetOrganization
        + ", targetSpace=" + targetSpace
        + "}";
  }

  private static CopySourceApplicationRequest validate(CopySourceApplicationRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link CopySourceApplicationRequest CopySourceApplicationRequest}.
   * @return A new CopySourceApplicationRequest builder
   */
  public static CopySourceApplicationRequest.Builder builder() {
    return new CopySourceApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link CopySourceApplicationRequest CopySourceApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TARGET_NAME = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private Boolean restart;
    private Duration stagingTimeout;
    private Duration startupTimeout;
    private String targetName;
    private String targetOrganization;
    private String targetSpace;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CopySourceApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CopySourceApplicationRequest instance) {
      return from((_CopySourceApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CopySourceApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CopySourceApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      Boolean restartValue = instance.getRestart();
      if (restartValue != null) {
        restart(restartValue);
      }
      Duration stagingTimeoutValue = instance.getStagingTimeout();
      if (stagingTimeoutValue != null) {
        stagingTimeout(stagingTimeoutValue);
      }
      Duration startupTimeoutValue = instance.getStartupTimeout();
      if (startupTimeoutValue != null) {
        startupTimeout(startupTimeoutValue);
      }
      targetName(instance.getTargetName());
      String targetOrganizationValue = instance.getTargetOrganization();
      if (targetOrganizationValue != null) {
        targetOrganization(targetOrganizationValue);
      }
      String targetSpaceValue = instance.getTargetSpace();
      if (targetSpaceValue != null) {
        targetSpace(targetSpaceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CopySourceApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CopySourceApplicationRequest#getRestart() restart} attribute.
     * @param restart The value for restart (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder restart(@Nullable Boolean restart) {
      this.restart = restart;
      return this;
    }

    /**
     * Initializes the value for the {@link _CopySourceApplicationRequest#getStagingTimeout() stagingTimeout} attribute.
     * @param stagingTimeout The value for stagingTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingTimeout(@Nullable Duration stagingTimeout) {
      this.stagingTimeout = stagingTimeout;
      return this;
    }

    /**
     * Initializes the value for the {@link _CopySourceApplicationRequest#getStartupTimeout() startupTimeout} attribute.
     * @param startupTimeout The value for startupTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startupTimeout(@Nullable Duration startupTimeout) {
      this.startupTimeout = startupTimeout;
      return this;
    }

    /**
     * Initializes the value for the {@link _CopySourceApplicationRequest#getTargetName() targetName} attribute.
     * @param targetName The value for targetName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetName(String targetName) {
      this.targetName = Objects.requireNonNull(targetName, "targetName");
      initBits &= ~INIT_BIT_TARGET_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CopySourceApplicationRequest#getTargetOrganization() targetOrganization} attribute.
     * @param targetOrganization The value for targetOrganization (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetOrganization(@Nullable String targetOrganization) {
      this.targetOrganization = targetOrganization;
      return this;
    }

    /**
     * Initializes the value for the {@link _CopySourceApplicationRequest#getTargetSpace() targetSpace} attribute.
     * @param targetSpace The value for targetSpace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder targetSpace(@Nullable String targetSpace) {
      this.targetSpace = targetSpace;
      return this;
    }

    /**
     * Builds a new {@link CopySourceApplicationRequest CopySourceApplicationRequest}.
     * @return An immutable instance of CopySourceApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CopySourceApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return CopySourceApplicationRequest.validate(new CopySourceApplicationRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TARGET_NAME) != 0) attributes.add("targetName");
      return "Cannot build CopySourceApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
