package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _UnmapRouteRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UnmapRouteRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_UnmapRouteRequest"})
public final class UnmapRouteRequest extends org.cloudfoundry.operations.routes._UnmapRouteRequest {
  private final String applicationName;
  private final String domain;
  private final @Nullable String host;
  private final @Nullable String path;

  private UnmapRouteRequest(UnmapRouteRequest.Builder builder) {
    this.applicationName = builder.applicationName;
    this.domain = builder.domain;
    this.host = builder.host;
    this.path = builder.path;
  }

  /**
   * The name of the application to remove a route from
   */
  @Override
  public String getApplicationName() {
    return applicationName;
  }

  /**
   * The domain of the route
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The host of the route
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path of the route
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * This instance is equal to all instances of {@code UnmapRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnmapRouteRequest
        && equalTo((UnmapRouteRequest) another);
  }

  private boolean equalTo(UnmapRouteRequest another) {
    return applicationName.equals(another.applicationName)
        && domain.equals(another.domain)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path);
  }

  /**
   * Computes a hash code from attributes: {@code applicationName}, {@code domain}, {@code host}, {@code path}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationName.hashCode();
    h = h * 17 + domain.hashCode();
    h = h * 17 + Objects.hashCode(host);
    h = h * 17 + Objects.hashCode(path);
    return h;
  }

  /**
   * Prints the immutable value {@code UnmapRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnmapRouteRequest{"
        + "applicationName=" + applicationName
        + ", domain=" + domain
        + ", host=" + host
        + ", path=" + path
        + "}";
  }

  /**
   * Creates a builder for {@link UnmapRouteRequest UnmapRouteRequest}.
   * @return A new UnmapRouteRequest builder
   */
  public static UnmapRouteRequest.Builder builder() {
    return new UnmapRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnmapRouteRequest UnmapRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_NAME = 0x1L;
    private static final long INIT_BIT_DOMAIN = 0x2L;
    private long initBits = 0x3L;

    private String applicationName;
    private String domain;
    private String host;
    private String path;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnmapRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnmapRouteRequest instance) {
      return from((_UnmapRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnmapRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnmapRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationName(instance.getApplicationName());
      domain(instance.getDomain());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UnmapRouteRequest#getApplicationName() applicationName} attribute.
     * @param applicationName The value for applicationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationName(String applicationName) {
      this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
      initBits &= ~INIT_BIT_APPLICATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UnmapRouteRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _UnmapRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link _UnmapRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Builds a new {@link UnmapRouteRequest UnmapRouteRequest}.
     * @return An immutable instance of UnmapRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnmapRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnmapRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_NAME) != 0) attributes.add("applicationName");
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      return "Cannot build UnmapRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
