package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _UnbindServiceInstanceRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UnbindServiceInstanceRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_UnbindServiceInstanceRequest"})
public final class UnbindServiceInstanceRequest
    extends org.cloudfoundry.operations.services._UnbindServiceInstanceRequest {
  private final String applicationName;
  private final String serviceInstanceName;

  private UnbindServiceInstanceRequest(UnbindServiceInstanceRequest.Builder builder) {
    this.applicationName = builder.applicationName;
    this.serviceInstanceName = builder.serviceInstanceName;
  }

  /**
   * The name of the application to unbind
   */
  @Override
  public String getApplicationName() {
    return applicationName;
  }

  /**
   * The name of the service instance to unbind
   */
  @Override
  public String getServiceInstanceName() {
    return serviceInstanceName;
  }

  /**
   * This instance is equal to all instances of {@code UnbindServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnbindServiceInstanceRequest
        && equalTo((UnbindServiceInstanceRequest) another);
  }

  private boolean equalTo(UnbindServiceInstanceRequest another) {
    return applicationName.equals(another.applicationName)
        && serviceInstanceName.equals(another.serviceInstanceName);
  }

  /**
   * Computes a hash code from attributes: {@code applicationName}, {@code serviceInstanceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationName.hashCode();
    h = h * 17 + serviceInstanceName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnbindServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnbindServiceInstanceRequest{"
        + "applicationName=" + applicationName
        + ", serviceInstanceName=" + serviceInstanceName
        + "}";
  }

  /**
   * Creates a builder for {@link UnbindServiceInstanceRequest UnbindServiceInstanceRequest}.
   * @return A new UnbindServiceInstanceRequest builder
   */
  public static UnbindServiceInstanceRequest.Builder builder() {
    return new UnbindServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnbindServiceInstanceRequest UnbindServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 0x2L;
    private long initBits = 0x3L;

    private String applicationName;
    private String serviceInstanceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnbindServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnbindServiceInstanceRequest instance) {
      return from((_UnbindServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnbindServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnbindServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationName(instance.getApplicationName());
      serviceInstanceName(instance.getServiceInstanceName());
      return this;
    }

    /**
     * Initializes the value for the {@link _UnbindServiceInstanceRequest#getApplicationName() applicationName} attribute.
     * @param applicationName The value for applicationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationName(String applicationName) {
      this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
      initBits &= ~INIT_BIT_APPLICATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UnbindServiceInstanceRequest#getServiceInstanceName() serviceInstanceName} attribute.
     * @param serviceInstanceName The value for serviceInstanceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String serviceInstanceName) {
      this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_NAME;
      return this;
    }

    /**
     * Builds a new {@link UnbindServiceInstanceRequest UnbindServiceInstanceRequest}.
     * @return An immutable instance of UnbindServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnbindServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnbindServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_NAME) != 0) attributes.add("applicationName");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_NAME) != 0) attributes.add("serviceInstanceName");
      return "Cannot build UnbindServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
