package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _DeleteSpaceRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DeleteSpaceRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DeleteSpaceRequest"})
public final class DeleteSpaceRequest extends org.cloudfoundry.operations.spaces._DeleteSpaceRequest {
  private final String name;

  private DeleteSpaceRequest(DeleteSpaceRequest.Builder builder) {
    this.name = builder.name;
  }

  /**
   * The name of the space
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code DeleteSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteSpaceRequest
        && equalTo((DeleteSpaceRequest) another);
  }

  private boolean equalTo(DeleteSpaceRequest another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteSpaceRequest{"
        + "name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteSpaceRequest DeleteSpaceRequest}.
   * @return A new DeleteSpaceRequest builder
   */
  public static DeleteSpaceRequest.Builder builder() {
    return new DeleteSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteSpaceRequest DeleteSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteSpaceRequest instance) {
      return from((_DeleteSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteSpaceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link DeleteSpaceRequest DeleteSpaceRequest}.
     * @return An immutable instance of DeleteSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build DeleteSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
