package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the enable application ssh operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_EnableApplicationSshRequest"})
public final class EnableApplicationSshRequest
    extends org.cloudfoundry.operations.applications._EnableApplicationSshRequest {
  private final String name;

  private EnableApplicationSshRequest(EnableApplicationSshRequest.Builder builder) {
    this.name = builder.name;
  }

  /**
   * The application name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code EnableApplicationSshRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof EnableApplicationSshRequest
        && equalTo((EnableApplicationSshRequest) another);
  }

  private boolean equalTo(EnableApplicationSshRequest another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EnableApplicationSshRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EnableApplicationSshRequest{"
        + "name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link EnableApplicationSshRequest EnableApplicationSshRequest}.
   * @return A new EnableApplicationSshRequest builder
   */
  public static EnableApplicationSshRequest.Builder builder() {
    return new EnableApplicationSshRequest.Builder();
  }

  /**
   * Builds instances of type {@link EnableApplicationSshRequest EnableApplicationSshRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EnableApplicationSshRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EnableApplicationSshRequest instance) {
      return from((_EnableApplicationSshRequest) instance);
    }

    /**
     * Copy abstract value type {@code _EnableApplicationSshRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_EnableApplicationSshRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _EnableApplicationSshRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link EnableApplicationSshRequest EnableApplicationSshRequest}.
     * @return An immutable instance of EnableApplicationSshRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EnableApplicationSshRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new EnableApplicationSshRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build EnableApplicationSshRequest, some of required attributes are not set " + attributes;
    }
  }
}
