package org.cloudfoundry.operations.organizationadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the create quota operation
 */
@Generated(from = "_CreateQuotaRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateQuotaRequest
    extends org.cloudfoundry.operations.organizationadmin._CreateQuotaRequest {
  private final @Nullable Boolean allowPaidServicePlans;
  private final @Nullable Integer applicationInstanceLimit;
  private final @Nullable Integer instanceMemoryLimit;
  private final @Nullable Integer memoryLimit;
  private final String name;
  private final @Nullable Integer totalReservedRoutePorts;
  private final @Nullable Integer totalRoutes;
  private final @Nullable Integer totalServices;

  private CreateQuotaRequest(CreateQuotaRequest.Builder builder) {
    this.allowPaidServicePlans = builder.allowPaidServicePlans;
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
    this.totalRoutes = builder.totalRoutes;
    this.totalServices = builder.totalServices;
  }

  /**
   * Can provision instances of paid service plans
   */
  @Override
  public @Nullable Boolean getAllowPaidServicePlans() {
    return allowPaidServicePlans;
  }

  /**
   * Total number of application instances
   */
  @Override
  public @Nullable Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The application instance memory limit in mb
   */
  @Override
  public @Nullable Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * Total amount of memory a space can have in mb
   */
  @Override
  public @Nullable Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Maximum number of routes that may be created with reserved ports
   */
  @Override
  public @Nullable Integer getTotalReservedRoutePorts() {
    return totalReservedRoutePorts;
  }

  /**
   * The total number of routes
   */
  @Override
  public @Nullable Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * Total number of service instances
   */
  @Override
  public @Nullable Integer getTotalServices() {
    return totalServices;
  }

  /**
   * This instance is equal to all instances of {@code CreateQuotaRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateQuotaRequest
        && equalTo((CreateQuotaRequest) another);
  }

  private boolean equalTo(CreateQuotaRequest another) {
    return Objects.equals(allowPaidServicePlans, another.allowPaidServicePlans)
        && Objects.equals(applicationInstanceLimit, another.applicationInstanceLimit)
        && Objects.equals(instanceMemoryLimit, another.instanceMemoryLimit)
        && Objects.equals(memoryLimit, another.memoryLimit)
        && name.equals(another.name)
        && Objects.equals(totalReservedRoutePorts, another.totalReservedRoutePorts)
        && Objects.equals(totalRoutes, another.totalRoutes)
        && Objects.equals(totalServices, another.totalServices);
  }

  /**
   * Computes a hash code from attributes: {@code allowPaidServicePlans}, {@code applicationInstanceLimit}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code totalReservedRoutePorts}, {@code totalRoutes}, {@code totalServices}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(allowPaidServicePlans);
    h += (h << 5) + Objects.hashCode(applicationInstanceLimit);
    h += (h << 5) + Objects.hashCode(instanceMemoryLimit);
    h += (h << 5) + Objects.hashCode(memoryLimit);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(totalReservedRoutePorts);
    h += (h << 5) + Objects.hashCode(totalRoutes);
    h += (h << 5) + Objects.hashCode(totalServices);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateQuotaRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateQuotaRequest{"
        + "allowPaidServicePlans=" + allowPaidServicePlans
        + ", applicationInstanceLimit=" + applicationInstanceLimit
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", totalReservedRoutePorts=" + totalReservedRoutePorts
        + ", totalRoutes=" + totalRoutes
        + ", totalServices=" + totalServices
        + "}";
  }

  /**
   * Creates a builder for {@link CreateQuotaRequest CreateQuotaRequest}.
   * <pre>
   * CreateQuotaRequest.builder()
   *    .allowPaidServicePlans(Boolean | null) // nullable {@link CreateQuotaRequest#getAllowPaidServicePlans() allowPaidServicePlans}
   *    .applicationInstanceLimit(Integer | null) // nullable {@link CreateQuotaRequest#getApplicationInstanceLimit() applicationInstanceLimit}
   *    .instanceMemoryLimit(Integer | null) // nullable {@link CreateQuotaRequest#getInstanceMemoryLimit() instanceMemoryLimit}
   *    .memoryLimit(Integer | null) // nullable {@link CreateQuotaRequest#getMemoryLimit() memoryLimit}
   *    .name(String) // required {@link CreateQuotaRequest#getName() name}
   *    .totalReservedRoutePorts(Integer | null) // nullable {@link CreateQuotaRequest#getTotalReservedRoutePorts() totalReservedRoutePorts}
   *    .totalRoutes(Integer | null) // nullable {@link CreateQuotaRequest#getTotalRoutes() totalRoutes}
   *    .totalServices(Integer | null) // nullable {@link CreateQuotaRequest#getTotalServices() totalServices}
   *    .build();
   * </pre>
   * @return A new CreateQuotaRequest builder
   */
  public static CreateQuotaRequest.Builder builder() {
    return new CreateQuotaRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateQuotaRequest CreateQuotaRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateQuotaRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Boolean allowPaidServicePlans;
    private Integer applicationInstanceLimit;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private Integer totalReservedRoutePorts;
    private Integer totalRoutes;
    private Integer totalServices;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateQuotaRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateQuotaRequest instance) {
      return from((_CreateQuotaRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateQuotaRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateQuotaRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean allowPaidServicePlansValue = instance.getAllowPaidServicePlans();
      if (allowPaidServicePlansValue != null) {
        allowPaidServicePlans(allowPaidServicePlansValue);
      }
      Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
      if (applicationInstanceLimitValue != null) {
        applicationInstanceLimit(applicationInstanceLimitValue);
      }
      Integer instanceMemoryLimitValue = instance.getInstanceMemoryLimit();
      if (instanceMemoryLimitValue != null) {
        instanceMemoryLimit(instanceMemoryLimitValue);
      }
      Integer memoryLimitValue = instance.getMemoryLimit();
      if (memoryLimitValue != null) {
        memoryLimit(memoryLimitValue);
      }
      name(instance.getName());
      Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
      if (totalReservedRoutePortsValue != null) {
        totalReservedRoutePorts(totalReservedRoutePortsValue);
      }
      Integer totalRoutesValue = instance.getTotalRoutes();
      if (totalRoutesValue != null) {
        totalRoutes(totalRoutesValue);
      }
      Integer totalServicesValue = instance.getTotalServices();
      if (totalServicesValue != null) {
        totalServices(totalServicesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateQuotaRequest#getAllowPaidServicePlans() allowPaidServicePlans} attribute.
     * @param allowPaidServicePlans The value for allowPaidServicePlans (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowPaidServicePlans(@Nullable Boolean allowPaidServicePlans) {
      this.allowPaidServicePlans = allowPaidServicePlans;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateQuotaRequest#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateQuotaRequest#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateQuotaRequest#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateQuotaRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateQuotaRequest#getTotalReservedRoutePorts() totalReservedRoutePorts} attribute.
     * @param totalReservedRoutePorts The value for totalReservedRoutePorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateQuotaRequest#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateQuotaRequest#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
      return this;
    }

    /**
     * Builds a new {@link CreateQuotaRequest CreateQuotaRequest}.
     * @return An immutable instance of CreateQuotaRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateQuotaRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateQuotaRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateQuotaRequest, some of required attributes are not set " + attributes;
    }
  }
}
