/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ApplicationHealthCheck {
    HTTP("http"),
    NONE("none"),
    PROCESS("process"),
    PORT("port");

    private final String value;

    private ApplicationHealthCheck(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ApplicationHealthCheck from(String s) {
        switch (s.toLowerCase()) {
            case "http": {
                return HTTP;
            }
            case "none": {
                return NONE;
            }
            case "port": {
                return PORT;
            }
            case "process": {
                return PROCESS;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown application health check: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

