/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.organizations;

import java.time.Duration;
import java.util.List;
import java.util.NoSuchElementException;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.featureflags.GetFeatureFlagRequest;
import org.cloudfoundry.client.v2.featureflags.GetFeatureFlagResponse;
import org.cloudfoundry.client.v2.organizationquotadefinitions.GetOrganizationQuotaDefinitionRequest;
import org.cloudfoundry.client.v2.organizationquotadefinitions.GetOrganizationQuotaDefinitionResponse;
import org.cloudfoundry.client.v2.organizationquotadefinitions.ListOrganizationQuotaDefinitionsRequest;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitionEntity;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitionResource;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationManagerByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationManagerByUsernameResponse;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationUserByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationUserByUsernameResponse;
import org.cloudfoundry.client.v2.organizations.CreateOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.DeleteOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationPrivateDomainsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpaceQuotaDefinitionsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpacesRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationEntity;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.organizations.UpdateOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.UpdateOrganizationResponse;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainResource;
import org.cloudfoundry.client.v2.shareddomains.ListSharedDomainsRequest;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainResource;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionEntity;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionResource;
import org.cloudfoundry.client.v2.spaces.SpaceEntity;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.cloudfoundry.operations.organizations.CreateOrganizationRequest;
import org.cloudfoundry.operations.organizations.DeleteOrganizationRequest;
import org.cloudfoundry.operations.organizations.OrganizationDetail;
import org.cloudfoundry.operations.organizations.OrganizationInfoRequest;
import org.cloudfoundry.operations.organizations.OrganizationQuota;
import org.cloudfoundry.operations.organizations.OrganizationSummary;
import org.cloudfoundry.operations.organizations.Organizations;
import org.cloudfoundry.operations.organizations.RenameOrganizationRequest;
import org.cloudfoundry.operations.spaceadmin.SpaceQuota;
import org.cloudfoundry.operations.util.OperationsLogging;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.JobUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple4;

public final class DefaultOrganizations
implements Organizations {
    private static final String SET_ROLES_BY_USERNAME_FEATURE_FLAG = "set_roles_by_username";
    private final Mono<CloudFoundryClient> cloudFoundryClient;
    private final Mono<String> username;

    public DefaultOrganizations(Mono<CloudFoundryClient> cloudFoundryClient, Mono<String> username) {
        this.cloudFoundryClient = cloudFoundryClient;
        this.username = username;
    }

    @Override
    public Mono<Void> create(CreateOrganizationRequest request) {
        return Mono.zip(this.cloudFoundryClient, this.username).flatMap(TupleUtils.function((cloudFoundryClient, username) -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultOrganizations.createOrganization(cloudFoundryClient, request), DefaultOrganizations.getFeatureFlagEnabled(cloudFoundryClient, SET_ROLES_BY_USERNAME_FEATURE_FLAG), (Mono)Mono.just((Object)username)))).filter(TupleUtils.predicate((cloudFoundryClient, organizationId, setRolesByUsernameEnabled, username) -> setRolesByUsernameEnabled)).flatMap(TupleUtils.function((cloudFoundryClient, organizationId, setRolesByUsernameEnabled, username) -> DefaultOrganizations.setOrganizationManager(cloudFoundryClient, organizationId, username))).transform(OperationsLogging.log("Create Organization")).checkpoint();
    }

    @Override
    public Mono<Void> delete(DeleteOrganizationRequest request) {
        return this.cloudFoundryClient.flatMap(cloudFoundryClient -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)request.getCompletionTimeout()), DefaultOrganizations.getOrganizationId(cloudFoundryClient, request.getName()))).flatMap(TupleUtils.function(DefaultOrganizations::deleteOrganization)).transform(OperationsLogging.log("Delete Organization")).checkpoint();
    }

    @Override
    public Mono<OrganizationDetail> get(OrganizationInfoRequest request) {
        return this.cloudFoundryClient.flatMap(cloudFoundryClient -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultOrganizations.getOrganization(cloudFoundryClient, request.getName()))).flatMap(TupleUtils.function((cloudFoundryClient, organizationResource) -> DefaultOrganizations.getAuxiliaryContent(cloudFoundryClient, organizationResource).map(TupleUtils.function((domains, organizationQuota, spacesQuotas, spaces) -> DefaultOrganizations.toOrganizationDetail(domains, organizationQuota, spacesQuotas, spaces, organizationResource, request))))).transform(OperationsLogging.log("Get Organization")).checkpoint();
    }

    @Override
    public Flux<OrganizationSummary> list() {
        return this.cloudFoundryClient.flatMapMany(DefaultOrganizations::requestOrganizations).map(DefaultOrganizations::toOrganizationSummary).transform(OperationsLogging.log("List Organizations")).checkpoint();
    }

    @Override
    public Mono<Void> rename(RenameOrganizationRequest request) {
        return this.cloudFoundryClient.flatMap(cloudFoundryClient -> Mono.zip((Mono)Mono.just((Object)cloudFoundryClient), DefaultOrganizations.getOrganizationId(cloudFoundryClient, request.getName()))).flatMap(TupleUtils.function((cloudFoundryClient, organizationId) -> DefaultOrganizations.requestUpdateOrganization(cloudFoundryClient, organizationId, request.getNewName()))).then().transform(OperationsLogging.log("Rename Organization")).checkpoint();
    }

    private static Mono<String> createOrganization(CloudFoundryClient cloudFoundryClient, CreateOrganizationRequest request) {
        return Mono.justOrEmpty((Object)request.getQuotaDefinitionName()).flatMap(quotaDefinitionName -> DefaultOrganizations.getOrganizationQuotaDefinitionId(cloudFoundryClient, quotaDefinitionName)).flatMap(organizationQuotaDefinitionId -> DefaultOrganizations.getCreateOrganizationId(cloudFoundryClient, request.getOrganizationName(), organizationQuotaDefinitionId)).switchIfEmpty(DefaultOrganizations.getCreateOrganizationId(cloudFoundryClient, request.getOrganizationName(), null));
    }

    private static Mono<Void> deleteOrganization(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, String organizationId) {
        return DefaultOrganizations.requestDeleteOrganization(cloudFoundryClient, organizationId).flatMap(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)completionTimeout, (Resource)job));
    }

    private static Mono<Tuple4<List<String>, OrganizationQuota, List<SpaceQuota>, List<String>>> getAuxiliaryContent(CloudFoundryClient cloudFoundryClient, OrganizationResource organizationResource) {
        String organizationId = ResourceUtils.getId((Resource)organizationResource);
        return Mono.zip(DefaultOrganizations.getDomainNames(cloudFoundryClient, organizationId), DefaultOrganizations.getOrganizationQuota(cloudFoundryClient, organizationResource), DefaultOrganizations.getSpaceQuotas(cloudFoundryClient, organizationId), DefaultOrganizations.getSpaceNames(cloudFoundryClient, organizationId));
    }

    private static Mono<String> getCreateOrganizationId(CloudFoundryClient cloudFoundryClient, String organization, String quotaDefinitionId) {
        return DefaultOrganizations.requestCreateOrganization(cloudFoundryClient, organization, quotaDefinitionId).map(ResourceUtils::getId);
    }

    private static Mono<List<String>> getDomainNames(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return DefaultOrganizations.requestListPrivateDomains(cloudFoundryClient, organizationId).map(resource -> resource.getEntity().getName()).mergeWith((Publisher)DefaultOrganizations.requestListSharedDomains(cloudFoundryClient).map(resource -> resource.getEntity().getName())).collectList();
    }

    private static Mono<Boolean> getFeatureFlagEnabled(CloudFoundryClient cloudFoundryClient, String featureFlag) {
        return DefaultOrganizations.requestGetFeatureFlag(cloudFoundryClient, featureFlag).map(GetFeatureFlagResponse::getEnabled);
    }

    private static Mono<OrganizationResource> getOrganization(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultOrganizations.requestOrganizations(cloudFoundryClient, organization).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Organization %s does not exist", (Object[])new Object[]{organization}));
    }

    private static Mono<String> getOrganizationId(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultOrganizations.getOrganization(cloudFoundryClient, organization).map(ResourceUtils::getId);
    }

    private static Mono<OrganizationQuota> getOrganizationQuota(CloudFoundryClient cloudFoundryClient, OrganizationResource resource) {
        return DefaultOrganizations.requestOrganizationQuotaDefinition(cloudFoundryClient, ((OrganizationEntity)ResourceUtils.getEntity((Resource)resource)).getQuotaDefinitionId()).map(response -> DefaultOrganizations.toOrganizationQuota(response, resource));
    }

    private static Mono<OrganizationQuotaDefinitionResource> getOrganizationQuotaDefinition(CloudFoundryClient cloudFoundryClient, String quotaDefinitionName) {
        return DefaultOrganizations.requestOrganizationQuotaDefinitions(cloudFoundryClient, quotaDefinitionName).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Organization quota %s does not exist", (Object[])new Object[]{quotaDefinitionName}));
    }

    private static Mono<String> getOrganizationQuotaDefinitionId(CloudFoundryClient cloudFoundryClient, String quotaDefinitionName) {
        return DefaultOrganizations.getOrganizationQuotaDefinition(cloudFoundryClient, quotaDefinitionName).map(ResourceUtils::getId);
    }

    private static Mono<List<String>> getSpaceNames(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return DefaultOrganizations.requestSpaces(cloudFoundryClient, organizationId).map(resource -> ((SpaceEntity)ResourceUtils.getEntity((Resource)resource)).getName()).collectList();
    }

    private static Mono<List<SpaceQuota>> getSpaceQuotas(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return DefaultOrganizations.requestSpaceQuotaDefinitions(cloudFoundryClient, organizationId).map(DefaultOrganizations::toSpaceQuota).collectList();
    }

    private static Mono<AssociateOrganizationManagerByUsernameResponse> requestAssociateOrganizationManagerByUsername(CloudFoundryClient cloudFoundryClient, String organizationId, String username) {
        return cloudFoundryClient.organizations().associateManagerByUsername(AssociateOrganizationManagerByUsernameRequest.builder().organizationId(organizationId).username(username).build());
    }

    private static Mono<AssociateOrganizationUserByUsernameResponse> requestAssociateOrganizationUserByUsername(CloudFoundryClient cloudFoundryClient, String organizationId, String username) {
        return cloudFoundryClient.organizations().associateUserByUsername(AssociateOrganizationUserByUsernameRequest.builder().organizationId(organizationId).username(username).build());
    }

    private static Mono<CreateOrganizationResponse> requestCreateOrganization(CloudFoundryClient cloudFoundryClient, String organization, String quotaDefinitionId) {
        return cloudFoundryClient.organizations().create(org.cloudfoundry.client.v2.organizations.CreateOrganizationRequest.builder().name(organization).quotaDefinitionId(quotaDefinitionId).build());
    }

    private static Mono<DeleteOrganizationResponse> requestDeleteOrganization(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return cloudFoundryClient.organizations().delete(org.cloudfoundry.client.v2.organizations.DeleteOrganizationRequest.builder().organizationId(organizationId).async(Boolean.valueOf(true)).build());
    }

    private static Mono<GetFeatureFlagResponse> requestGetFeatureFlag(CloudFoundryClient cloudFoundryClient, String featureFlag) {
        return cloudFoundryClient.featureFlags().get(GetFeatureFlagRequest.builder().name(featureFlag).build());
    }

    private static Flux<PrivateDomainResource> requestListPrivateDomains(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listPrivateDomains(ListOrganizationPrivateDomainsRequest.builder().organizationId(organizationId).page(page).build()));
    }

    private static Flux<SharedDomainResource> requestListSharedDomains(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().page(page).build()));
    }

    private static Mono<GetOrganizationQuotaDefinitionResponse> requestOrganizationQuotaDefinition(CloudFoundryClient cloudFoundryClient, String quotaDefinitionId) {
        return cloudFoundryClient.organizationQuotaDefinitions().get(GetOrganizationQuotaDefinitionRequest.builder().organizationQuotaDefinitionId(quotaDefinitionId).build());
    }

    private static Flux<OrganizationQuotaDefinitionResource> requestOrganizationQuotaDefinitions(CloudFoundryClient cloudFoundryClient, String organizationQuotaDefinition) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizationQuotaDefinitions().list(ListOrganizationQuotaDefinitionsRequest.builder().name(organizationQuotaDefinition).page(page).build()));
    }

    private static Flux<OrganizationResource> requestOrganizations(CloudFoundryClient cloudFoundryClient, String organizationName) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().list(ListOrganizationsRequest.builder().name(organizationName).page(page).build()));
    }

    private static Flux<OrganizationResource> requestOrganizations(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().list(ListOrganizationsRequest.builder().page(page).build()));
    }

    private static Flux<SpaceQuotaDefinitionResource> requestSpaceQuotaDefinitions(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listSpaceQuotaDefinitions(ListOrganizationSpaceQuotaDefinitionsRequest.builder().page(page).organizationId(organizationId).build()));
    }

    private static Flux<SpaceResource> requestSpaces(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listSpaces(ListOrganizationSpacesRequest.builder().page(page).organizationId(organizationId).build()));
    }

    private static Mono<UpdateOrganizationResponse> requestUpdateOrganization(CloudFoundryClient cloudFoundryClient, String organizationId, String newName) {
        return cloudFoundryClient.organizations().update(UpdateOrganizationRequest.builder().organizationId(organizationId).name(newName).build());
    }

    private static Mono<Void> setOrganizationManager(CloudFoundryClient cloudFoundryClient, String organizationId, String username) {
        return Mono.zip(DefaultOrganizations.requestAssociateOrganizationManagerByUsername(cloudFoundryClient, organizationId, username), DefaultOrganizations.requestAssociateOrganizationUserByUsername(cloudFoundryClient, organizationId, username)).then();
    }

    private static OrganizationDetail toOrganizationDetail(List<String> domains, OrganizationQuota organizationQuota, List<SpaceQuota> spacesQuotas, List<String> spaces, OrganizationResource organizationResource, OrganizationInfoRequest organizationInfoRequest) {
        return OrganizationDetail.builder().domains(domains).id(ResourceUtils.getId((Resource)organizationResource)).name(organizationInfoRequest.getName()).quota(organizationQuota).spaceQuotas(spacesQuotas).spaces(spaces).build();
    }

    private static OrganizationQuota toOrganizationQuota(GetOrganizationQuotaDefinitionResponse response, OrganizationResource resource) {
        return OrganizationQuota.builder().id(ResourceUtils.getId((Resource)response)).organizationId(ResourceUtils.getId((Resource)resource)).name(((OrganizationQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)response)).getName()).totalMemoryLimit(((OrganizationQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)response)).getMemoryLimit()).instanceMemoryLimit(((OrganizationQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)response)).getInstanceMemoryLimit()).totalRoutes(((OrganizationQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)response)).getTotalRoutes()).totalServiceInstances(((OrganizationQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)response)).getTotalServices()).paidServicePlans(((OrganizationQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)response)).getNonBasicServicesAllowed()).build();
    }

    private static OrganizationSummary toOrganizationSummary(OrganizationResource resource) {
        return OrganizationSummary.builder().id(ResourceUtils.getId((Resource)resource)).name(((OrganizationEntity)ResourceUtils.getEntity((Resource)resource)).getName()).build();
    }

    private static SpaceQuota toSpaceQuota(SpaceQuotaDefinitionResource resource) {
        return SpaceQuota.builder().id(ResourceUtils.getId((Resource)resource)).organizationId(((SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource)).getOrganizationId()).name(((SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource)).getName()).totalMemoryLimit(((SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource)).getMemoryLimit()).instanceMemoryLimit(((SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource)).getInstanceMemoryLimit()).totalRoutes(((SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource)).getTotalRoutes()).totalServiceInstances(((SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource)).getTotalServices()).paidServicePlans(((SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource)).getNonBasicServicesAllowed()).build();
    }
}

